/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machine.wireless;

import com.enderio.core.common.util.BlockCoord;
import crazypants.enderio.config.Config;
import crazypants.enderio.machine.wireless.IWirelessCharger;
import crazypants.util.BaublesUtil;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;

public class WirelessChargerController {
    public static WirelessChargerController instance = new WirelessChargerController();
    public static final int RANGE = Config.wirelessChargerRange;
    public static final int RANGE_SQ = RANGE * RANGE;
    private final Map<Integer, Map<BlockCoord, IWirelessCharger>> perWorldChargers = new HashMap<Integer, Map<BlockCoord, IWirelessCharger>>();
    private int changeCount;

    private WirelessChargerController() {
    }

    public void registerCharger(IWirelessCharger charger) {
        if (charger == null) {
            return;
        }
        Map<BlockCoord, IWirelessCharger> chargers = this.getChargersForWorld(charger.getWorldObj());
        chargers.put(charger.getLocation(), charger);
        ++this.changeCount;
    }

    public void deregisterCharger(IWirelessCharger capBank) {
        if (capBank == null) {
            return;
        }
        Map<BlockCoord, IWirelessCharger> chargers = this.getChargersForWorld(capBank.getWorldObj());
        chargers.remove(capBank.getLocation());
        ++this.changeCount;
    }

    @SubscribeEvent
    public void onPlayerTick(TickEvent.PlayerTickEvent event) {
        if (event.side == Side.CLIENT || event.phase != TickEvent.Phase.END) {
            return;
        }
        this.chargePlayersItems(event.player);
    }

    public int getChangeCount() {
        return this.changeCount;
    }

    public void getChargers(World world, BlockCoord bc, Collection<IWirelessCharger> res) {
        Map<BlockCoord, IWirelessCharger> chargers = this.getChargersForWorld(world);
        for (IWirelessCharger wc : chargers.values()) {
            if (!this.inRange(wc.getLocation(), bc)) continue;
            res.add(wc);
        }
    }

    public void chargePlayersItems(EntityPlayer player) {
        Map<BlockCoord, IWirelessCharger> chargers = this.getChargersForWorld(player.field_70170_p);
        if (chargers.isEmpty()) {
            return;
        }
        BlockCoord bc = new BlockCoord((Entity)player);
        for (IWirelessCharger capBank : chargers.values()) {
            boolean done;
            if (!capBank.isActive() || !this.inRange(capBank.getLocation(), bc) || !(done = this.chargeFromCapBank(player, capBank))) continue;
            return;
        }
    }

    private boolean inRange(BlockCoord a, BlockCoord b) {
        int dx = a.x - b.x;
        if (dx > RANGE || dx < -RANGE) {
            return false;
        }
        int dz = a.z - b.z;
        if (dz > RANGE || dz < -RANGE) {
            return false;
        }
        return a.getDistSq(b) <= RANGE_SQ;
    }

    private boolean chargeFromCapBank(EntityPlayer player, IWirelessCharger capBank) {
        boolean res = capBank.chargeItems(player.field_71071_by.field_70460_b);
        res |= capBank.chargeItems(player.field_71071_by.field_70462_a);
        res |= capBank.chargeItems(player.field_71071_by.field_184439_c);
        IInventory baubles = BaublesUtil.instance().getBaubles(player);
        if (baubles != null) {
            ItemStack[] item = new ItemStack[1];
            for (int i = 0; i < baubles.func_70302_i_(); ++i) {
                item[0] = baubles.func_70301_a(i);
                if (!capBank.chargeItems(item)) continue;
                baubles.func_70299_a(i, item[0]);
                res = true;
            }
        }
        return res;
    }

    private Map<BlockCoord, IWirelessCharger> getChargersForWorld(World world) {
        Map<BlockCoord, IWirelessCharger> res = this.perWorldChargers.get(world.field_73011_w.getDimension());
        if (res == null) {
            res = new HashMap<BlockCoord, IWirelessCharger>();
            this.perWorldChargers.put(world.field_73011_w.getDimension(), res);
        }
        return res;
    }

    public Collection<IWirelessCharger> getChargers(World world) {
        return this.getChargerMap(world).values();
    }

    public Map<BlockCoord, IWirelessCharger> getChargerMap(World world) {
        return this.perWorldChargers.get(world.field_73011_w.getDimension());
    }

    static {
        MinecraftForge.EVENT_BUS.register((Object)instance);
    }
}

