/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.material;

import crazypants.enderio.EnderIO;
import crazypants.util.NullHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.ResourceLocation;
import org.apache.commons.lang3.StringUtils;

public enum Alloy implements IStringSerializable
{
    ELECTRICAL_STEEL("electricalSteel", 6.0f),
    ENERGETIC_ALLOY("energeticAlloy", 7.0f),
    VIBRANT_ALLOY("vibrantAlloy", 4.0f),
    REDSTONE_ALLOY("redstoneAlloy", 1.0f),
    CONDUCTIVE_IRON("conductiveIron", 5.2f),
    PULSATING_IRON("pulsatingIron", 7.0f),
    DARK_STEEL("darkSteel", 10.0f),
    SOULARIUM("soularium", 10.0f);

    @Nonnull
    public final String baseName;
    @Nonnull
    public final String unlocalisedName;
    @Nonnull
    public final String iconKey;
    @Nonnull
    private final List<String> oreIngots = new ArrayList<String>();
    @Nonnull
    private final List<String> oreBlocks = new ArrayList<String>();
    private final float hardness;

    public static List<ResourceLocation> resources() {
        ArrayList<ResourceLocation> res = new ArrayList<ResourceLocation>(Alloy.values().length);
        for (Alloy a : Alloy.values()) {
            res.add(new ResourceLocation(a.iconKey));
        }
        return res;
    }

    private Alloy(@Nullable String baseName, float hardness, String oreDictName) {
        this.baseName = baseName;
        this.unlocalisedName = "enderio." + baseName;
        this.iconKey = "enderio:" + baseName;
        if (oreDictName != null) {
            this.oreIngots.add("ingot" + StringUtils.capitalize((String)oreDictName));
            this.oreBlocks.add("block" + StringUtils.capitalize((String)oreDictName));
        }
        this.oreIngots.add("ingot" + StringUtils.capitalize((String)baseName));
        this.oreBlocks.add("block" + StringUtils.capitalize((String)baseName));
        this.hardness = hardness;
    }

    private Alloy(String baseName, float hardness) {
        this(baseName, hardness, null);
    }

    @Nonnull
    public String getBaseName() {
        return this.baseName;
    }

    public float getHardness() {
        return this.hardness;
    }

    @Nonnull
    public ItemStack getStackIngot() {
        return this.getStackIngot(1);
    }

    @Nonnull
    public ItemStack getStackIngot(int size) {
        return new ItemStack((Item)EnderIO.itemAlloy, size, this.ordinal());
    }

    @Nonnull
    public ItemStack getStackBlock() {
        return this.getStackBlock(1);
    }

    @Nonnull
    public ItemStack getStackBlock(int size) {
        return new ItemStack((Block)EnderIO.blockIngotStorage, size, this.ordinal());
    }

    @Nonnull
    public String getOreIngot() {
        return NullHelper.notnull(this.oreIngots.get(0), "Data corruption");
    }

    @Nonnull
    public String getOreBlock() {
        return NullHelper.notnull(this.oreBlocks.get(0), "Data corruption");
    }

    @Nonnull
    public List<String> getOreIngots() {
        return this.oreIngots;
    }

    @Nonnull
    public List<String> getOreBlocks() {
        return this.oreBlocks;
    }

    @Nonnull
    public String func_176610_l() {
        return NullHelper.notnullJ(this.baseName.toLowerCase(Locale.ENGLISH), "String.toLowerCase()");
    }

    @Nonnull
    public static Alloy getTypeFromMeta(int meta) {
        return NullHelper.notnullJ(Alloy.values()[meta >= 0 && meta < Alloy.values().length ? meta : 0], "Enum.values()");
    }

    public static int getMetaFromType(Alloy value) {
        return value.ordinal();
    }
}

