/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.material;

import com.enderio.core.api.common.util.ITankAccess;
import com.enderio.core.common.util.FluidUtil;
import crazypants.enderio.EnderIO;
import crazypants.enderio.fluid.Fluids;
import crazypants.enderio.material.Material;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.world.World;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.oredict.OreDictionary;
import org.apache.commons.lang3.ArrayUtils;

public class NutritiousStickRecipe
implements IRecipe {
    public boolean func_77569_a(InventoryCrafting inv, World worldIn) {
        boolean foundStick = false;
        boolean foundFluid = false;
        for (int i = 0; !(i >= inv.func_70302_i_() || foundStick && foundFluid); ++i) {
            ItemStack stack = inv.func_70301_a(i);
            if (stack == null) continue;
            if (!foundStick) {
                foundStick = this.isStick(stack);
            }
            if (foundFluid) continue;
            FluidUtil.FluidAndStackResult fill = FluidUtil.tryDrainContainer((ItemStack)stack, (ITankAccess)new NutDistTank());
            if (fill.result.fluidStack == null || fill.result.fluidStack.amount < 1000) continue;
            foundFluid = true;
        }
        return foundStick && foundFluid;
    }

    private boolean isStick(ItemStack stack) {
        int oreId = OreDictionary.getOreID((String)"stickWood");
        int[] ids = OreDictionary.getOreIDs((ItemStack)stack);
        return ids != null && ArrayUtils.contains((int[])ids, (int)oreId);
    }

    public ItemStack func_77572_b(InventoryCrafting inv) {
        return new ItemStack((Item)EnderIO.itemMaterial, 1, Material.NUTRITIOUS_STICK.ordinal());
    }

    public int func_77570_a() {
        return 2;
    }

    public ItemStack func_77571_b() {
        return new ItemStack((Item)EnderIO.itemMaterial, 1, Material.NUTRITIOUS_STICK.ordinal());
    }

    public ItemStack[] func_179532_b(InventoryCrafting inv) {
        ItemStack[] result = new ItemStack[inv.func_70302_i_()];
        for (int slot = 0; slot < inv.func_70302_i_(); ++slot) {
            result[slot] = this.getResult(inv.func_70301_a(slot));
        }
        return result;
    }

    private ItemStack getResult(ItemStack in) {
        if (in != null) {
            FluidUtil.FluidAndStackResult fill = FluidUtil.tryDrainContainer((ItemStack)in, (ITankAccess)new NutDistTank());
            if (fill.result.fluidStack != null && fill.result.fluidStack.amount >= 1000) {
                return fill.result.itemStack;
            }
        }
        return null;
    }

    private static class NutDistTank
    implements ITankAccess {
        private FluidTank inputTank = new FluidTank(Fluids.fluidNutrientDistillation, 0, 1000);

        private NutDistTank() {
        }

        public FluidTank getInputTank(FluidStack forFluidType) {
            if (forFluidType == null || FluidUtil.areFluidsTheSame((Fluid)Fluids.fluidNutrientDistillation, (Fluid)forFluidType.getFluid())) {
                return this.inputTank;
            }
            return null;
        }

        public FluidTank[] getOutputTanks() {
            return new FluidTank[0];
        }

        public void setTanksDirty() {
        }
    }
}

