/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.paint.render;

import com.enderio.core.common.util.IBlockAccessWrapper;
import crazypants.enderio.paint.IPaintable;
import crazypants.util.FacadeUtil;
import net.minecraft.block.state.IBlockState;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;

public class PaintedBlockAccessWrapper
extends IBlockAccessWrapper {
    private static final ThreadLocal<PaintedBlockAccessWrapper> factory = new ThreadLocal<PaintedBlockAccessWrapper>(){

        @Override
        protected PaintedBlockAccessWrapper initialValue() {
            return new PaintedBlockAccessWrapper();
        }
    };

    public static PaintedBlockAccessWrapper instance(IBlockAccess ba) {
        return factory.get().setWorld(ba);
    }

    private PaintedBlockAccessWrapper() {
        super(null);
    }

    public PaintedBlockAccessWrapper setWorld(IBlockAccess ba) {
        this.wrapped = ba;
        return this;
    }

    public void free() {
        this.wrapped = null;
    }

    public boolean isSideSolid(BlockPos pos, EnumFacing side, boolean _default) {
        IBlockState paintSource = this.getPaintSource(pos);
        if (paintSource != null) {
            return paintSource.func_177230_c().isSideSolid(paintSource, (IBlockAccess)this, pos, side);
        }
        return super.isSideSolid(pos, side, _default);
    }

    public TileEntity func_175625_s(BlockPos pos) {
        IBlockState paintSource = this.getPaintSource(pos);
        if (paintSource != null && paintSource != super.func_180495_p(pos)) {
            throw new RuntimeException("Block needs a TileEntity");
        }
        return super.func_175625_s(pos);
    }

    public TileEntity getRealTileEntity(BlockPos pos) {
        return this.wrapped.func_175625_s(pos);
    }

    public IBlockState func_180495_p(BlockPos pos) {
        IBlockState paintSource = this.getPaintSource(pos);
        if (paintSource != null) {
            return paintSource;
        }
        return super.func_180495_p(pos);
    }

    private IBlockState getPaintSource(BlockPos pos) {
        IBlockState state = super.func_180495_p(pos);
        if (state.func_177230_c() instanceof IPaintable.IBlockPaintableBlock) {
            return ((IPaintable.IBlockPaintableBlock)state.func_177230_c()).getPaintSource(state, this.wrapped, pos);
        }
        return FacadeUtil.instance.getFacade(state, this.wrapped, pos, null);
    }
}

