/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.power.tesla;

import net.darkhax.tesla.api.ITeslaConsumer;
import net.darkhax.tesla.api.ITeslaHolder;
import net.darkhax.tesla.api.ITeslaProducer;
import net.darkhax.tesla.capability.TeslaCapabilities;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.energy.IEnergyStorage;

public class ForgeToTeslaAdapter
implements ITeslaConsumer,
ITeslaHolder,
ITeslaProducer,
ICapabilityProvider {
    private IEnergyStorage delegate;

    public ForgeToTeslaAdapter(IEnergyStorage delegate) {
        this.delegate = delegate;
    }

    public long takePower(long power, boolean simulated) {
        if (this.delegate.canExtract()) {
            return this.delegate.extractEnergy((int)power, simulated);
        }
        return 0L;
    }

    public long getStoredPower() {
        return this.delegate.getEnergyStored();
    }

    public long getCapacity() {
        return this.delegate.getMaxEnergyStored();
    }

    public long givePower(long power, boolean simulated) {
        if (this.delegate.canReceive()) {
            return this.delegate.receiveEnergy((int)power, simulated);
        }
        return 0L;
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        if (capability == TeslaCapabilities.CAPABILITY_HOLDER) {
            return true;
        }
        if (capability == TeslaCapabilities.CAPABILITY_CONSUMER && this.delegate.canReceive()) {
            return true;
        }
        return capability == TeslaCapabilities.CAPABILITY_PRODUCER && this.delegate.canExtract();
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (this.hasCapability(capability, facing)) {
            return (T)this;
        }
        return null;
    }
}

