/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.power.tesla;

import crazypants.enderio.power.IInternalPoweredItem;
import crazypants.util.NbtValue;
import javax.annotation.Nullable;
import net.darkhax.tesla.api.ITeslaConsumer;
import net.darkhax.tesla.api.ITeslaHolder;
import net.darkhax.tesla.api.ITeslaProducer;
import net.darkhax.tesla.capability.TeslaCapabilities;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;

public class InternalPoweredItemWrapper
implements ITeslaConsumer,
ITeslaHolder,
ITeslaProducer {
    protected final ItemStack container;
    protected int capacity;
    protected int maxInput;
    protected int maxOutput;

    public InternalPoweredItemWrapper(ItemStack stack, IInternalPoweredItem item) {
        this(stack, item.getMaxEnergyStored(stack), item.getMaxInput(stack), item.getMaxOutput(stack));
    }

    public InternalPoweredItemWrapper(ItemStack container, int capacity, int maxInput, int maxOutput) {
        this.container = container;
        this.capacity = capacity;
        this.maxInput = maxInput;
        this.maxOutput = maxOutput;
    }

    public void setEnergyStored(int energy) {
        NbtValue.ENERGY.setInt(this.container, MathHelper.func_76125_a((int)energy, (int)0, (int)this.capacity));
    }

    public long getStoredPower() {
        return NbtValue.ENERGY.getInt(this.container);
    }

    public long getCapacity() {
        return this.capacity;
    }

    public long givePower(long maxReceive, boolean simulated) {
        if (!this.canReceive()) {
            return 0L;
        }
        int energy = this.getEnergyStored();
        int energyReceived = Math.min(this.capacity - energy, Math.min(this.maxInput, (int)maxReceive));
        if (!simulated) {
            this.setEnergyStored(energy += energyReceived);
        }
        return energyReceived;
    }

    public long takePower(long power, boolean simulated) {
        if (!this.canExtract()) {
            return 0L;
        }
        int energy = this.getEnergyStored();
        int energyExtracted = Math.min(energy, Math.min(this.maxOutput, (int)power));
        if (!simulated) {
            this.setEnergyStored(energy -= energyExtracted);
        }
        return energyExtracted;
    }

    public int getEnergyStored() {
        return NbtValue.ENERGY.getInt(this.container);
    }

    public boolean canExtract() {
        return this.maxOutput > 0;
    }

    public boolean canReceive() {
        return this.maxInput > 0;
    }

    public static class PoweredItemCapabilityProvider
    implements ICapabilityProvider {
        private final IInternalPoweredItem item;
        private final ItemStack stack;

        public PoweredItemCapabilityProvider(IInternalPoweredItem item, ItemStack stack) {
            this.item = item;
            this.stack = stack;
        }

        public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
            return capability == TeslaCapabilities.CAPABILITY_CONSUMER || capability == TeslaCapabilities.CAPABILITY_HOLDER || capability == TeslaCapabilities.CAPABILITY_PRODUCER;
        }

        public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
            InternalPoweredItemWrapper res;
            if (capability == TeslaCapabilities.CAPABILITY_CONSUMER || capability == TeslaCapabilities.CAPABILITY_HOLDER) {
                return (T)new InternalPoweredItemWrapper(this.stack, this.item);
            }
            if (capability == TeslaCapabilities.CAPABILITY_PRODUCER && (res = new InternalPoweredItemWrapper(this.stack, this.item)).canExtract()) {
                return (T)res;
            }
            return null;
        }
    }
}

