/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.render.property;

import com.google.common.base.Optional;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import crazypants.enderio.render.property.IOMode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import net.minecraft.block.properties.PropertyHelper;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class PropertyIO
extends PropertyHelper<IOMode> {
    private static final ImmutableSet<IOMode> allowedValues;
    private static final Map<String, IOMode> nameToValue;
    private static PropertyIO instance;

    protected PropertyIO(String name) {
        super(name, IOMode.class);
    }

    public static PropertyIO getInstance() {
        return instance;
    }

    public Collection<IOMode> func_177700_c() {
        return allowedValues;
    }

    public String getName(IOMode value) {
        return value.toString();
    }

    @SideOnly(value=Side.CLIENT)
    public Optional<IOMode> func_185929_b(String value) {
        return Optional.fromNullable((Object)nameToValue.get(value));
    }

    static {
        nameToValue = Maps.newHashMap();
        ArrayList<IOMode> values = new ArrayList<IOMode>();
        for (EnumFacing facing : EnumFacing.values()) {
            for (IOMode.EnumIOMode mode : IOMode.EnumIOMode.values()) {
                IOMode value = IOMode.get(facing, mode);
                values.add(value);
                nameToValue.put(value.toString(), value);
            }
        }
        allowedValues = ImmutableSet.copyOf(values);
        instance = new PropertyIO("iomode");
    }
}

