/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.render.registry;

import crazypants.enderio.EnderIO;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TextureRegistry {
    private static final TextureSupplier noSupplier = new TextureSupplier(){

        @Override
        public <T> T get(Class<T> clazz) {
            return null;
        }
    };
    private static TextureRegistryServer instance;

    public static TextureSupplier registerTexture(String location) {
        return TextureRegistry.registerTexture(location, true);
    }

    public static TextureSupplier registerTexture(String location, boolean prependDomain) {
        if (instance == null) {
            instance = new TextureRegistryClient();
            instance.init();
        }
        return instance.registerTexture(location, prependDomain);
    }

    private TextureRegistry() {
    }

    private static class TextureRegistryClient
    extends TextureRegistryServer {
        @SideOnly(value=Side.CLIENT)
        private Map<String, TextureAtlasSprite> sprites;

        private TextureRegistryClient() {
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        protected void init() {
            this.sprites = new HashMap<String, TextureAtlasSprite>();
            MinecraftForge.EVENT_BUS.register((Object)instance);
        }

        @SideOnly(value=Side.CLIENT)
        @SubscribeEvent
        public void onIconLoad(TextureStitchEvent.Pre event) {
            for (Map.Entry<String, TextureAtlasSprite> entry : this.sprites.entrySet()) {
                entry.setValue(event.getMap().func_174942_a(new ResourceLocation(entry.getKey())));
            }
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        public TextureSupplier registerTexture(String location, boolean prependModID) {
            String keyF;
            String key = location;
            if (prependModID) {
                key = EnderIO.DOMAIN + ":" + location;
            }
            if (!this.sprites.containsKey(keyF = key)) {
                this.sprites.put(keyF, null);
            }
            return new TextureSupplier(){

                @Override
                public <T> T get(Class<T> clazz) {
                    if (clazz == TextureAtlasSprite.class) {
                        return (T)TextureRegistryClient.this.sprites.get(keyF);
                    }
                    return null;
                }
            };
        }
    }

    private static class TextureRegistryServer {
        private TextureRegistryServer() {
        }

        protected void init() {
        }

        public TextureSupplier registerTexture(String location, boolean prependDomain) {
            return noSupplier;
        }
    }

    public static interface TextureSupplier {
        public <T> T get(Class<T> var1);
    }
}

