/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.teleport;

import com.enderio.core.api.client.gui.IResourceTooltipProvider;
import com.enderio.core.common.transform.EnderCoreMethods;
import crazypants.enderio.EnderIO;
import crazypants.enderio.EnderIOTab;
import crazypants.enderio.ModObject;
import crazypants.enderio.api.teleport.IItemOfTravel;
import crazypants.enderio.api.teleport.TravelSource;
import crazypants.enderio.config.Config;
import crazypants.enderio.item.PowerBarOverlayRenderHelper;
import crazypants.enderio.machine.power.PowerDisplayUtil;
import crazypants.enderio.power.AbstractPoweredItem;
import crazypants.enderio.teleport.TravelController;
import java.util.List;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.common.registry.IForgeRegistryEntry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemTravelStaff
extends AbstractPoweredItem
implements IItemOfTravel,
IResourceTooltipProvider,
EnderCoreMethods.IOverlayRenderAware {
    private long lastBlickTick = 0L;

    public static ItemTravelStaff create() {
        ItemTravelStaff result = new ItemTravelStaff();
        result.init();
        return result;
    }

    protected ItemTravelStaff() {
        super(Config.darkSteelPowerStorageLevelTwo, Config.darkSteelPowerStorageLevelTwo / 100, 0);
        this.func_77637_a(EnderIOTab.tabEnderIO);
        this.func_77655_b(ModObject.itemTravelStaff.getUnlocalisedName());
        this.setRegistryName(ModObject.itemTravelStaff.getUnlocalisedName());
        this.func_77625_d(1);
        this.func_77627_a(true);
    }

    protected void init() {
        GameRegistry.register((IForgeRegistryEntry)this);
    }

    public void func_77622_d(ItemStack itemStack, World world, EntityPlayer entityPlayer) {
        this.setEnergyStored(itemStack, 0);
    }

    public ActionResult<ItemStack> func_77659_a(ItemStack equipped, World world, EntityPlayer player, EnumHand hand) {
        if (player.func_70093_af()) {
            long ticksSinceBlink = EnderIO.proxy.getTickCount() - this.lastBlickTick;
            if (ticksSinceBlink < 0L) {
                this.lastBlickTick = -1L;
            }
            if (Config.travelStaffBlinkEnabled && world.field_72995_K && ticksSinceBlink >= (long)Config.travelStaffBlinkPauseTicks && TravelController.instance.doBlink(equipped, hand, player)) {
                player.func_184609_a(hand);
                this.lastBlickTick = EnderIO.proxy.getTickCount();
            }
            return new ActionResult(EnumActionResult.SUCCESS, (Object)equipped);
        }
        if (world.field_72995_K) {
            TravelController.instance.activateTravelAccessable(equipped, hand, world, player, TravelSource.STAFF);
        }
        player.func_184609_a(hand);
        return new ActionResult(EnumActionResult.SUCCESS, (Object)equipped);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack itemStack, EntityPlayer par2EntityPlayer, List<String> list, boolean par4) {
        super.func_77624_a(itemStack, par2EntityPlayer, list, par4);
        String str = PowerDisplayUtil.formatPower(this.getEnergyStored(itemStack)) + "/" + PowerDisplayUtil.formatPower(this.getMaxEnergyStored(itemStack)) + " " + PowerDisplayUtil.abrevation();
        list.add(str);
    }

    @Override
    public void extractInternal(ItemStack item, int powerUse) {
        int res = Math.max(0, this.getEnergyStored(item) - powerUse);
        this.setEnergyStored(item, res);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(Item item, CreativeTabs par2CreativeTabs, List<ItemStack> par3List) {
        ItemStack is = new ItemStack((Item)this);
        par3List.add(is);
        is = new ItemStack((Item)this);
        this.setFull(is);
        par3List.add(is);
    }

    public String getUnlocalizedNameForTooltip(ItemStack stack) {
        return this.func_77658_a();
    }

    @Override
    public boolean isActive(EntityPlayer ep, ItemStack equipped) {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_77662_d() {
        return true;
    }

    public void renderItemOverlayIntoGUI(ItemStack stack, int xPosition, int yPosition) {
        PowerBarOverlayRenderHelper.instance.render(stack, xPosition, yPosition);
    }
}

