/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.teleport.telepad.gui;

import com.enderio.core.api.client.gui.IGuiScreen;
import com.enderio.core.api.common.util.IProgressTile;
import com.enderio.core.client.gui.widget.GuiToolTip;
import com.enderio.core.common.BlockEnder;
import com.enderio.core.common.util.BlockCoord;
import com.enderio.core.common.util.Util;
import crazypants.enderio.EnderIO;
import crazypants.enderio.gui.GuiContainerBaseEIO;
import crazypants.enderio.machine.power.PowerDisplayUtil;
import crazypants.enderio.network.PacketHandler;
import crazypants.enderio.teleport.telepad.TelepadTarget;
import crazypants.enderio.teleport.telepad.TileDialingDevice;
import crazypants.enderio.teleport.telepad.TileTelePad;
import crazypants.enderio.teleport.telepad.gui.ContainerDialingDevice;
import crazypants.enderio.teleport.telepad.gui.GuiTargetList;
import crazypants.enderio.teleport.telepad.packet.PacketSetTarget;
import java.awt.Rectangle;
import java.io.IOException;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import org.lwjgl.opengl.GL11;

public class GuiDialingDevice
extends GuiContainerBaseEIO {
    private static final int ID_TELEPORT_BUTTON = 96;
    GuiButton teleportButton;
    private final TileDialingDevice dialingDevice;
    private final TileTelePad telepad;
    private int powerX = 8;
    private int powerY = 9;
    private int powerScale = 120;
    private int progressX = 26;
    private int progressY = 110;
    private int progressScale = 124;
    private final GuiTargetList targetList;

    public GuiDialingDevice(InventoryPlayer playerInv, TileDialingDevice te) {
        super((Container)new ContainerDialingDevice(playerInv, te), "dialingDevice");
        this.dialingDevice = te;
        this.telepad = this.findTelepad();
        this.field_147000_g = 220;
        this.addToolTip(new GuiToolTip(new Rectangle(this.powerX, this.powerY, 10, this.powerScale), new String[]{""}){

            protected void updateText() {
                this.text.clear();
                GuiDialingDevice.this.updatePowerBarTooltip(this.text);
            }
        });
        this.addToolTip(new GuiToolTip(new Rectangle(this.progressX, this.progressY, this.progressScale, 10), new String[]{""}){

            protected void updateText() {
                this.text.clear();
                if (GuiDialingDevice.this.telepad != null) {
                    this.text.add(Math.round(GuiDialingDevice.this.telepad.getProgress() * 100.0f) + "%");
                }
            }
        });
        int w = 115;
        int h = 71;
        int x = 30;
        int y = 10;
        this.targetList = new GuiTargetList(w, h, x, y, te);
        this.targetList.setShowSelectionBox(true);
        this.targetList.setScrollButtonIds(100, 101);
        if (this.telepad != null) {
            this.targetList.setSelection(this.telepad.getTarget());
        }
        this.addToolTip(new GuiToolTip(new Rectangle(x, y, w, h), new String[]{""}){

            protected void updateText() {
                this.text.clear();
                TelepadTarget el = (TelepadTarget)GuiDialingDevice.this.targetList.getElementAt(this.getLastMouseX() + GuiDialingDevice.this.getGuiLeft(), this.getLastMouseY());
                if (el != null) {
                    Rectangle iconBnds = GuiDialingDevice.this.targetList.getIconBounds(0);
                    if (iconBnds.contains(this.getLastMouseX() + GuiDialingDevice.this.getGuiLeft(), 1)) {
                        this.text.add(TextFormatting.RED + "Delete");
                    } else {
                        this.text.add(TextFormatting.WHITE + el.getName());
                        this.text.add(BlockCoord.chatString((BlockPos)el.getLocation()));
                        this.text.add(el.getDimenionName());
                    }
                }
            }
        });
    }

    private TileTelePad findTelepad() {
        EnumFacing side;
        EnumFacing up;
        BlockPos pos = this.dialingDevice.func_174877_v();
        EnumFacing forward = this.dialingDevice.getFacing().getInputSide();
        if (forward.func_96559_d() == 0) {
            up = EnumFacing.UP;
            side = forward.func_176746_e();
        } else {
            up = EnumFacing.NORTH;
            side = EnumFacing.EAST;
        }
        int range = 4;
        TileTelePad result = null;
        for (int i = 0; i < range * 2; ++i) {
            for (int j = 0; j < range * 2; ++j) {
                for (int k = 0; k < range * 2; ++k) {
                    BlockPos check = pos.func_177967_a(forward, i + 1).func_177967_a(side, j - range).func_177967_a(up, k - range);
                    result = (TileTelePad)BlockEnder.getAnyTileEntitySafe((IBlockAccess)this.dialingDevice.func_145831_w(), (BlockPos)check, TileTelePad.class);
                    if (result == null) continue;
                    return result.getMaster();
                }
            }
        }
        return result;
    }

    private String getPowerOutputLabel() {
        return I18n.func_135052_a((String)"enderio.gui.max", (Object[])new Object[0]);
    }

    protected int getPowerOutputValue() {
        return this.dialingDevice.getUsage();
    }

    protected void updatePowerBarTooltip(List<String> text) {
        text.add(this.getPowerOutputLabel() + " " + PowerDisplayUtil.formatPower(this.getPowerOutputValue()) + " " + PowerDisplayUtil.abrevation() + PowerDisplayUtil.perTickStr());
        text.add(PowerDisplayUtil.formatStoredPower(this.dialingDevice.getEnergyStored(), this.dialingDevice.getMaxEnergyStored(null)));
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        String text = EnderIO.lang.localize("gui.telepad.teleport");
        int width = this.getFontRenderer().func_78256_a(text) + 10;
        int x = this.field_147003_i + this.field_146999_f / 2 - width / 2;
        int y = this.field_147009_r + 85;
        this.teleportButton = new GuiButton(96, x, y, width, 20, text);
        this.addButton(this.teleportButton);
        ((ContainerDialingDevice)this.field_147002_h).createGhostSlots(this.getGhostSlots());
        this.targetList.onGuiInit((IGuiScreen)this);
    }

    public void func_73876_c() {
        super.func_73876_c();
    }

    protected void func_146976_a(float partialTick, int mouseX, int mouseY) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.bindGuiTexture();
        int sx = (this.field_146294_l - this.field_146999_f) / 2;
        int sy = (this.field_146295_m - this.field_147000_g) / 2;
        this.func_73729_b(sx, sy, 0, 0, this.field_146999_f, this.field_147000_g);
        int powerScaled = this.dialingDevice.getPowerScaled(this.powerScale);
        this.func_73729_b(sx + this.powerX, sy + this.powerY + this.powerScale - powerScaled, this.field_146999_f, 0, 10, powerScaled);
        this.targetList.drawScreen(mouseX, mouseY, partialTick);
        super.func_146976_a(partialTick, mouseX, mouseY);
        if (this.dialingDevice.getEnergyStored() < this.dialingDevice.getUsage()) {
            String txt = TextFormatting.DARK_RED + "No Power";
            this.renderInfoMessage(sx, sy, txt, 0);
            return;
        }
        if (this.telepad == null) {
            String txt = TextFormatting.DARK_RED + "No Telepad";
            this.renderInfoMessage(sx, sy, txt, 0);
            return;
        }
        if (this.telepad.getEnergyStored(null) <= 0) {
            String txt = TextFormatting.DARK_RED + "Telepad not powered";
            this.renderInfoMessage(sx, sy, txt, 0);
            return;
        }
        if (this.targetList.getSelectedElement() == null) {
            String txt = TextFormatting.DARK_RED + "Enter Target";
            this.renderInfoMessage(sx, sy, txt, 0);
            return;
        }
        this.bindGuiTexture();
        int progressScaled = Util.getProgressScaled((int)this.progressScale, (IProgressTile)this.telepad);
        this.func_73729_b(sx + this.progressX, sy + this.progressY, 0, this.field_147000_g, progressScaled, 10);
        Entity e = this.telepad.getCurrentTarget();
        if (e != null) {
            String name = e.func_70005_c_();
            this.renderInfoMessage(sx, sy, name, 0);
        } else if (this.telepad.wasBlocked()) {
            String s = EnderIO.lang.localize("gui.telepad.blocked");
            this.renderInfoMessage(sx, sy, s, 0xAA0000);
        }
    }

    private void renderInfoMessage(int sx, int sy, String txt, int color) {
        FontRenderer fnt = Minecraft.func_71410_x().field_71466_p;
        fnt.func_78276_b(txt, sx + this.field_146999_f / 2 - fnt.func_78256_a(txt) / 2, sy + this.progressY + fnt.field_78288_b + 6, color);
    }

    protected void func_146284_a(GuiButton button) throws IOException {
        TelepadTarget target;
        super.func_146284_a(button);
        if (button.field_146127_k == 96 && (target = (TelepadTarget)this.targetList.getSelectedElement()) != null && this.dialingDevice.getEnergyStored() > 0 && this.telepad != null) {
            this.telepad.setTarget(target);
            PacketHandler.INSTANCE.sendToServer((IMessage)new PacketSetTarget(this.telepad, target));
            this.telepad.teleportAll();
        }
    }
}

