/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsdim.blocks.absorbers;

import java.util.List;
import mcjty.lib.container.EmptyContainer;
import mcjty.rftoolsdim.blocks.GenericRFToolsBlock;
import mcjty.rftoolsdim.blocks.absorbers.LiquidAbsorberTileEntity;
import mcjty.rftoolsdim.config.DimletConstructionConfiguration;
import mcjty.theoneprobe.api.IProbeHitData;
import mcjty.theoneprobe.api.IProbeInfo;
import mcjty.theoneprobe.api.ProbeMode;
import mcp.mobius.waila.api.IWailaConfigHandler;
import mcp.mobius.waila.api.IWailaDataAccessor;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.input.Keyboard;

public class LiquidAbsorberBlock
extends GenericRFToolsBlock<LiquidAbsorberTileEntity, EmptyContainer> {
    public LiquidAbsorberBlock() {
        super(Material.field_151573_f, LiquidAbsorberTileEntity.class, EmptyContainer.class, "liquid_absorber", false);
    }

    public boolean hasNoRotation() {
        return true;
    }

    public void addProbeInfo(ProbeMode mode, IProbeInfo probeInfo, EntityPlayer player, World world, IBlockState blockState, IProbeHitData data) {
        LiquidAbsorberTileEntity tileEntity;
        super.addProbeInfo(mode, probeInfo, player, world, blockState, data);
        TileEntity te = world.func_175625_s(data.getPos());
        if (te instanceof LiquidAbsorberTileEntity && (tileEntity = (LiquidAbsorberTileEntity)te).getBlock() != null) {
            Block block = tileEntity.getBlock();
            Fluid fluid = FluidRegistry.lookupFluidForBlock((Block)block);
            int absorbing = tileEntity.getAbsorbing();
            int pct = (DimletConstructionConfiguration.maxLiquidAbsorbtion - absorbing) * 100 / DimletConstructionConfiguration.maxLiquidAbsorbtion;
            probeInfo.text(TextFormatting.GREEN + "Liquid: " + new FluidStack(fluid, 1).getLocalizedName()).progress(pct, 100, probeInfo.defaultProgressStyle().suffix("%"));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public List<String> getWailaBody(ItemStack itemStack, List<String> currenttip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        Block block;
        Fluid fluid;
        super.getWailaBody(itemStack, currenttip, accessor, config);
        LiquidAbsorberTileEntity tileEntity = (LiquidAbsorberTileEntity)accessor.getTileEntity();
        if (tileEntity != null && tileEntity.getBlock() != null && (fluid = FluidRegistry.lookupFluidForBlock((Block)(block = tileEntity.getBlock()))) != null) {
            int absorbing = tileEntity.getAbsorbing();
            int pct = (DimletConstructionConfiguration.maxLiquidAbsorbtion - absorbing) * 100 / DimletConstructionConfiguration.maxLiquidAbsorbtion;
            currenttip.add(TextFormatting.GREEN + "Liquid: " + new FluidStack(fluid, 1).getLocalizedName() + " (" + pct + "%)");
        }
        return currenttip;
    }

    @SideOnly(value=Side.CLIENT)
    public void addInformation(ItemStack itemStack, EntityPlayer player, List<String> list, boolean whatIsThis) {
        Fluid fluid;
        Block block;
        super.addInformation(itemStack, player, list, whatIsThis);
        NBTTagCompound tagCompound = itemStack.func_77978_p();
        if (tagCompound != null && tagCompound.func_74764_b("liquid") && (block = (Block)Block.field_149771_c.func_82594_a((Object)new ResourceLocation(tagCompound.func_74779_i("liquid")))) != null && (fluid = FluidRegistry.lookupFluidForBlock((Block)block)) != null) {
            list.add(TextFormatting.GREEN + "Liquid: " + new FluidStack(fluid, 1).getLocalizedName());
            int absorbing = tagCompound.func_74762_e("absorbing");
            int pct = (DimletConstructionConfiguration.maxLiquidAbsorbtion - absorbing) * 100 / DimletConstructionConfiguration.maxLiquidAbsorbtion;
            list.add(TextFormatting.GREEN + "Absorbed: " + pct + "%");
        }
        if (Keyboard.isKeyDown((int)42) || Keyboard.isKeyDown((int)54)) {
            list.add(TextFormatting.WHITE + "Place this block on top of a liquid and it will");
            list.add(TextFormatting.WHITE + "gradually absorb all this liquid in the area.");
            list.add(TextFormatting.WHITE + "You can use the end result in the Dimlet Workbench.");
        } else {
            list.add(TextFormatting.WHITE + "<Press Shift>");
        }
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    public boolean func_149637_q(IBlockState state) {
        return false;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public int getGuiID() {
        return -1;
    }
}

