/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsdim.dimensions.dimlets.types;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import mcjty.lib.varia.BlockTools;
import mcjty.rftoolsdim.blocks.ModBlocks;
import mcjty.rftoolsdim.config.Settings;
import mcjty.rftoolsdim.config.WorldgenConfiguration;
import mcjty.rftoolsdim.dimensions.DimensionInformation;
import mcjty.rftoolsdim.dimensions.dimlets.DimletKey;
import mcjty.rftoolsdim.dimensions.dimlets.DimletObjectMapping;
import mcjty.rftoolsdim.dimensions.dimlets.DimletRandomizer;
import mcjty.rftoolsdim.dimensions.dimlets.KnownDimletConfiguration;
import mcjty.rftoolsdim.dimensions.dimlets.types.DimletCraftingTools;
import mcjty.rftoolsdim.dimensions.dimlets.types.DimletType;
import mcjty.rftoolsdim.dimensions.dimlets.types.IDimletType;
import mcjty.rftoolsdim.dimensions.dimlets.types.Patreons;
import mcjty.rftoolsdim.dimensions.types.TerrainType;
import net.minecraft.block.Block;
import net.minecraft.block.BlockStaticLiquid;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.config.Configuration;
import org.apache.commons.lang3.tuple.Pair;

public class TerrainDimletType
implements IDimletType {
    private static final String CATEGORY_TYPE = "type_terrain";
    private static float materialCreationCostFactor = 5.0f;
    private static float liquidCreationCostFactor = 5.0f;
    private static float materialMaintenanceCostFactor = 5.0f;
    private static float liquidMaintenanceCostFactor = 5.0f;
    private static float materialTickCostFactor = 2.0f;
    private static float liquidTickCostFactor = 2.0f;

    @Override
    public String getName() {
        return "Terrain";
    }

    @Override
    public String getOpcode() {
        return "T";
    }

    @Override
    public String getTextureName() {
        return "terrainDimlet";
    }

    @Override
    public void setupFromConfig(Configuration cfg) {
        cfg.addCustomCategoryComment(CATEGORY_TYPE, "Settings for the terrain dimlet type");
        materialCreationCostFactor = (float)cfg.get(CATEGORY_TYPE, "material.creation.factor", (double)materialCreationCostFactor, "The cost factor for a material dimlet modifier when used in combination with this terrain").getDouble();
        liquidCreationCostFactor = (float)cfg.get(CATEGORY_TYPE, "liquid.creation.factor", (double)liquidCreationCostFactor, "The cost factor for a liquid dimlet modifier when used in combination with this terrain").getDouble();
        materialMaintenanceCostFactor = (float)cfg.get(CATEGORY_TYPE, "material.maintenance.factor", (double)materialMaintenanceCostFactor, "The cost factor for a material dimlet modifier when used in combination with this terrain").getDouble();
        liquidMaintenanceCostFactor = (float)cfg.get(CATEGORY_TYPE, "liquid.maintenance.factor", (double)liquidMaintenanceCostFactor, "The cost factor for a liquid dimlet modifier when used in combination with this terrain").getDouble();
        materialTickCostFactor = (float)cfg.get(CATEGORY_TYPE, "material.tick.factor", (double)materialTickCostFactor, "The cost factor for a material dimlet modifier when used in combination with this terrain").getDouble();
        liquidTickCostFactor = (float)cfg.get(CATEGORY_TYPE, "liquid.tick.factor", (double)liquidTickCostFactor, "The cost factor for a liquid dimlet modifier when used in combination with this terrain").getDouble();
    }

    @Override
    public boolean isModifier() {
        return false;
    }

    @Override
    public boolean isModifiedBy(DimletType type) {
        return type == DimletType.DIMLET_MATERIAL || type == DimletType.DIMLET_LIQUID;
    }

    @Override
    public float getModifierCreateCostFactor(DimletType modifierType, DimletKey key) {
        TerrainType terrainType = DimletObjectMapping.getTerrain(key);
        if (modifierType == DimletType.DIMLET_MATERIAL) {
            return materialCreationCostFactor * terrainType.getMaterialCostFactor();
        }
        if (modifierType == DimletType.DIMLET_LIQUID) {
            return liquidCreationCostFactor * terrainType.getLiquidCostFactor();
        }
        return 1.0f;
    }

    @Override
    public float getModifierMaintainCostFactor(DimletType modifierType, DimletKey key) {
        TerrainType terrainType = DimletObjectMapping.getTerrain(key);
        if (modifierType == DimletType.DIMLET_MATERIAL) {
            return materialMaintenanceCostFactor * terrainType.getMaterialCostFactor();
        }
        if (modifierType == DimletType.DIMLET_LIQUID) {
            return liquidMaintenanceCostFactor * terrainType.getLiquidCostFactor();
        }
        return 1.0f;
    }

    @Override
    public float getModifierTickCostFactor(DimletType modifierType, DimletKey key) {
        TerrainType terrainType = DimletObjectMapping.getTerrain(key);
        if (modifierType == DimletType.DIMLET_MATERIAL) {
            return materialTickCostFactor * terrainType.getMaterialCostFactor();
        }
        if (modifierType == DimletType.DIMLET_LIQUID) {
            return liquidTickCostFactor * terrainType.getLiquidCostFactor();
        }
        return 1.0f;
    }

    @Override
    public boolean isInjectable() {
        return false;
    }

    @Override
    public void inject(DimletKey key, DimensionInformation dimensionInformation) {
    }

    @Override
    public void constructDimension(List<Pair<DimletKey, List<DimletKey>>> dimlets, Random random, DimensionInformation dimensionInformation) {
        BlockStaticLiquid fluidForTerrain;
        IBlockState baseBlockForTerrain;
        List modifiers;
        dimlets = DimensionInformation.extractType(DimletType.DIMLET_TERRAIN, dimlets);
        TerrainType terrainType = TerrainType.TERRAIN_VOID;
        if (dimlets.isEmpty()) {
            DimletKey key = DimletRandomizer.getRandomTerrain(random);
            if (key != null) {
                dimensionInformation.updateCostFactor(key);
                terrainType = DimletObjectMapping.getTerrain(key);
            }
            modifiers = Collections.emptyList();
        } else {
            int index = random.nextInt(dimlets.size());
            DimletKey key = (DimletKey)dimlets.get(index).getLeft();
            terrainType = DimletObjectMapping.getTerrain(key);
            modifiers = (List)dimlets.get(index).getRight();
        }
        ArrayList<IBlockState> blocks = new ArrayList<IBlockState>();
        ArrayList<Block> fluids = new ArrayList<Block>();
        DimensionInformation.getMaterialAndFluidModifiers(modifiers, blocks, fluids);
        dimensionInformation.setTerrainType(terrainType);
        if (dimensionInformation.isPatreonBitSet(Patreons.PATREON_LAYEREDMETA)) {
            baseBlockForTerrain = Blocks.field_150348_b.func_176223_P();
        } else if (!blocks.isEmpty()) {
            baseBlockForTerrain = (IBlockState)blocks.get(random.nextInt(blocks.size()));
            if (baseBlockForTerrain == null) {
                baseBlockForTerrain = Blocks.field_150348_b.func_176223_P();
            }
        } else if (terrainType == TerrainType.TERRAIN_VOID) {
            baseBlockForTerrain = Blocks.field_150348_b.func_176223_P();
        } else if (random.nextFloat() < WorldgenConfiguration.randomBaseBlockChance) {
            DimletKey key = DimletRandomizer.getRandomMaterialBlock(random);
            if (key != null) {
                dimensionInformation.updateCostFactor(key);
                baseBlockForTerrain = DimletObjectMapping.getBlock(key);
            } else {
                baseBlockForTerrain = Blocks.field_150348_b.func_176223_P();
            }
        } else {
            baseBlockForTerrain = Blocks.field_150348_b.func_176223_P();
        }
        dimensionInformation.setBaseBlockForTerrain(baseBlockForTerrain);
        if (!fluids.isEmpty()) {
            fluidForTerrain = (Block)fluids.get(random.nextInt(fluids.size()));
            if (fluidForTerrain == null) {
                fluidForTerrain = Blocks.field_150355_j;
            }
        } else if (terrainType == TerrainType.TERRAIN_VOID) {
            fluidForTerrain = Blocks.field_150355_j;
        } else if (random.nextFloat() < WorldgenConfiguration.randomOceanLiquidChance) {
            DimletKey key = DimletRandomizer.getRandomFluidBlock(random);
            if (key != null) {
                dimensionInformation.updateCostFactor(key);
                fluidForTerrain = DimletObjectMapping.getFluid(key);
            } else {
                fluidForTerrain = Blocks.field_150355_j;
            }
        } else {
            fluidForTerrain = Blocks.field_150355_j;
        }
        dimensionInformation.setFluidForTerrain((Block)fluidForTerrain);
    }

    @Override
    public String[] getInformation() {
        return new String[]{"This affects the type of terrain", "that you will get in a dimension", "This dimlet can receive liquid and material", "modifiers which have to come in front of the terrain."};
    }

    @Override
    public DimletKey isValidEssence(ItemStack stackEssence) {
        Block essenceBlock = BlockTools.getBlock((ItemStack)stackEssence);
        if (essenceBlock != ModBlocks.terrainAbsorberBlock) {
            return null;
        }
        NBTTagCompound essenceCompound = stackEssence.func_77978_p();
        if (essenceCompound == null) {
            return null;
        }
        int absorbing = essenceCompound.func_74762_e("absorbing");
        String terrain = essenceCompound.func_74779_i("terrain");
        if (absorbing > 0 || terrain == null) {
            return null;
        }
        return TerrainDimletType.findTerrainDimlet(essenceCompound);
    }

    @Override
    public ItemStack getDefaultEssence() {
        return new ItemStack((Block)ModBlocks.terrainAbsorberBlock);
    }

    private static DimletKey findTerrainDimlet(NBTTagCompound essenceCompound) {
        String terrain = essenceCompound.func_74779_i("terrain");
        DimletKey key = new DimletKey(DimletType.DIMLET_TERRAIN, terrain);
        Settings settings = KnownDimletConfiguration.getSettings(key);
        if (settings == null || !settings.isDimlet()) {
            return null;
        }
        return key;
    }

    @Override
    public DimletKey attemptDimletCrafting(ItemStack stackController, ItemStack stackMemory, ItemStack stackEnergy, ItemStack stackEssence) {
        DimletKey terrainDimlet = this.isValidEssence(stackEssence);
        if (terrainDimlet == null) {
            return null;
        }
        if (!DimletCraftingTools.matchDimletRecipe(terrainDimlet, stackController, stackMemory, stackEnergy)) {
            return null;
        }
        return terrainDimlet;
    }
}

