/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsdim.dimensions.world.mapgen;

import java.util.Random;
import mcjty.rftoolsdim.dimensions.world.GenericChunkGenerator;
import mcjty.rftoolsdim.dimensions.world.terrain.BaseTerrainGenerator;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;
import net.minecraft.world.chunk.ChunkPrimer;

public class MapGenOrbs {
    private final GenericChunkGenerator provider;
    private final boolean large;
    private final int r;

    public MapGenOrbs(GenericChunkGenerator provider, boolean large) {
        this.provider = provider;
        this.large = large;
        this.r = large ? 2 : 1;
    }

    public void generate(World world, int chunkX, int chunkZ, ChunkPrimer primer) {
        IBlockState[] blocks = this.large ? this.provider.dimensionInformation.getHugeSphereBlocks() : this.provider.dimensionInformation.getSphereBlocks();
        for (int cx = -this.r; cx <= this.r; ++cx) {
            for (int cz = -this.r; cz <= this.r; ++cz) {
                Random random = new Random((world.func_72905_C() + (long)(chunkX + cx)) * 113L + (long)((chunkZ + cz) * 31) + 77L);
                random.nextFloat();
                if (!(random.nextFloat() < 0.05f)) continue;
                int x = cx * 16 + random.nextInt(16);
                int y = 40 + random.nextInt(40);
                int z = cz * 16 + random.nextInt(16);
                int radius = random.nextInt(this.large ? 20 : 6) + (this.large ? 10 : 4);
                IBlockState block = Blocks.field_150348_b.func_176223_P();
                if (blocks.length > 1) {
                    block = blocks[random.nextInt(blocks.length)];
                } else if (blocks.length == 1) {
                    block = blocks[0];
                }
                this.fillSphere(primer, x, y, z, radius, block);
            }
        }
    }

    private void fillSphere(ChunkPrimer primer, int centerx, int centery, int centerz, int radius, IBlockState block) {
        double sqradius = radius * radius;
        for (int x = 0; x < 16; ++x) {
            double dxdx = (x - centerx) * (x - centerx);
            for (int z = 0; z < 16; ++z) {
                double dzdz = (z - centerz) * (z - centerz);
                int index = (x * 16 + z) * 256;
                for (int y = centery - radius; y <= centery + radius; ++y) {
                    double dydy = (y - centery) * (y - centery);
                    double sqdist = dxdx + dydy + dzdz;
                    if (!(sqdist <= sqradius)) continue;
                    BaseTerrainGenerator.setBlockState(primer, index + y, block);
                }
            }
        }
    }
}

