/*
 * Decompiled with CFR 0.152.
 */
package totemic_commons.pokefenn;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.world.ColorizerFoliage;
import net.minecraftforge.client.model.obj.OBJLoader;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import org.apache.logging.log4j.Level;
import org.lwjgl.opengl.Display;
import totemic_commons.pokefenn.CommonProxy;
import totemic_commons.pokefenn.ModBlocks;
import totemic_commons.pokefenn.ModItems;
import totemic_commons.pokefenn.Totemic;
import totemic_commons.pokefenn.client.rendering.entity.BaykokRendering;
import totemic_commons.pokefenn.client.rendering.entity.BuffaloRendering;
import totemic_commons.pokefenn.client.rendering.entity.InvisArrowRendering;
import totemic_commons.pokefenn.client.rendering.tileentity.TileWindChimeRenderer;
import totemic_commons.pokefenn.entity.animal.EntityBuffalo;
import totemic_commons.pokefenn.entity.boss.EntityBaykok;
import totemic_commons.pokefenn.entity.projectile.EntityInvisArrow;
import totemic_commons.pokefenn.handler.GameOverlay;
import totemic_commons.pokefenn.handler.PlayerRender;
import totemic_commons.pokefenn.tileentity.music.TileWindChime;
import totemic_commons.pokefenn.totempedia.LexiconData;

public class ClientProxy
extends CommonProxy {
    @Override
    public void preInit(FMLPreInitializationEvent event) {
        super.preInit(event);
        RenderingRegistry.registerEntityRenderingHandler(EntityBuffalo.class, BuffaloRendering::new);
        RenderingRegistry.registerEntityRenderingHandler(EntityInvisArrow.class, InvisArrowRendering::new);
        RenderingRegistry.registerEntityRenderingHandler(EntityBaykok.class, BaykokRendering::new);
        ModBlocks.setStateMappers();
        ModBlocks.setItemModels();
        ModItems.setItemModels();
        OBJLoader.INSTANCE.addDomain("totemic");
    }

    @Override
    public void init(FMLInitializationEvent event) {
        super.init(event);
        this.initTESRs();
        LexiconData.init();
        this.registerBlockColors();
    }

    @Override
    public void postInit(FMLPostInitializationEvent event) {
        super.postInit(event);
        try {
            if (Loader.isModLoaded((String)"Botania") && new Random().nextInt(8) == 0) {
                Display.setTitle((String)Display.getTitle().replace("Minecraft", "Floweycraft"));
            }
        }
        catch (Exception e) {
            Totemic.logger.catching(Level.WARN, (Throwable)e);
        }
    }

    @Override
    protected void registerEventHandlers() {
        super.registerEventHandlers();
        MinecraftForge.EVENT_BUS.register((Object)new GameOverlay());
        MinecraftForge.EVENT_BUS.register((Object)new PlayerRender());
    }

    private void registerBlockColors() {
        Minecraft.func_71410_x().func_184125_al().func_186722_a((state, world, pos, tintIndex) -> ColorizerFoliage.func_77466_a(), new Block[]{ModBlocks.cedarLeaves});
    }

    private void initTESRs() {
        ClientRegistry.bindTileEntitySpecialRenderer(TileWindChime.class, (TileEntitySpecialRenderer)new TileWindChimeRenderer());
    }
}

