/*
 * Decompiled with CFR 0.152.
 */
package totemic_commons.pokefenn.api.ceremony;

import net.minecraft.util.math.BlockPos;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.World;
import org.apache.commons.lang3.Validate;
import totemic_commons.pokefenn.api.music.MusicInstrument;

public abstract class Ceremony {
    public static final int MIN_SELECTORS = 2;
    public static final int MAX_SELECTORS = 4;
    public static final int INSTANT = 0;
    public static final int VERY_SHORT = 100;
    public static final int SHORT = 300;
    public static final int SHORT_MEDIUM = 440;
    public static final int MEDIUM = 600;
    public static final int LONG = 900;
    public static final int EXTRA_LONG = 1200;
    public static final int MEDIUM_STUPID_LONG = 1800;
    public static final int STUPIDLY_LONG = 2400;
    protected final String name;
    protected final int musicNeeded;
    protected final int maxStartupTime;
    protected final MusicInstrument[] instruments;

    public Ceremony(String name, int musicNeeded, int maxStartupTime, MusicInstrument ... instruments) {
        Validate.inclusiveBetween((long)2L, (long)4L, (long)instruments.length, (String)"Wrong number of musical selectors: Must be between 2 and 4");
        Validate.noNullElements((Object[])instruments);
        this.name = name;
        this.musicNeeded = musicNeeded;
        this.maxStartupTime = maxStartupTime;
        this.instruments = instruments;
    }

    public abstract void effect(World var1, BlockPos var2, int var3);

    public int getEffectTime() {
        return 0;
    }

    public int getMusicPer5() {
        return 0;
    }

    public final String getName() {
        return this.name;
    }

    public String getUnlocalizedName() {
        return "totemic.ceremony." + this.name;
    }

    public int getMusicNeeded() {
        return this.musicNeeded;
    }

    public int getMaxStartupTime() {
        return this.maxStartupTime;
    }

    public int getAdjustedMaxStartupTime(EnumDifficulty diff) {
        switch (diff) {
            case PEACEFUL: 
            case EASY: {
                return (int)(1.1f * (float)this.getMaxStartupTime());
            }
            default: {
                return this.getMaxStartupTime();
            }
            case HARD: 
        }
        return (int)(0.9f * (float)this.getMaxStartupTime());
    }

    public MusicInstrument[] getInstruments() {
        return this.instruments;
    }

    public String toString() {
        return this.name;
    }
}

