/*
 * Decompiled with CFR 0.152.
 */
package totemic_commons.pokefenn.api.music;

import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import totemic_commons.pokefenn.api.TotemicAPI;
import totemic_commons.pokefenn.api.music.MusicInstrument;

public abstract class ItemInstrument
extends Item {
    public static final String INSTR_COOLDOWN_KEY = "cooldown";
    protected final MusicInstrument instrument;
    protected final SoundEvent sound;

    public ItemInstrument(MusicInstrument instrument, @Nullable SoundEvent sound) {
        this.instrument = Objects.requireNonNull(instrument);
        this.sound = sound;
    }

    protected void useInstrument(ItemStack stack, Entity entity, int cooldown, int bonusRadius, int bonusMusic) {
        NBTTagCompound tag;
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
        }
        if ((tag = stack.func_77978_p()).func_74762_e(INSTR_COOLDOWN_KEY) == 0) {
            this.playMusic(stack, entity, bonusRadius, bonusMusic);
            tag.func_74768_a(INSTR_COOLDOWN_KEY, cooldown);
        }
    }

    protected void playMusic(ItemStack stack, Entity entity, int bonusRadius, int bonusMusic) {
        if (entity.field_70170_p.field_72995_K) {
            return;
        }
        WorldServer world = (WorldServer)entity.field_70170_p;
        if (!entity.func_70093_af()) {
            TotemicAPI.get().music().playMusic((World)world, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, this.instrument, bonusRadius, bonusMusic);
            this.spawnParticles(world, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, false);
        } else {
            TotemicAPI.get().music().playMusicForSelector((World)world, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, this.instrument, bonusRadius);
            this.spawnParticles(world, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, true);
        }
        if (this.sound != null) {
            entity.field_70170_p.func_184148_a(null, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, this.sound, SoundCategory.PLAYERS, 1.0f, 1.0f);
        }
    }

    protected void spawnParticles(WorldServer world, double x, double y, double z, boolean firework) {
        world.func_175739_a(EnumParticleTypes.NOTE, x, y + 1.2, z, 6, 0.5, 0.0, 0.5, 0.0, new int[0]);
        if (firework) {
            world.func_175739_a(EnumParticleTypes.FIREWORKS_SPARK, x, y + 1.2, z, 8, 0.5, 0.0, 0.5, 0.0, new int[0]);
        }
    }

    public void func_77663_a(ItemStack stack, World world, Entity entity, int slot, boolean isSelected) {
        if (!world.field_72995_K && slot < InventoryPlayer.func_70451_h()) {
            NBTTagCompound tag = stack.func_77978_p();
            if (tag == null) {
                return;
            }
            int cooldown = tag.func_74762_e(INSTR_COOLDOWN_KEY);
            if (cooldown > 0) {
                tag.func_74768_a(INSTR_COOLDOWN_KEY, --cooldown);
            }
        }
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return slotChanged || !ItemStack.func_179545_c((ItemStack)oldStack, (ItemStack)newStack);
    }
}

