/*
 * Decompiled with CFR 0.152.
 */
package totemic_commons.pokefenn.api.totem;

import java.util.List;
import java.util.Objects;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.potion.Potion;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import totemic_commons.pokefenn.api.TotemicAPI;
import totemic_commons.pokefenn.api.totem.TotemBase;
import totemic_commons.pokefenn.api.totem.TotemEffect;

public class TotemEffectPotion
extends TotemEffect {
    public final Potion potion;
    public final int interval;
    public final int defaultTime;
    public final int amplifier;

    public TotemEffectPotion(String name, int horizontal, int vertical, Potion potion, int interval, int defaultTime, int amplifier) {
        super(name, horizontal, vertical);
        this.potion = Objects.requireNonNull(potion);
        this.interval = interval;
        this.defaultTime = defaultTime;
        this.amplifier = amplifier;
    }

    @Override
    public void effect(World world, BlockPos pos, TotemBase totem, int repetition, int horizontal, int vertical) {
        if (world.field_72995_K) {
            return;
        }
        if (world.func_82737_E() % (long)this.interval == 0L) {
            for (EntityPlayer entity : TotemEffectPotion.getPlayersInRange(world, pos, horizontal, vertical)) {
                TotemicAPI.get().totemEffect().addPotionEffect((EntityLivingBase)entity, this.potion, this.defaultTime, this.amplifier, totem, repetition);
            }
        }
    }

    public static List<EntityPlayer> getPlayersInRange(World world, BlockPos pos, int horizontal, int vertical) {
        return world.func_72872_a(EntityPlayer.class, new AxisAlignedBB((double)((float)pos.func_177958_n() - 0.5f), (double)((float)pos.func_177956_o() - 0.5f), (double)((float)pos.func_177952_p() - 0.5f), (double)((float)pos.func_177958_n() + 0.5f), (double)((float)pos.func_177956_o() + 0.5f), (double)((float)pos.func_177952_p() + 0.5f)).func_72314_b((double)horizontal, (double)vertical, (double)horizontal));
    }
}

