/*
 * Decompiled with CFR 0.152.
 */
package totemic_commons.pokefenn.apiimpl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import totemic_commons.pokefenn.api.TotemicRegistry;
import totemic_commons.pokefenn.api.ceremony.Ceremony;
import totemic_commons.pokefenn.api.music.MusicInstrument;
import totemic_commons.pokefenn.api.totem.TotemEffect;
import totemic_commons.pokefenn.util.MathsUtil;
import vazkii.botania.totemic_custom.api.lexicon.LexiconCategory;
import vazkii.botania.totemic_custom.api.lexicon.LexiconEntry;

public class RegistryImpl
implements TotemicRegistry {
    private final Map<String, TotemEffect> totemEffects = new HashMap<String, TotemEffect>();
    private final List<TotemEffect> totemList = new ArrayList<TotemEffect>();
    private final Map<String, MusicInstrument> instruments = new HashMap<String, MusicInstrument>();
    private final Map<String, Ceremony> ceremonies = new HashMap<String, Ceremony>();
    private final List<LexiconCategory> categories = new ArrayList<LexiconCategory>();
    private final List<LexiconEntry> lexiconEntries = new ArrayList<LexiconEntry>();

    @Override
    public TotemEffect addTotem(TotemEffect effect) {
        if (this.totemEffects.containsKey(effect.getName())) {
            throw new IllegalArgumentException("Duplicate Totem entry for ID " + effect.getName());
        }
        this.totemEffects.put(effect.getName(), effect);
        this.totemList.add(effect);
        return effect;
    }

    @Override
    public TotemEffect getTotem(String name) {
        return this.totemEffects.get(name);
    }

    @Override
    public Map<String, TotemEffect> getTotems() {
        return Collections.unmodifiableMap(this.totemEffects);
    }

    public List<TotemEffect> getTotemList() {
        return Collections.unmodifiableList(this.totemList);
    }

    @Override
    public MusicInstrument addInstrument(MusicInstrument instrument) {
        if (this.instruments.containsKey(instrument.getName())) {
            throw new IllegalArgumentException("Duplicate Music instrument entry for ID " + instrument.getName());
        }
        this.instruments.put(instrument.getName(), instrument);
        return instrument;
    }

    @Override
    public MusicInstrument getInstrument(String name) {
        return this.instruments.get(name);
    }

    @Override
    public Map<String, MusicInstrument> getInstruments() {
        return Collections.unmodifiableMap(this.instruments);
    }

    @Override
    public Ceremony addCeremony(Ceremony ceremony) {
        if (this.ceremonies.containsKey(ceremony.getName())) {
            throw new IllegalArgumentException("Duplicate Ceremony entry for ID " + ceremony.getName());
        }
        for (Ceremony other : this.ceremonies.values()) {
            if (MathsUtil.isPrefix(ceremony.getInstruments(), other.getInstruments())) {
                throw new IllegalArgumentException(String.format("Could not add Ceremony %1$s because its selectors are prefixing the selectors of %2$s. This would make selecting %2$s impossible.\n%3$s prefixes %4$s", ceremony.getName(), other.getName(), Arrays.toString(ceremony.getInstruments()), Arrays.toString(other.getInstruments())));
            }
            if (!MathsUtil.isPrefix(other.getInstruments(), ceremony.getInstruments())) continue;
            throw new IllegalArgumentException(String.format("Could not add Ceremony %1$s because its selectors are prefixed by the selectors of %2$s. This would make selecting %1$s impossible.\n%3$s is prefixed by %4$s", ceremony.getName(), other.getName(), Arrays.toString(ceremony.getInstruments()), Arrays.toString(other.getInstruments())));
        }
        this.ceremonies.put(ceremony.getName(), ceremony);
        return ceremony;
    }

    @Override
    public Ceremony getCeremony(String name) {
        return this.ceremonies.get(name);
    }

    @Override
    public Map<String, Ceremony> getCeremonies() {
        return Collections.unmodifiableMap(this.ceremonies);
    }

    @Override
    public LexiconCategory addCategory(LexiconCategory cat) {
        this.categories.add(cat);
        return cat;
    }

    @Override
    public List<LexiconCategory> getCategories() {
        return Collections.unmodifiableList(this.categories);
    }

    @Override
    public void addLexiconEntry(LexiconCategory category, LexiconEntry entry) {
        this.lexiconEntries.add(entry);
        category.entries.add(entry);
    }
}

