/*
 * Decompiled with CFR 0.152.
 */
package totemic_commons.pokefenn.configuration;

import java.io.File;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.apache.logging.log4j.Level;
import totemic_commons.pokefenn.Totemic;
import totemic_commons.pokefenn.configuration.ConfigurationSettings;

public final class ConfigurationHandler {
    public static Configuration conf;
    public static final String CATEGORY_GAMEPLAY = "gameplay";
    public static final String CATEGORY_TOTEMS = "totem";
    public static final String CATEGORY_ENTITY = "entity";
    public static final String CATEGORY_CLIENT = "client";
    public static final String CATEGORY_GENERAL = "general";

    public static void init(File configFile) {
        conf = new Configuration(configFile);
        try {
            conf.load();
            ConfigurationHandler.loadValues();
        }
        catch (Exception e) {
            Totemic.logger.catching(Level.ERROR, (Throwable)e);
        }
        finally {
            conf.save();
        }
        MinecraftForge.EVENT_BUS.register((Object)new ConfigurationHandler());
    }

    private static void loadValues() {
        ConfigurationSettings.CEREMONY_HUD_X = conf.get(CATEGORY_CLIENT, "ceremonyHudPositionX", 0, "horizontal position of the ceremony HUD (offset from center of the screen)").getInt();
        ConfigurationSettings.CEREMONY_HUD_Y = conf.get(CATEGORY_CLIENT, "ceremonyHudPositionY", -70, "vertical position of the ceremony HUD (offset from center of the screen)").getInt();
    }

    @SubscribeEvent
    public void onConfigChanged(ConfigChangedEvent event) {
        if (event.getModID().equals("totemic")) {
            try {
                ConfigurationHandler.loadValues();
            }
            finally {
                conf.save();
            }
        }
    }
}

