/*
 * Decompiled with CFR 0.152.
 */
package totemic_commons.pokefenn.entity.animal;

import javax.annotation.Nullable;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIFollowParent;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAIMate;
import net.minecraft.entity.ai.EntityAIPanic;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAITempt;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.passive.EntityCow;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import totemic_commons.pokefenn.ModItems;
import totemic_commons.pokefenn.item.ItemBuffaloDrops;
import totemic_commons.pokefenn.util.MathsUtil;

public class EntityBuffalo
extends EntityCow {
    public boolean isSheared = false;
    public static final int MAX_AGE = 12000;
    public static final float MIN_HP = 15.0f;
    public static final float MAX_HP = 35.0f;
    private static final DataParameter<Integer> AGE_DATAWATCHER = EntityDataManager.func_187226_a(EntityBuffalo.class, (DataSerializer)DataSerializers.field_187192_b);

    public EntityBuffalo(World world) {
        super(world);
        this.func_70105_a(1.35f, 1.95f);
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIPanic((EntityCreature)this, 2.0));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIMate((EntityAnimal)this, 1.0));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAITempt((EntityCreature)this, 1.25, Items.field_151015_O, false));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIFollowParent((EntityAnimal)this, 1.25));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIWander((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 6.0f));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.func_70606_j(15.0f);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(AGE_DATAWATCHER, (Object)0);
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(35.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.15);
    }

    public void func_70636_d() {
        int age;
        super.func_70636_d();
        int interval = 5;
        if (!this.field_70170_p.field_72995_K && this.field_70170_p.func_82737_E() % 5L == 0L && !this.func_70631_g_() && (age = this.getBuffaloAge()) < 12000) {
            this.setBuffaloAge(age += 5);
            float oldMaxHP = MathsUtil.lerp(15.0f, 35.0f, (float)(age - 5) / 12000.0f);
            float newMaxHP = MathsUtil.lerp(15.0f, 35.0f, (float)age / 12000.0f);
            this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a((double)newMaxHP);
            this.func_70606_j(this.func_110143_aJ() * newMaxHP / oldMaxHP);
        }
    }

    public int getBuffaloAge() {
        return Math.min((Integer)this.field_70180_af.func_187225_a(AGE_DATAWATCHER), 12000);
    }

    public float getRelativeAge() {
        return (float)this.getBuffaloAge() / 12000.0f;
    }

    public void setBuffaloAge(int age) {
        this.field_70180_af.func_187227_b(AGE_DATAWATCHER, (Object)age);
    }

    protected float func_70599_aP() {
        return 0.4f;
    }

    protected float func_70647_i() {
        return super.func_70647_i() - 0.2f;
    }

    public void func_70014_b(NBTTagCompound tag) {
        super.func_70014_b(tag);
        tag.func_74757_a("isSheared", this.isSheared);
        tag.func_74768_a("buffaloAge", this.getBuffaloAge());
    }

    public void func_70037_a(NBTTagCompound tag) {
        super.func_70037_a(tag);
        this.isSheared = tag.func_74767_n("isSheared");
        int age = tag.func_74762_e("buffaloAge");
        this.setBuffaloAge(age);
    }

    @Nullable
    protected ResourceLocation func_184647_J() {
        return null;
    }

    protected void func_70628_a(boolean hitByPlayer, int looting) {
        int k;
        int age = this.getBuffaloAge();
        int bonus = 3 * age / 12000;
        int j = this.field_70146_Z.nextInt(2 + bonus) + this.field_70146_Z.nextInt(1 + looting);
        for (k = 0; k < j; ++k) {
            this.func_70099_a(new ItemStack(ModItems.buffaloItems, 1, ItemBuffaloDrops.Type.hide.ordinal()), 0.0f);
            if (this.field_70146_Z.nextInt(3) >= 2) continue;
            this.func_70099_a(new ItemStack(ModItems.buffaloItems, 1, ItemBuffaloDrops.Type.teeth.ordinal()), 0.0f);
        }
        j = this.field_70146_Z.nextInt(2 + bonus) + (bonus >= 2 ? 1 : 0) + this.field_70146_Z.nextInt(2 + 2 * looting);
        for (k = 0; k < j; ++k) {
            if (this.func_70027_ad()) {
                this.func_145779_a(ModItems.buffaloCookedMeat, 1);
                continue;
            }
            this.func_145779_a(ModItems.buffaloMeat, 1);
        }
    }

    public EntityBuffalo createChild(EntityAgeable var1) {
        return new EntityBuffalo(this.field_70170_p);
    }

    protected int func_70693_a(EntityPlayer player) {
        int bonus = 3 * this.getBuffaloAge() / 12000;
        return 2 + bonus + this.field_70170_p.field_73012_v.nextInt(3 + bonus);
    }

    public boolean func_70878_b(EntityAnimal animal) {
        return animal != this && animal.getClass() == ((Object)((Object)this)).getClass() && this.func_70880_s() && animal.func_70880_s();
    }
}

