/*
 * Decompiled with CFR 0.152.
 */
package totemic_commons.pokefenn.handler;

import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.VertexBuffer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.FOVUpdateEvent;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.lwjgl.opengl.GL11;
import totemic_commons.pokefenn.api.ceremony.Ceremony;
import totemic_commons.pokefenn.client.RenderHelper;
import totemic_commons.pokefenn.configuration.ConfigurationSettings;
import totemic_commons.pokefenn.item.equipment.weapon.ItemBaykokBow;
import totemic_commons.pokefenn.tileentity.totem.TileTotemBase;

public class GameOverlay {
    public static TileTotemBase activeTotem = null;
    private static final ResourceLocation hudTexture = new ResourceLocation("totemic:textures/gui/ceremonyHUD.png");

    @SubscribeEvent
    public void renderHUD(RenderGameOverlayEvent.Post event) {
        if (event.getType() == RenderGameOverlayEvent.ElementType.ALL) {
            Minecraft mc = Minecraft.func_71410_x();
            mc.field_71424_I.func_76320_a("totemicHUD");
            if (activeTotem != null && (!GameOverlay.activeTotem.isCeremony || activeTotem.func_145837_r())) {
                activeTotem = null;
            }
            if (activeTotem != null && (activeTotem.isDoingStartup() || GameOverlay.activeTotem.isDoingEndingEffect)) {
                int w = 117;
                int h = 30;
                double texW = 128.0;
                double texH = 64.0;
                float hudX = (event.getResolution().func_78326_a() - w) / 2 + ConfigurationSettings.CEREMONY_HUD_X;
                float hudY = (event.getResolution().func_78328_b() - h) / 2 + ConfigurationSettings.CEREMONY_HUD_Y;
                Tessellator tes = Tessellator.func_178181_a();
                VertexBuffer wr = tes.func_178180_c();
                FontRenderer font = mc.field_71466_p;
                GL11.glPushAttrib((int)24576);
                GL11.glEnable((int)3042);
                GL11.glBlendFunc((int)770, (int)771);
                GL11.glPushMatrix();
                GL11.glTranslatef((float)hudX, (float)hudY, (float)0.0f);
                mc.field_71446_o.func_110577_a(hudTexture);
                wr.func_181668_a(7, DefaultVertexFormats.field_181707_g);
                RenderHelper.addQuad(wr, 0.0, 0.0, 0.0, w, h, 0.0, 0.0, (double)w / texW, (double)h / texH);
                tes.func_78381_a();
                int barW = 104;
                int barH = 7;
                if (activeTotem.isDoingStartup()) {
                    Ceremony cer = GameOverlay.activeTotem.startupCeremony;
                    String locName = I18n.func_135052_a((String)cer.getUnlocalizedName(), (Object[])new Object[0]);
                    int nameX = (w - font.func_78256_a(locName)) / 2;
                    font.func_78276_b(locName, nameX, 1, -939524096);
                    GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
                    mc.field_71446_o.func_110577_a(hudTexture);
                    wr.func_181668_a(7, DefaultVertexFormats.field_181707_g);
                    RenderHelper.addQuad(wr, 1.0, 10.0, 0.0, 9.0, 9.0, 16.0 / texW, 48.0 / texH, 8.0 / texW, 8.0 / texH);
                    RenderHelper.addQuad(wr, 1.0, 20.0, 0.0, 9.0, 9.0, 0.0 / texW, 48.0 / texH, 16.0 / texW, 16.0 / texH);
                    float musicW = (float)GameOverlay.activeTotem.totalCeremonyMelody / (float)cer.getMusicNeeded() * (float)barW;
                    float timeW = Math.min((float)GameOverlay.activeTotem.ceremonyStartupTimer / (float)cer.getAdjustedMaxStartupTime(mc.field_71441_e.func_175659_aa()), 1.0f) * (float)barW;
                    RenderHelper.addQuad(wr, 11.0, 11.0, 0.0, musicW, barH, 0.0, 32.0 / texH, (double)musicW / texW, (double)barH / texH);
                    RenderHelper.addQuad(wr, 11.0, 21.0, 0.0, timeW, barH, 0.0, 32.0 / texH, (double)timeW / texW, (double)barH / texH);
                    tes.func_78381_a();
                } else if (GameOverlay.activeTotem.isDoingEndingEffect) {
                    Ceremony cer = GameOverlay.activeTotem.currentCeremony;
                    String locName = I18n.func_135052_a((String)cer.getUnlocalizedName(), (Object[])new Object[0]);
                    int nameX = (w - font.func_78256_a(locName)) / 2;
                    font.func_78276_b(locName, nameX, 1, -939524096);
                }
                GL11.glPopMatrix();
                GL11.glPopAttrib();
            }
            mc.field_71424_I.func_76319_b();
        }
    }

    @SubscribeEvent
    public void onFOVUpdate(FOVUpdateEvent event) {
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        if (player.func_184587_cr() && player.func_184607_cu() != null && player.func_184607_cu().func_77973_b() instanceof ItemBaykokBow) {
            int bowTicks = player.func_184612_cw();
            float modifier = (float)bowTicks / 20.0f;
            modifier = modifier > 1.0f ? 1.0f : (modifier *= modifier);
            event.setNewfov(event.getFov() * (1.0f - 0.15f * modifier));
        }
    }
}

