/*
 * Decompiled with CFR 0.152.
 */
package totemic_commons.pokefenn.item.equipment;

import java.util.List;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import totemic_commons.pokefenn.ModBlocks;
import totemic_commons.pokefenn.Totemic;
import totemic_commons.pokefenn.api.totem.TotemEffect;
import totemic_commons.pokefenn.apiimpl.RegistryImpl;
import totemic_commons.pokefenn.block.totem.BlockTotemBase;
import totemic_commons.pokefenn.block.totem.BlockTotemPole;
import totemic_commons.pokefenn.item.ItemTotemic;
import totemic_commons.pokefenn.lib.WoodVariant;
import totemic_commons.pokefenn.tileentity.totem.TileTotemPole;
import totemic_commons.pokefenn.util.ItemUtil;

public class ItemTotemWhittlingKnife
extends ItemTotemic {
    private static final List<TotemEffect> totemList = ((RegistryImpl)Totemic.api.registry()).getTotemList();

    public ItemTotemWhittlingKnife() {
        super("totemWhittlingKnife");
        this.func_77625_d(1);
        this.func_77642_a(this);
        this.func_77656_e(254);
    }

    @SideOnly(value=Side.CLIENT)
    public String getCurrentlyCarving(int i) {
        if (i < totemList.size()) {
            return I18n.func_135052_a((String)totemList.get(i).getUnlocalizedName(), (Object[])new Object[0]);
        }
        if (i == totemList.size()) {
            return I18n.func_135052_a((String)"tile.totemBase.name", (Object[])new Object[0]);
        }
        return "";
    }

    public static int getCarvingIndex(ItemStack stack) {
        NBTTagCompound tag = stack.func_77978_p();
        if (tag == null) {
            return totemList.size();
        }
        return MathHelper.func_76125_a((int)tag.func_74762_e("totem"), (int)0, (int)totemList.size());
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, EntityPlayer player, List<String> list, boolean par4) {
        list.add(I18n.func_135052_a((String)"item.totemic:totemWhittlingKnife.tooltip1", (Object[])new Object[0]));
        list.add(I18n.func_135052_a((String)"item.totemic:totemWhittlingKnife.tooltip2", (Object[])new Object[0]));
        list.add(I18n.func_135052_a((String)"item.totemic:totemWhittlingKnife.tooltip3", (Object[])new Object[]{this.getCurrentlyCarving(ItemTotemWhittlingKnife.getCarvingIndex(stack))}));
    }

    @SideOnly(value=Side.CLIENT)
    public String func_77653_i(ItemStack stack) {
        return I18n.func_135052_a((String)(this.func_77658_a() + ".display"), (Object[])new Object[]{this.getCurrentlyCarving(ItemTotemWhittlingKnife.getCarvingIndex(stack))});
    }

    public ActionResult<ItemStack> func_77659_a(ItemStack itemStack, World world, EntityPlayer player, EnumHand hand) {
        if (player.func_70093_af()) {
            return new ActionResult(EnumActionResult.SUCCESS, (Object)ItemTotemWhittlingKnife.changeIndex(itemStack, 1));
        }
        return new ActionResult(EnumActionResult.FAIL, (Object)itemStack);
    }

    public EnumActionResult func_180614_a(ItemStack stack, EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (player.func_70093_af()) {
            EntityEquipmentSlot slot = hand == EnumHand.MAIN_HAND ? EntityEquipmentSlot.MAINHAND : EntityEquipmentSlot.OFFHAND;
            player.func_184201_a(slot, (ItemStack)this.func_77659_a(stack, world, player, hand).func_188398_b());
            return EnumActionResult.SUCCESS;
        }
        if (world.field_72995_K) {
            return EnumActionResult.SUCCESS;
        }
        IBlockState state = world.func_180495_p(pos);
        WoodVariant wood = WoodVariant.fromLog(state);
        if (wood == null) {
            return EnumActionResult.FAIL;
        }
        int index = ItemTotemWhittlingKnife.getCarvingIndex(stack);
        if (index == totemList.size()) {
            world.func_180501_a(pos, ModBlocks.totemBase.func_176223_P().func_177226_a(BlockTotemBase.WOOD, (Comparable)((Object)wood)), 3);
        } else if (index < totemList.size()) {
            world.func_180501_a(pos, ModBlocks.totemPole.func_176223_P().func_177226_a(BlockTotemPole.WOOD, (Comparable)((Object)wood)), 0);
            TileTotemPole tile = (TileTotemPole)world.func_175625_s(pos);
            tile.effect = totemList.get(ItemTotemWhittlingKnife.getCarvingIndex(stack));
            tile.func_70296_d();
            tile.markForUpdate();
        } else {
            return EnumActionResult.FAIL;
        }
        stack.func_77972_a(1, (EntityLivingBase)player);
        return EnumActionResult.SUCCESS;
    }

    public static ItemStack changeIndex(ItemStack itemStack, int i) {
        ItemStack stack = itemStack.func_77946_l();
        int newIndex = (i + ItemTotemWhittlingKnife.getCarvingIndex(stack)) % (totemList.size() + 1);
        if (newIndex < 0) {
            newIndex += totemList.size() + 1;
        }
        ItemUtil.getOrCreateTag(stack).func_74768_a("totem", newIndex);
        return stack;
    }
}

