/*
 * Decompiled with CFR 0.152.
 */
package totemic_commons.pokefenn.network.client;

import gnu.trove.iterator.TObjectIntIterator;
import gnu.trove.map.TObjectIntMap;
import io.netty.buffer.ByteBuf;
import net.minecraft.client.Minecraft;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import totemic_commons.pokefenn.Totemic;
import totemic_commons.pokefenn.api.music.MusicInstrument;
import totemic_commons.pokefenn.network.SynchronizedPacketBase;
import totemic_commons.pokefenn.tileentity.totem.TileTotemBase;

public class PacketCeremonyStartup
extends SynchronizedPacketBase<PacketCeremonyStartup> {
    private BlockPos pos;
    private int startupTime = 0;
    private String[] instruments = null;
    private int[] values = null;

    public PacketCeremonyStartup(BlockPos pos, TObjectIntMap<MusicInstrument> ceremonyMusic, int startupTime) {
        this.pos = pos;
        this.startupTime = startupTime;
        this.instruments = new String[ceremonyMusic.size()];
        this.values = new int[ceremonyMusic.size()];
        TObjectIntIterator it = ceremonyMusic.iterator();
        for (int i = 0; i < ceremonyMusic.size(); ++i) {
            it.advance();
            this.instruments[i] = ((MusicInstrument)it.key()).getName();
            this.values[i] = it.value();
        }
    }

    public PacketCeremonyStartup() {
    }

    public void fromBytes(ByteBuf buf) {
        this.pos = BlockPos.func_177969_a((long)buf.readLong());
        this.startupTime = buf.readInt();
        int len = buf.readByte();
        this.instruments = new String[len];
        this.values = new int[len];
        for (int i = 0; i < len; ++i) {
            this.instruments[i] = ByteBufUtils.readUTF8String((ByteBuf)buf);
            this.values[i] = buf.readShort();
        }
    }

    public void toBytes(ByteBuf buf) {
        buf.writeLong(this.pos.func_177986_g());
        buf.writeInt(this.startupTime);
        buf.writeByte(this.instruments.length);
        for (int i = 0; i < this.instruments.length; ++i) {
            ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.instruments[i]);
            buf.writeShort(this.values[i]);
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    protected void handleClient(MessageContext ctx) {
        TileEntity tile = Minecraft.func_71410_x().field_71441_e.func_175625_s(this.pos);
        if (tile instanceof TileTotemBase) {
            TileTotemBase totem = (TileTotemBase)tile;
            totem.ceremonyStartupTimer = this.startupTime;
            totem.ceremonyMusic.clear();
            for (int i = 0; i < this.instruments.length; ++i) {
                totem.ceremonyMusic.put((Object)Totemic.api.registry().getInstrument(this.instruments[i]), this.values[i]);
            }
            totem.recalculateMelody();
        }
    }
}

