/*
 * Decompiled with CFR 0.152.
 */
package totemic_commons.pokefenn.tileentity.totem;

import gnu.trove.map.TObjectIntMap;
import gnu.trove.map.hash.TObjectIntHashMap;
import java.util.ArrayList;
import java.util.Arrays;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.init.Biomes;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ITickable;
import net.minecraft.world.WorldServer;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import totemic_commons.pokefenn.ModBlocks;
import totemic_commons.pokefenn.Totemic;
import totemic_commons.pokefenn.api.ceremony.Ceremony;
import totemic_commons.pokefenn.api.music.MusicAcceptor;
import totemic_commons.pokefenn.api.music.MusicInstrument;
import totemic_commons.pokefenn.api.totem.TotemBase;
import totemic_commons.pokefenn.api.totem.TotemEffect;
import totemic_commons.pokefenn.block.totem.BlockTotemBase;
import totemic_commons.pokefenn.handler.GameOverlay;
import totemic_commons.pokefenn.lib.WoodVariant;
import totemic_commons.pokefenn.network.NetworkHandler;
import totemic_commons.pokefenn.network.client.PacketCeremonyStartup;
import totemic_commons.pokefenn.network.client.PacketTotemEffectMusic;
import totemic_commons.pokefenn.tileentity.TileTotemic;
import totemic_commons.pokefenn.tileentity.totem.TileTotemPole;

public class TileTotemBase
extends TileTotemic
implements MusicAcceptor,
TotemBase,
ITickable {
    public static final int MAX_HEIGHT = 5;
    public static final int MAX_EFFECT_MUSIC = 128;
    private boolean firstTick = true;
    private int dancingEfficiency = 0;
    public int musicForTotemEffect = 0;
    private int totemPoleSize = 0;
    private boolean musicChanged = false;
    private final TotemEffect[] effects = new TotemEffect[5];
    private final TObjectIntMap<TotemEffect> repetitionBonus = new TObjectIntHashMap(Totemic.api.registry().getTotems().size(), 0.75f);
    private int totemWoodBonus = 0;
    public boolean isCeremony = false;
    public final ArrayList<MusicInstrument> musicSelector = new ArrayList(4);
    public final TObjectIntMap<MusicInstrument> ceremonyMusic = new TObjectIntHashMap(Totemic.api.registry().getInstruments().size(), 0.75f);
    public final TObjectIntMap<MusicInstrument> timesPlayed = new TObjectIntHashMap(Totemic.api.registry().getInstruments().size(), 0.75f);
    public int totalCeremonyMelody = 0;
    public Ceremony startupCeremony = null;
    public Ceremony currentCeremony = null;
    public int ceremonyStartupTimer = 0;
    public int ceremonyEffectTimer = 0;
    public int continueTimer = 0;
    public boolean isDoingEndingEffect = false;

    public void func_73660_a() {
        if (this.firstTick) {
            this.calculateTotemWoodBonus();
            this.firstTick = false;
        }
        if (this.field_145850_b.func_82737_E() % 80L == 0L) {
            this.totemPoleSize = this.calculateTotemPoleAmount();
            this.calculateEffects();
        }
        this.diminishMelody();
        if (!this.field_145850_b.field_72995_K) {
            if (this.isCeremony) {
                this.doCeremonyCode();
            } else {
                if (this.field_145850_b.func_82737_E() % 600L == 0L) {
                    this.timesPlayed.clear();
                }
                this.totemEffect();
                if (this.field_145850_b.func_82737_E() % 20L == 0L) {
                    this.syncMelody();
                }
            }
        } else {
            if (this.isCeremony) {
                this.doCeremonyClient();
            } else {
                this.totemEffect();
            }
            if (this.field_145850_b.func_82737_E() % 40L == 0L) {
                if (!this.isCeremony) {
                    this.spawnParticles();
                } else {
                    this.spawnParticlesCeremony();
                }
            }
        }
    }

    private void totemEffect() {
        if (this.totemPoleSize > 0) {
            for (TotemEffect effect : this.effects) {
                if (effect == null) continue;
                int[] ranges = this.getRanges(effect);
                effect.effect(this.field_145850_b, this.field_174879_c, this, this.repetitionBonus.get((Object)effect), ranges[0], ranges[1]);
            }
        }
    }

    private void spawnParticles() {
        for (int i = 0; i < this.musicForTotemEffect / 16; ++i) {
            float dx = 2.0f * this.field_145850_b.field_73012_v.nextFloat() - 1.0f;
            float dz = 2.0f * this.field_145850_b.field_73012_v.nextFloat() - 1.0f;
            this.field_145850_b.func_175688_a(EnumParticleTypes.NOTE, (double)this.field_174879_c.func_177958_n() + 0.5 + (double)dx, (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p() + 0.5 + (double)dz, 0.0, 0.5, 0.0, new int[0]);
        }
    }

    private void spawnParticlesCeremony() {
        for (int i = 0; i < this.totalCeremonyMelody / 16; ++i) {
            float dx = 2.0f * this.field_145850_b.field_73012_v.nextFloat() - 1.0f;
            float dz = 2.0f * this.field_145850_b.field_73012_v.nextFloat() - 1.0f;
            this.field_145850_b.func_175688_a(EnumParticleTypes.NOTE, (double)this.field_174879_c.func_177958_n() + 0.5 + (double)dx, (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p() + 0.5 + (double)dz, 0.0, 0.5, 0.0, new int[0]);
        }
    }

    private void calculateTotemWoodBonus() {
        IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
        Biome biome = this.field_145850_b.func_180494_b(this.field_174879_c);
        if (biome == null) {
            biome = Biomes.field_76772_c;
        }
        this.totemWoodBonus = 0;
        switch ((WoodVariant)((Object)state.func_177229_b(BlockTotemBase.WOOD))) {
            case OAK: {
                this.totemWoodBonus += 2;
                break;
            }
            case SPRUCE: {
                if (biome.func_150561_m() != Biome.TempCategory.COLD) break;
                if (biome.func_76746_c()) {
                    this.totemWoodBonus += 2;
                }
                if (!(biome.func_185353_n() < 0.4f)) break;
                this.totemWoodBonus += 3;
                break;
            }
            case BIRCH: {
                if (!BiomeDictionary.isBiomeOfType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.FOREST)) break;
                this.totemWoodBonus += 2;
                break;
            }
            case JUNGLE: {
                if (biome.func_150561_m() != Biome.TempCategory.WARM || biome.func_76746_c() || !(biome.func_185353_n() > 1.0f)) break;
                this.totemWoodBonus += 4;
                break;
            }
            case ACACIA: {
                if (biome.func_150561_m() == Biome.TempCategory.WARM) {
                    this.totemWoodBonus += 3;
                }
                if (!BiomeDictionary.isBiomeOfType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.SPARSE)) break;
                this.totemWoodBonus += 2;
                break;
            }
            case DARK_OAK: {
                if (!BiomeDictionary.isBiomeOfType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.SPOOKY)) break;
                this.totemWoodBonus += 4;
                break;
            }
            case CEDAR: {
                this.totemWoodBonus += 5;
                if (!BiomeDictionary.isBiomeOfType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.MAGICAL)) break;
                this.totemWoodBonus += 2;
                break;
            }
        }
    }

    private void doCeremonyCode() {
        if (this.field_145850_b.func_82737_E() % 20L == 0L) {
            this.recalculateMelody();
        }
        if (this.isDoingStartup()) {
            if (this.canStartCeremony(this.startupCeremony)) {
                this.currentCeremony = this.startupCeremony;
                this.startupCeremony = null;
                this.isDoingEndingEffect = this.currentCeremony.getEffectTime() != 0;
                ((WorldServer)this.field_145850_b).func_175739_a(EnumParticleTypes.VILLAGER_HAPPY, (double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5, 24, 0.6, 0.5, 0.6, 1.0, new int[0]);
                this.markForUpdate();
                this.func_70296_d();
            } else {
                this.startupMain(this.startupCeremony);
            }
            ++this.ceremonyStartupTimer;
            if (this.field_145850_b.func_82737_E() % 20L == 0L) {
                NetworkHandler.sendAround(new PacketCeremonyStartup(this.field_174879_c, this.ceremonyMusic, this.ceremonyStartupTimer), this, 16.0);
            }
        }
        if (this.currentCeremony != null) {
            this.doCeremonyEffect(this.currentCeremony);
        }
        if (this.canMusicSelect() && this.field_145850_b.func_82737_E() % 1200L == 0L) {
            this.resetAfterCeremony(true);
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void doCeremonyClient() {
        if (this.currentCeremony != null) {
            this.currentCeremony.effect(this.field_145850_b, this.field_174879_c, this.ceremonyEffectTimer);
            if (this.currentCeremony.getEffectTime() == 0) {
                this.resetAfterCeremony(true);
            } else {
                ++this.ceremonyEffectTimer;
            }
        } else if (this.startupCeremony != null) {
            ++this.ceremonyStartupTimer;
        }
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        if (this.func_145835_a(player.field_70165_t, player.field_70163_u, player.field_70161_v) <= 64.0) {
            GameOverlay.activeTotem = this;
        } else if (GameOverlay.activeTotem == this) {
            GameOverlay.activeTotem = null;
        }
    }

    private void doCeremonyEffect(Ceremony cer) {
        if (cer.getEffectTime() == 0) {
            cer.effect(this.field_145850_b, this.field_174879_c, 0);
            this.resetAfterCeremony(true);
        } else if (this.ceremonyEffectTimer < cer.getEffectTime() && this.drainCeremonyMelody(cer)) {
            cer.effect(this.field_145850_b, this.field_174879_c, this.ceremonyEffectTimer);
            ++this.ceremonyEffectTimer;
        } else {
            this.resetAfterCeremony(true);
        }
    }

    public void addSelector(MusicInstrument instr) {
        if (!this.canMusicSelect()) {
            return;
        }
        this.isCeremony = true;
        this.musicSelector.add(instr);
        ((WorldServer)this.field_145850_b).func_175739_a(EnumParticleTypes.NOTE, (double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p() + 0.5, 6, 0.5, 0.5, 0.5, 0.0, new int[0]);
        this.markForUpdate();
        this.func_70296_d();
        if (this.musicSelector.size() < 2) {
            return;
        }
        for (Ceremony ceremony : Totemic.api.registry().getCeremonies().values()) {
            if (!this.selectorsMatch(ceremony.getInstruments())) continue;
            ((WorldServer)this.field_145850_b).func_175739_a(EnumParticleTypes.FIREWORKS_SPARK, (double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5, 16, 0.7, 0.5, 0.7, 0.0, new int[0]);
            this.startupCeremony = ceremony;
            this.resetSelector();
            return;
        }
        if (this.musicSelector.size() >= 4) {
            ((WorldServer)this.field_145850_b).func_175739_a(EnumParticleTypes.SMOKE_LARGE, (double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5, 16, 0.6, 0.5, 0.6, 0.0, new int[0]);
            this.resetAfterCeremony(true);
        }
    }

    private boolean selectorsMatch(MusicInstrument[] instrs) {
        return this.musicSelector.size() == instrs.length && this.musicSelector.equals(Arrays.asList(instrs));
    }

    private void diminishMelody() {
        if (this.musicForTotemEffect > 0 && this.field_145850_b.func_82737_E() % 47L == 0L) {
            --this.musicForTotemEffect;
            this.musicChanged = true;
            this.func_70296_d();
        }
    }

    public int[] getRanges(TotemEffect totem) {
        int horiz = totem.getHorizontalRange();
        int vert = totem.getVerticalRange();
        if (this.musicForTotemEffect >= 10 && this.musicForTotemEffect < 32) {
            ++horiz;
            ++vert;
        } else if (this.musicForTotemEffect >= 32 && this.musicForTotemEffect < 64) {
            horiz += 2;
            vert += 2;
        } else if (this.musicForTotemEffect >= 64 && this.musicForTotemEffect < 96) {
            horiz += 3;
            vert += 3;
        } else if (this.musicForTotemEffect >= 96 && this.musicForTotemEffect < 115) {
            horiz += 4;
            vert += 4;
        } else if (this.musicForTotemEffect >= 115) {
            horiz += 5;
            vert += 5;
        }
        horiz += this.totemWoodBonus / 3;
        vert += this.totemWoodBonus / 3;
        if (this.totemPoleSize == 5) {
            horiz += 2;
            vert += 2;
        }
        return new int[]{horiz, vert};
    }

    public void syncMelody() {
        if (this.musicChanged) {
            NetworkHandler.sendAround(new PacketTotemEffectMusic(this.field_174879_c, this.musicForTotemEffect), this, 32.0);
        }
        this.musicChanged = false;
    }

    public void recalculateMelody() {
        this.totalCeremonyMelody = 0;
        for (int value : this.ceremonyMusic.values()) {
            this.totalCeremonyMelody += value;
        }
    }

    public void resetAfterCeremony(boolean doResetMusicSelector) {
        this.currentCeremony = null;
        this.isCeremony = false;
        this.startupCeremony = null;
        this.ceremonyStartupTimer = 0;
        this.ceremonyEffectTimer = 0;
        this.isDoingEndingEffect = false;
        this.dancingEfficiency = 0;
        this.ceremonyMusic.clear();
        this.totalCeremonyMelody = 0;
        this.timesPlayed.clear();
        if (doResetMusicSelector) {
            this.resetSelector();
        }
        this.markForUpdate();
        this.func_70296_d();
    }

    public void resetSelector() {
        this.musicSelector.clear();
    }

    private boolean drainCeremonyMelody(Ceremony cer) {
        ++this.continueTimer;
        if (this.continueTimer > 100) {
            this.continueTimer = 0;
            this.totalCeremonyMelody = Math.max(this.totalCeremonyMelody - cer.getMusicPer5(), 0);
        }
        return this.totalCeremonyMelody >= cer.getMusicPer5();
    }

    public boolean canStartCeremony(Ceremony trying) {
        return this.totalCeremonyMelody >= trying.getMusicNeeded() - this.dancingEfficiency / 4;
    }

    private void startupMain(Ceremony trying) {
        if (this.ceremonyStartupTimer > trying.getAdjustedMaxStartupTime(this.field_145850_b.func_175659_aa())) {
            ((WorldServer)this.field_145850_b).func_175739_a(EnumParticleTypes.SMOKE_LARGE, (double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5, 16, 0.6, 0.5, 0.6, 0.0, new int[0]);
            this.resetAfterCeremony(true);
        }
        if (this.field_145850_b.func_82737_E() % 5L == 0L) {
            this.danceLikeAMonkey(trying);
        }
    }

    private void danceLikeAMonkey(Ceremony trying) {
    }

    protected void calculateEffects() {
        this.repetitionBonus.clear();
        for (int i = 0; i < this.totemPoleSize; ++i) {
            this.effects[i] = this.getTotemEffect(i);
            this.repetitionBonus.adjustOrPutValue((Object)this.effects[i], 1, 1);
        }
        Arrays.fill(this.effects, this.totemPoleSize, this.effects.length, null);
    }

    protected TotemEffect getTotemEffect(int yOffset) {
        TileEntity tileEntity = this.field_145850_b.func_175625_s(this.field_174879_c.func_177981_b(1 + yOffset));
        return tileEntity instanceof TileTotemPole ? ((TileTotemPole)tileEntity).getTotemEffect() : null;
    }

    protected int calculateTotemPoleAmount() {
        Block block;
        int y;
        for (y = 0; y < 5 && (block = this.field_145850_b.func_180495_p(this.field_174879_c.func_177981_b(1 + y)).func_177230_c()) == ModBlocks.totemPole; ++y) {
        }
        return y;
    }

    public SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.field_174879_c, 0, this.func_189517_E_());
    }

    public NBTTagCompound func_189517_E_() {
        return this.func_189515_b(new NBTTagCompound());
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        this.func_145839_a(pkt.func_148857_g());
    }

    @Override
    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        this.dancingEfficiency = tag.func_74762_e("dancingEfficiency");
        this.musicForTotemEffect = tag.func_74762_e("musicForTotemEffect");
        this.totemPoleSize = tag.func_74762_e("totemPoleSize");
        NBTTagList totemIdsTag = tag.func_150295_c("effects", 8);
        Arrays.fill(this.effects, null);
        for (int i = 0; i < totemIdsTag.func_74745_c(); ++i) {
            this.effects[i] = Totemic.api.registry().getTotem(totemIdsTag.func_150307_f(i));
        }
        this.isCeremony = tag.func_74767_n("isCeremony");
        if (this.isCeremony) {
            NBTTagCompound ceremonyMusicTag = tag.func_74775_l("ceremonyMusic");
            this.ceremonyMusic.clear();
            for (String key : ceremonyMusicTag.func_150296_c()) {
                MusicInstrument instr = Totemic.api.registry().getInstrument(key);
                if (instr != null) {
                    this.ceremonyMusic.put((Object)instr, ceremonyMusicTag.func_74762_e(key));
                    continue;
                }
                Totemic.logger.warn("Instrument {} does not exist", new Object[]{key});
            }
            this.recalculateMelody();
            this.startupCeremony = Totemic.api.registry().getCeremony(tag.func_74779_i("tryingCeremonyID"));
            this.currentCeremony = Totemic.api.registry().getCeremony(tag.func_74779_i("currentCeremony"));
            this.ceremonyStartupTimer = tag.func_74762_e("ceremonyStartupTimer");
            this.ceremonyEffectTimer = tag.func_74762_e("ceremonyEffectTimer");
            this.continueTimer = tag.func_74762_e("continueTimer");
            this.isDoingEndingEffect = tag.func_74767_n("isDoingEndingEffect");
        } else {
            this.startupCeremony = null;
            this.currentCeremony = null;
        }
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        tag = super.func_189515_b(tag);
        tag.func_74768_a("dancingEfficiency", this.dancingEfficiency);
        tag.func_74768_a("musicForTotemEffect", this.musicForTotemEffect);
        tag.func_74768_a("totemPoleSize", this.totemPoleSize);
        NBTTagList totemIdsTag = new NBTTagList();
        for (TotemEffect effect : this.effects) {
            totemIdsTag.func_74742_a((NBTBase)new NBTTagString(String.valueOf(effect)));
        }
        tag.func_74782_a("effects", (NBTBase)totemIdsTag);
        tag.func_74757_a("isCeremony", this.isCeremony);
        if (this.isCeremony) {
            NBTTagCompound ceremonyMusicTag = new NBTTagCompound();
            this.ceremonyMusic.forEachEntry((instr, amount) -> {
                ceremonyMusicTag.func_74768_a(instr.getName(), amount);
                return true;
            });
            tag.func_74782_a("ceremonyMusic", (NBTBase)ceremonyMusicTag);
            if (this.startupCeremony != null) {
                tag.func_74778_a("tryingCeremonyID", this.startupCeremony.getName());
            }
            if (this.currentCeremony != null) {
                tag.func_74778_a("currentCeremony", this.currentCeremony.getName());
            }
            tag.func_74768_a("ceremonyStartupTimer", this.ceremonyStartupTimer);
            tag.func_74768_a("ceremonyEffectTimer", this.ceremonyEffectTimer);
            tag.func_74768_a("continueTimer", this.continueTimer);
            tag.func_74757_a("isDoingEndingEffect", this.isDoingEndingEffect);
        }
        return tag;
    }

    @Override
    public boolean addMusic(MusicInstrument instr, int amount) {
        boolean added;
        if (!this.isCeremony) {
            this.timesPlayed.adjustOrPutValue((Object)instr, 1, 1);
            int prevVal = this.musicForTotemEffect;
            this.musicForTotemEffect = Math.min(prevVal + amount / 2, 128);
            added = this.musicForTotemEffect > prevVal;
        } else if (this.isDoingStartup()) {
            this.timesPlayed.adjustOrPutValue((Object)instr, 1, 1);
            int prevVal = this.ceremonyMusic.get((Object)instr);
            amount = this.getDiminishedMusic(instr, amount);
            int newVal = Math.min(prevVal + amount, instr.getMusicMaximum());
            this.ceremonyMusic.put((Object)instr, newVal);
            added = newVal > prevVal;
        } else {
            added = false;
        }
        if (added) {
            this.musicChanged = true;
            this.func_70296_d();
        }
        return added;
    }

    public int getDiminishedMusic(MusicInstrument instr, int amount) {
        if (this.timesPlayed.get((Object)instr) >= amount) {
            return amount * 3 / 4;
        }
        return amount;
    }

    public boolean isDoingStartup() {
        return this.startupCeremony != null;
    }

    public boolean isDoingCeremonyEffect() {
        return this.currentCeremony != null;
    }

    public boolean canMusicSelect() {
        return !this.isDoingStartup() && !this.isDoingCeremonyEffect();
    }

    @Override
    public int getTotemEffectMusic() {
        return this.musicForTotemEffect;
    }

    @Override
    public int getPoleSize() {
        return this.totemPoleSize;
    }

    @Override
    public int getRepetition(TotemEffect effect) {
        return this.repetitionBonus.get((Object)effect);
    }

    @Override
    public TotemEffect[] getEffects() {
        return (TotemEffect[])this.effects.clone();
    }

    @Override
    public int getWoodBonus() {
        return this.totemWoodBonus;
    }
}

