/*
 * Decompiled with CFR 0.152.
 */
package totemic_commons.pokefenn.totempedia.page;

import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;
import totemic_commons.pokefenn.api.ceremony.Ceremony;
import totemic_commons.pokefenn.api.music.MusicInstrument;
import totemic_commons.pokefenn.client.RenderHelper;
import totemic_commons.pokefenn.totempedia.page.PageRecipe;
import totemic_commons.pokefenn.totempedia.page.PageText;
import totemic_commons.pokefenn.util.TotemUtil;
import vazkii.botania.totemic_custom.api.internal.IGuiLexiconEntry;

public class PageCeremony
extends PageRecipe {
    public ResourceLocation ceremonyOverlay = new ResourceLocation("totemic:textures/gui/ceremonyOverlay.png");
    public Ceremony ceremony;

    public PageCeremony(String unlocalizedName, Ceremony ceremony) {
        super(unlocalizedName);
        this.ceremony = Objects.requireNonNull(ceremony);
    }

    @Override
    public void renderScreen(IGuiLexiconEntry gui, int mx, int my) {
        this.relativeMouseX = mx;
        this.relativeMouseY = my;
        TextureManager render = Minecraft.func_71410_x().field_71446_o;
        FontRenderer font = Minecraft.func_71410_x().field_71466_p;
        String musicNeeded = TotemUtil.getMusicNeededLocalized(this.ceremony.getMusicNeeded());
        MusicInstrument[] instruments = this.ceremony.getInstruments();
        int instrLeft = gui.getLeft() + gui.getWidth() / 2 - 10 * instruments.length;
        for (int i = 0; i < instruments.length; ++i) {
            ItemStack item = instruments[i].getItem();
            if (item == null) continue;
            this.renderItem(gui, instrLeft + 20 * i, gui.getTop() + 31, item, false);
        }
        if (this.tooltipStack != null) {
            RenderHelper.renderTooltip(mx, my, this.tooltipStack.func_82840_a((EntityPlayer)Minecraft.func_71410_x().field_71439_g, false));
        }
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        PageText.renderText(gui.getLeft() + gui.getWidth() / 2 - font.func_78256_a(musicNeeded) / 3, gui.getTop() + 90, font.func_78256_a(musicNeeded), 150, musicNeeded);
        String text = I18n.func_135052_a((String)"totemicmisc.musicSelector", (Object[])new Object[0]);
        font.func_78276_b(text, gui.getLeft() + gui.getWidth() / 2 - font.func_78256_a(text) / 2, gui.getTop() + 14, 0x66000000);
        text = I18n.func_135052_a((String)this.getUnlocalizedName(), (Object[])new Object[0]);
        PageText.renderText(gui.getLeft() + gui.getWidth() / 2 - font.func_78256_a(text) / 3, gui.getTop() + 150, 150, 150, text);
        GL11.glDisable((int)3042);
        render.func_110577_a(this.ceremonyOverlay);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        ((GuiScreen)gui).func_73729_b(gui.getLeft(), gui.getTop(), 0, 0, gui.getWidth(), gui.getHeight());
        GL11.glDisable((int)3042);
        this.tooltipContainerStack = null;
        this.tooltipStack = null;
        this.tooltipEntry = false;
        mouseDownLastTick = Mouse.isButtonDown((int)0);
    }
}

