/*
 * Decompiled with CFR 0.152.
 */
package totemic_commons.pokefenn.util;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EntityUtil {
    public static <T extends Entity> List<T> getEntitiesInRange(Class<? extends T> clazz, World world, double posX, double posY, double posZ, double horizontalRadius, double verticalRadius) {
        return world.func_72872_a(clazz, new AxisAlignedBB(posX - 0.5, posY - 0.5, posZ - 0.5, posX + 0.5, posY + 0.5, posZ + 0.5).func_72314_b(horizontalRadius, verticalRadius, horizontalRadius));
    }

    public static <T extends Entity> List<T> getEntitiesInRange(Class<? extends T> clazz, World world, BlockPos pos, double horizontalRadius, double verticalRadius) {
        return EntityUtil.getEntitiesInRange(clazz, world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), horizontalRadius, verticalRadius);
    }

    public static List<TileEntity> getTileEntitiesInRange(World world, BlockPos pos, int horizontalRadius, int verticalRadius) {
        return EntityUtil.getTileEntitiesIn(world, pos.func_177982_a(-horizontalRadius, -verticalRadius, -horizontalRadius), pos.func_177982_a(horizontalRadius + 1, verticalRadius + 1, horizontalRadius + 1));
    }

    public static List<TileEntity> getTileEntitiesIn(World world, BlockPos min, BlockPos max) {
        ArrayList<TileEntity> list = new ArrayList<TileEntity>();
        for (int x = min.func_177958_n() & 0xFFFFFFF0; x < max.func_177958_n(); x += 16) {
            for (int z = min.func_177952_p() & 0xFFFFFFF0; z < max.func_177952_p(); z += 16) {
                Chunk chunk;
                if (!world.func_175668_a(new BlockPos(x, 0, z), true) || (chunk = world.func_72964_e(x >> 4, z >> 4)) == null || chunk.func_76621_g()) continue;
                for (TileEntity tile : chunk.func_177434_r().values()) {
                    BlockPos pos;
                    if (tile.func_145837_r() || (pos = tile.func_174877_v()).func_177958_n() < min.func_177958_n() || pos.func_177956_o() < min.func_177956_o() || pos.func_177952_p() < min.func_177952_p() || pos.func_177958_n() >= max.func_177958_n() || pos.func_177956_o() >= max.func_177956_o() || pos.func_177952_p() >= max.func_177952_p()) continue;
                    list.add(tile);
                }
            }
        }
        return list;
    }

    public static void spawnEntity(World world, double xPos, double yPos, double zPos, Entity entity) {
        entity.func_70107_b(xPos, yPos, zPos);
        world.func_72838_d(entity);
    }

    public static void dropItem(World world, double xPos, double yPos, double zPos, ItemStack itemStack) {
        EntityItem item = new EntityItem(world, xPos, yPos, zPos, itemStack);
        item.func_174869_p();
        world.func_72838_d((Entity)item);
    }

    public static void dropItem(World world, double xPos, double yPos, double zPos, Item item) {
        EntityUtil.dropItem(world, xPos, yPos, zPos, new ItemStack(item));
    }

    public static RayTraceResult raytraceFromEntity(World world, Entity player, boolean par3, double range) {
        float f = 1.0f;
        float f1 = player.field_70127_C + (player.field_70125_A - player.field_70127_C) * f;
        float f2 = player.field_70126_B + (player.field_70177_z - player.field_70126_B) * f;
        double d0 = player.field_70169_q + (player.field_70165_t - player.field_70169_q) * (double)f;
        double d1 = player.field_70167_r + (player.field_70163_u - player.field_70167_r) * (double)f;
        if (!world.field_72995_K && player instanceof EntityPlayer) {
            d1 += 1.62;
        }
        double d2 = player.field_70166_s + (player.field_70161_v - player.field_70166_s) * (double)f;
        Vec3d vec3 = new Vec3d(d0, d1, d2);
        float f3 = MathHelper.func_76134_b((float)(-f2 * ((float)Math.PI / 180) - (float)Math.PI));
        float f4 = MathHelper.func_76126_a((float)(-f2 * ((float)Math.PI / 180) - (float)Math.PI));
        float f5 = -MathHelper.func_76134_b((float)(-f1 * ((float)Math.PI / 180)));
        float f6 = MathHelper.func_76126_a((float)(-f1 * ((float)Math.PI / 180)));
        float f7 = f4 * f5;
        float f8 = f3 * f5;
        double d3 = range;
        if (player instanceof EntityPlayerMP) {
            d3 = ((EntityPlayerMP)player).field_71134_c.getBlockReachDistance();
        }
        Vec3d vec31 = vec3.func_72441_c((double)f7 * d3, (double)f6 * d3, (double)f8 * d3);
        return world.func_72901_a(vec3, vec31, par3);
    }

    public static IBlockState getBlockFromPosition(RayTraceResult movingObjectPosition, World world) {
        return world.func_180495_p(movingObjectPosition.func_178782_a());
    }

    @SideOnly(value=Side.CLIENT)
    public static EntityPlayer getClientPlayer() {
        return Minecraft.func_71410_x().field_71439_g;
    }
}

