/*
 * Decompiled with CFR 0.152.
 */
package totemic_commons.pokefenn.util;

import java.util.Comparator;
import net.minecraft.entity.Entity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import totemic_commons.pokefenn.api.music.MusicAcceptor;
import totemic_commons.pokefenn.api.music.MusicInstrument;
import totemic_commons.pokefenn.tileentity.totem.TileTotemBase;
import totemic_commons.pokefenn.util.EntityUtil;

public class TotemUtil {
    public static String getMusicNeededLocalized(int music) {
        String welp = "totemic.musicNeeded.";
        String unlocalized = "";
        unlocalized = music == 0 ? "none" : (music <= 120 ? "little" : (music <= 150 ? "littleMedium" : (music <= 180 ? "medium" : (music <= 210 ? "mediumLarge" : (music <= 240 ? "large" : "crazyLarge")))));
        return welp + unlocalized;
    }

    public static MusicAcceptor getClosestAcceptor(WorldServer world, double x, double y, double z, int horizontalRadius, int verticalRadius) {
        return EntityUtil.getTileEntitiesInRange((World)world, new BlockPos(x, y, z), horizontalRadius, verticalRadius).stream().filter(te -> te instanceof MusicAcceptor).min(Comparator.comparing(te -> te.func_145835_a(x, y, z))).orElse(null);
    }

    public static void playMusicForSelector(World world, double x, double y, double z, MusicInstrument instr, int bonusRadius) {
        int radius = instr.getBaseRange() + bonusRadius;
        MusicAcceptor tile = TotemUtil.getClosestAcceptor((WorldServer)world, x, y, z, radius, radius);
        if (tile instanceof TileTotemBase && ((TileTotemBase)tile).canMusicSelect()) {
            ((TileTotemBase)tile).addSelector(instr);
        }
    }

    public static void playMusicForSelector(World world, BlockPos pos, MusicInstrument instr, int bonusRadius) {
        TotemUtil.playMusicForSelector(world, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, instr, bonusRadius);
    }

    public static void playMusic(World world, double x, double y, double z, MusicInstrument instr, int bonusRadius, int bonusMusicAmount) {
        int radius = instr.getBaseRange() + bonusRadius;
        MusicAcceptor tile = TotemUtil.getClosestAcceptor((WorldServer)world, x, y, z, radius, radius);
        if (tile != null) {
            int shiftedMusic = instr.getBaseOutput() + bonusMusicAmount;
            TotemUtil.addMusic(tile, instr, shiftedMusic, instr.getMusicMaximum());
        }
    }

    public static void playMusic(World world, BlockPos pos, MusicInstrument instr, int bonusRadius, int bonusMusicAmount) {
        TotemUtil.playMusic(world, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, instr, bonusRadius, bonusMusicAmount);
    }

    public static void addMusic(MusicAcceptor tile, MusicInstrument instr, int musicAmount, int musicMaximum) {
        TileEntity te = (TileEntity)tile;
        WorldServer world = (WorldServer)te.func_145831_w();
        BlockPos pos = te.func_174877_v();
        if (tile.addMusic(instr, musicAmount)) {
            world.func_175739_a(EnumParticleTypes.NOTE, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o(), (double)pos.func_177952_p() + 0.5, 6, 0.5, 0.5, 0.5, 0.0, new int[0]);
        } else {
            world.func_175739_a(EnumParticleTypes.CLOUD, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, 6, 0.5, 0.5, 0.5, 0.0, new int[0]);
        }
    }

    public static void playSound(Entity entity, SoundEvent sound, SoundCategory category, float volume, float pitch) {
        entity.field_70170_p.func_184148_a(null, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, sound, category, volume, pitch);
    }

    public static void playSound(World world, BlockPos pos, SoundEvent sound, SoundCategory category, float volume, float pitch) {
        world.func_184133_a(null, pos, sound, category, volume, pitch);
    }
}

