/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.totemic_custom.api.lexicon;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.client.resources.I18n;
import vazkii.botania.totemic_custom.api.lexicon.LexiconCategory;
import vazkii.botania.totemic_custom.api.lexicon.LexiconPage;

public class LexiconEntry
implements Comparable<LexiconEntry> {
    public final String unlocalizedName;
    public final LexiconCategory category;
    public List<LexiconPage> pages = new ArrayList<LexiconPage>();
    private boolean priority = false;

    public LexiconEntry(String unlocalizedName, LexiconCategory category) {
        this.unlocalizedName = unlocalizedName;
        this.category = category;
    }

    public LexiconEntry setPriority() {
        this.priority = true;
        return this;
    }

    public boolean isPriority() {
        return this.priority;
    }

    public String getUnlocalizedName() {
        return this.unlocalizedName;
    }

    public LexiconEntry setLexiconPages(LexiconPage ... pages) {
        this.pages.addAll(Arrays.asList(pages));
        for (int i = 0; i < this.pages.size(); ++i) {
            this.pages.get(i).onPageAdded(this, i);
        }
        return this;
    }

    public void addPage(LexiconPage page) {
        this.pages.add(page);
    }

    public final String getNameForSorting() {
        return (this.priority ? 0 : 1) + I18n.func_135052_a((String)this.getUnlocalizedName(), (Object[])new Object[0]);
    }

    @Override
    public int compareTo(LexiconEntry o) {
        return this.getNameForSorting().compareTo(o.getNameForSorting());
    }
}

