/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.totemic_custom.api.lexicon;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.item.ItemStack;
import vazkii.botania.totemic_custom.api.lexicon.IRecipeKeyProvider;
import vazkii.botania.totemic_custom.api.lexicon.LexiconEntry;

public final class LexiconRecipeMappings {
    private static Map<String, EntryData> mappings = new HashMap<String, EntryData>();

    public static void map(ItemStack stack, LexiconEntry entry, int page, boolean force) {
        EntryData data = new EntryData(entry, page);
        String str = LexiconRecipeMappings.stackToString(stack);
        if (force || !mappings.containsKey(str)) {
            mappings.put(str, data);
        }
    }

    public static void map(ItemStack stack, LexiconEntry entry, int page) {
        LexiconRecipeMappings.map(stack, entry, page, false);
    }

    public static EntryData getDataForStack(ItemStack stack) {
        return mappings.get(LexiconRecipeMappings.stackToString(stack));
    }

    public static String stackToString(ItemStack stack) {
        if (stack.func_77942_o() && stack.func_77973_b() instanceof IRecipeKeyProvider) {
            return ((IRecipeKeyProvider)stack.func_77973_b()).getKey(stack);
        }
        return stack.func_77977_a() + "~" + stack.func_77952_i();
    }

    public static class EntryData {
        public final LexiconEntry entry;
        public final int page;

        public EntryData(LexiconEntry entry, int page) {
            this.entry = entry;
            this.page = page;
        }
    }
}

