/*
 * Decompiled with CFR 0.152.
 */
package team.chisel;

import com.google.common.base.Predicate;
import java.beans.ConstructorProperties;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.block.Block;
import net.minecraft.block.BlockPlanks;
import net.minecraft.block.BlockPrismarine;
import net.minecraft.block.BlockQuartz;
import net.minecraft.block.BlockRedSandstone;
import net.minecraft.block.BlockRotatedPillar;
import net.minecraft.block.BlockSandStone;
import net.minecraft.block.BlockStainedGlass;
import net.minecraft.block.BlockStone;
import net.minecraft.block.BlockStoneBrick;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.IBlockState;
import net.minecraft.block.state.pattern.BlockMatcher;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.oredict.ShapedOreRecipe;
import team.chisel.Chisel;
import team.chisel.api.block.BlockCreator;
import team.chisel.api.block.BlockProvider;
import team.chisel.api.block.ChiselBlockFactory;
import team.chisel.api.block.VariationData;
import team.chisel.api.carving.CarvingUtils;
import team.chisel.common.block.BlockCarvable;
import team.chisel.common.block.BlockCarvableBookshelf;
import team.chisel.common.block.ItemChiselBlock;
import team.chisel.common.carving.Carving;
import team.chisel.common.config.Configurations;
import team.chisel.common.init.ChiselBlocks;
import team.chisel.common.util.GenerationHandler;

public enum Features {
    ALUMINUM{

        @Override
        void addBlocks(ChiselBlockFactory factory) {
            factory.newBlock(Material.field_151576_e, "blockAluminum", provider).setParentFolder("metals/aluminum").newVariation("caution").next("crate").next("thermal").next("machine").next("badGreggy").next("bolted").next("scaffold").build();
            CarvingUtils.getChiselRegistry().registerOre("blockAluminum", "blockAluminum");
        }
    }
    ,
    ANDESITE{

        @Override
        void addBlocks(ChiselBlockFactory factory) {
            IBlockState stone = Blocks.field_150348_b.func_176223_P();
            PropertyEnum prop = BlockStone.field_176247_a;
            Carving.chisel.addVariation("andesite", stone.func_177226_a((IProperty)prop, (Comparable)BlockStone.EnumType.ANDESITE), -21);
            Carving.chisel.addVariation("andesite", stone.func_177226_a((IProperty)prop, (Comparable)BlockStone.EnumType.ANDESITE_SMOOTH), -20);
            CarvingUtils.getChiselRegistry().registerOre("andesite", "stoneAndesite");
            factory.newBlock(Material.field_151576_e, "andesite", provider).newVariation("cracked").next("bricks-soft").next("bricks-cracked").next("bricks-triple").next("bricks-encased").next("braid").next("array").next("tiles-large").next("tiles-small").next("chaotic-medium").next("chaotic-small").next("dent").next("french-1").next("french-2").next("jellybean").next("layers").next("mosaic").next("ornate").next("panel").next("road").next("slanted").next("zag").next("circularct").next("weaver").next("bricks-solid").next("bricks-small").next("circular").next("tiles-medium").next("pillar").next("twisted").next("prism").build(b -> b.func_149711_c(1.5f).func_149752_b(30.0f).func_149672_a(SoundType.field_185851_d));
        }
    }
    ,
    ANTIBLOCK{

        @Override
        void addBlocks(ChiselBlockFactory factory) {
            factory.newBlock(Material.field_151576_e, "antiblock", provider).newVariation("black").next("red").next("green").next("brown").next("blue").next("purple").next("cyan").next("silver").next("gray").next("pink").next("lime").next("yellow").next("light_blue").next("magenta").next("orange").next("white").build();
        }

        @Override
        void addRecipes() {
            GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack((Block)ChiselBlocks.antiblock, 8, 15), new Object[]{"SSS", "SGS", "SSS", Character.valueOf('S'), "stone", Character.valueOf('G'), "dustGlowstone"}));
        }
    }
    ,
    BASALT{

        @Override
        void addBlocks(ChiselBlockFactory factory) {
            factory.newBlock(Material.field_151576_e, "basalt", provider).newVariation("cracked").next("bricks-soft").next("bricks-cracked").next("bricks-triple").next("bricks-encased").next("braid").next("array").next("tiles-large").next("tiles-small").next("chaotic-medium").next("chaotic-small").next("dent").next("french-1").next("french-2").next("jellybean").next("layers").next("mosaic").next("ornate").next("panel").next("road").next("slanted").next("zag").next("circularct").next("weaver").build(b -> b.func_149711_c(1.5f).func_149752_b(10.0f).func_149672_a(SoundType.field_185851_d));
            factory.newBlock(Material.field_151576_e, "basaltextra", provider).setGroup("basalt").setParentFolder("basalt").newVariation("bricks-solid").next("bricks-small").next("circular").next("tiles-medium").next("pillar").next("twisted").next("prism").next("raw").setOrder(-100).build(b -> b.func_149711_c(1.5f).func_149752_b(10.0f).func_149672_a(SoundType.field_185851_d));
            CarvingUtils.getChiselRegistry().registerOre("basalt", "stoneBasalt");
        }

        @Override
        void addRecipes() {
            if (!Configurations.basaltSpecialGen) {
                GenerationHandler.INSTANCE.addGeneration(ChiselBlocks.basaltextra.func_176223_P().func_177226_a((IProperty)ChiselBlocks.basaltextra.getMetaProp(), (Comparable)Integer.valueOf(7)), new GenerationHandler.WorldGenInfo(Configurations.basaltVeinAmount, 0, 32, 1.0, (Predicate<IBlockState>)BlockMatcher.func_177642_a((Block)Blocks.field_150348_b)));
            }
        }
    }
    ,
    BLOOD_MAGIC{

        @Override
        void addBlocks(ChiselBlockFactory factory) {
            factory.newBlock(Material.field_151576_e, "bloodMagic", provider).newVariation("bloodRuneArranged").next("bloodRuneBricks").next("bloodRuneCarved").next("bloodRuneCarvedRadial").next("bloodRuneClassicPanel").next("bloodRuneTiles").build();
        }
    }
    ,
    BOOKSHELF{

        @Override
        void addBlocks(ChiselBlockFactory factory) {
            Carving.chisel.addVariation("bookshelf", Blocks.field_150342_X.func_176223_P(), -1);
            factory.newBlock(Material.field_151575_d, "bookshelf", new ChiselBlockProvider<BlockCarvableBookshelf>(BlockCarvableBookshelf::new, BlockCarvableBookshelf.class)).newVariation("rainbow").next("necromancer-novice").next("necromancer").next("redtomes").next("abandoned").next("hoarder").next("brim").next("historician").build(b -> b.func_149672_a(SoundType.field_185848_a).func_149711_c(1.5f));
            for (int c = 1; c < this.plank_names.length; ++c) {
                factory.newBlock(Material.field_151575_d, "bookshelf_" + this.plank_names[c], new ChiselBlockProvider<BlockCarvableBookshelf>(BlockCarvableBookshelf::new, BlockCarvableBookshelf.class)).newVariation("rainbow").next("necromancer-novice").next("necromancer").next("redtomes").next("abandoned").next("hoarder").next("brim").next("historician").build(b -> b.func_149672_a(SoundType.field_185848_a).func_149711_c(1.5f));
            }
        }
    }
    ,
    BRICKS{

        @Override
        void addBlocks(ChiselBlockFactory factory) {
            Carving.chisel.addVariation("bricks", Blocks.field_150336_V.func_176223_P(), -1);
            factory.newBlock(Material.field_151576_e, "bricks", provider).newVariation("cracked").next("bricks-soft").next("bricks-cracked").next("bricks-triple").next("bricks-encased").next("braid").next("array").next("tiles-large").next("tiles-small").next("chaotic-medium").next("chaotic-small").next("dent").next("french-1").next("french-2").next("jellybean").next("layers").next("mosaic").next("ornate").next("panel").next("road").next("slanted").next("zag").next("circularct").next("weaver").build(b -> b.func_149711_c(2.0f).func_149752_b(10.0f).func_149672_a(SoundType.field_185851_d));
            factory.newBlock(Material.field_151576_e, "bricksextra", provider).setGroup("bricks").setParentFolder("bricks").newVariation("bricks-solid").next("circular").next("tiles-medium").next("pillar").next("twisted").next("prism").build(b -> b.func_149711_c(2.0f).func_149752_b(10.0f).func_149672_a(SoundType.field_185851_d));
        }
    }
    ,
    BRONZE{

        @Override
        void addBlocks(ChiselBlockFactory factory) {
            factory.newBlock(Material.field_151573_f, "blockBronze", provider).setParentFolder("metals/bronze").newVariation("caution").next("crate").next("thermal").next("machine").next("badGreggy").next("bolted").next("scaffold").build(b -> b.func_149672_a(SoundType.field_185851_d).func_149711_c(5.0f));
            CarvingUtils.getChiselRegistry().registerOre("blockBronze", "blockBronze");
        }
    }
    ,
    CARPET{

        @Override
        void addBlocks(ChiselBlockFactory factory) {
            factory.newBlock(Material.field_151580_n, "carpet", provider).newVariation("black").next("red").next("green").next("brown").next("darkblue").next("purple").next("teal").next("grey").next("darkgrey").next("pink").next("lightgreen").next("yellow").next("lightblue").next("lily").next("orange").next("white").build(b -> b.func_149672_a(SoundType.field_185854_g).func_149711_c(0.8f));
        }
    }
    ,
    CLOUD{

        @Override
        void addBlocks(ChiselBlockFactory factory) {
            factory.newBlock(Material.field_151580_n, "cloud", provider).newVariation("cloud").next("large").next("small").next("vertical").next("grid").build(b -> b.func_149672_a(SoundType.field_185854_g).func_149711_c(0.3f));
        }

        @Override
        void addRecipes() {
            GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack((Block)ChiselBlocks.cloud, 32, 0), new Object[]{" S ", "S S", " S ", Character.valueOf('S'), new ItemStack(Blocks.field_150325_L, 1, Short.MAX_VALUE)}));
        }
    }
    ,
    COBALT{

        @Override
        void addBlocks(ChiselBlockFactory factory) {
            factory.newBlock(Material.field_151573_f, "blockCobalt", provider).setParentFolder("metals/cobalt").newVariation("caution").next("crate").next("thermal").next("machine").next("badGreggy").next("bolted").next("scaffold").build(b -> b.func_149672_a(SoundType.field_185852_e).func_149711_c(5.0f));
            CarvingUtils.getChiselRegistry().registerOre("blockCobalt", "blockCobalt");
        }
    }
    ,
    COBBLESTONE{

        @Override
        void addBlocks(ChiselBlockFactory factory) {
            Carving.chisel.addVariation("cobblestone", Blocks.field_150347_e.func_176223_P(), -20);
            CarvingUtils.getChiselRegistry().registerOre("cobblestone", "cobblestone");
            factory.newBlock(Material.field_151576_e, "cobblestone", provider).newVariation("cracked").next("bricks-soft").next("bricks-cracked").next("bricks-triple").next("bricks-encased").next("braid").next("array").next("tiles-large").next("tiles-small").next("chaotic-medium").next("chaotic-small").next("dent").next("french-1").next("french-2").next("jellybean").next("layers").next("mosaic").next("ornate").next("panel").next("road").next("slanted").next("zag").next("circularct").next("weaver").build(b -> b.func_149711_c(2.0f).func_149752_b(10.0f).func_149672_a(SoundType.field_185851_d));
            factory.newBlock(Material.field_151576_e, "cobblestoneextra", provider).setGroup("cobblestone").setParentFolder("cobblestone").newVariation("bricks-solid").next("bricks-small").next("circular").next("tiles-medium").next("pillar").next("twisted").next("prism").next("emboss").next("indent").next("marker").build(b -> b.func_149711_c(2.0f).func_149752_b(10.0f).func_149672_a(SoundType.field_185851_d));
        }
    }
    ,
    COBBLESTONEMOSSY{

        @Override
        void addBlocks(ChiselBlockFactory factory) {
            Carving.chisel.addVariation("cobblestonemossy", Blocks.field_150341_Y.func_176223_P(), -1);
            factory.newBlock(Material.field_151576_e, "cobblestonemossy", provider).newVariation("cracked").next("bricks-soft").next("bricks-cracked").next("bricks-triple").next("bricks-encased").next("braid").next("array").next("tiles-large").next("tiles-small").next("chaotic-medium").next("chaotic-small").next("dent").next("french-1").next("french-2").next("jellybean").next("layers").next("mosaic").next("ornate").next("panel").next("road").next("slanted").next("zag").next("circularct").next("weaver").next("bricks-solid").next("bricks-small").next("circular").next("tiles-medium").next("pillar").next("twisted").next("prism").build(b -> b.func_149711_c(2.0f).func_149752_b(10.0f).func_149672_a(SoundType.field_185851_d));
        }
    }
    ,
    COPPER{

        @Override
        void addBlocks(ChiselBlockFactory factory) {
            factory.newBlock(Material.field_151573_f, "blockCopper", provider).setParentFolder("metals/copper").newVariation("caution").next("crate").next("thermal").next("machine").next("badGreggy").next("bolted").next("scaffold").build(b -> b.func_149672_a(SoundType.field_185852_e).func_149711_c(5.0f));
            CarvingUtils.getChiselRegistry().registerOre("blockCopper", "blockCopper");
        }
    }
    ,
    DIAMOND{

        @Override
        void addBlocks(ChiselBlockFactory factory) {
            Carving.chisel.addVariation("diamond", Blocks.field_150484_ah.func_176223_P(), -20);
            CarvingUtils.getChiselRegistry().registerOre("diamond", "blockDiamond");
            factory.newBlock(Material.field_151573_f, "diamond", provider).newVariation("terrain-diamond-embossed").next("terrain-diamond-gem").next("terrain-diamond-cells").next("terrain-diamond-space").next("terrain-diamond-spaceblack").next("terrain-diamond-simple").next("terrain-diamond-bismuth").next("terrain-diamond-crushed").next("terrain-diamond-four").next("terrain-diamond-fourornate").next("terrain-diamond-zelda").next("terrain-diamond-ornatelayer").build(b -> b.func_149672_a(SoundType.field_185851_d).func_149711_c(5.0f));
        }
    }
    ,
    DIORITE{

        @Override
        void addBlocks(ChiselBlockFactory factory) {
            IBlockState stone = Blocks.field_150348_b.func_176223_P();
            PropertyEnum prop = BlockStone.field_176247_a;
            Carving.chisel.addVariation("diorite", stone.func_177226_a((IProperty)prop, (Comparable)BlockStone.EnumType.DIORITE), -21);
            Carving.chisel.addVariation("diorite", stone.func_177226_a((IProperty)prop, (Comparable)BlockStone.EnumType.DIORITE_SMOOTH), -20);
            CarvingUtils.getChiselRegistry().registerOre("diorite", "stoneDiorite");
            factory.newBlock(Material.field_151576_e, "diorite", provider).newVariation("cracked").next("bricks-soft").next("bricks-cracked").next("bricks-triple").next("bricks-encased").next("braid").next("array").next("tiles-large").next("tiles-small").next("chaotic-medium").next("chaotic-small").next("dent").next("french-1").next("french-2").next("jellybean").next("layers").next("mosaic").next("ornate").next("panel").next("road").next("slanted").next("zag").next("circularct").next("weaver").next("bricks-solid").next("bricks-small").next("circular").next("tiles-medium").next("pillar").next("twisted").next("prism").build(b -> b.func_149711_c(1.5f).func_149752_b(30.0f).func_149672_a(SoundType.field_185851_d));
        }
    }
    ,
    DIRT{

        @Override
        void addBlocks(ChiselBlockFactory factory) {
            Carving.chisel.addVariation("dirt", Blocks.field_150346_d.func_176223_P(), -1);
            factory.newBlock(Material.field_151578_c, "dirt", provider).newVariation("bricks").next("netherbricks").next("bricks3").next("cobble").next("reinforcedCobbleDirt").next("reinforcedDirt").next("happy").next("bricks2").next("bricks+dirt2").next("hor").next("vert").next("layers").next("vertical").next("chunky").next("horizontal").next("plate").build(b -> b.func_149672_a(SoundType.field_185849_b).func_149711_c(0.5f));
        }
    }
    ,
    ELECTRUM{

        @Override
        void addBlocks(ChiselBlockFactory factory) {
            factory.newBlock(Material.field_151573_f, "blockElectrum", provider).setParentFolder("metals/electrum").newVariation("caution").next("crate").next("thermal").next("machine").next("badGreggy").next("bolted").next("scaffold").build(b -> b.func_149672_a(SoundType.field_185852_e).func_149711_c(5.0f));
            CarvingUtils.getChiselRegistry().registerOre("blockElectrum", "blockElectrum");
        }
    }
    ,
    EMERALD{

        @Override
        void addBlocks(ChiselBlockFactory factory) {
            Carving.chisel.addVariation("emerald", Blocks.field_150475_bE.func_176223_P(), -1);
            CarvingUtils.getChiselRegistry().registerOre("emerald", "blockEmerald");
            factory.newBlock(Material.field_151573_f, "emerald", provider).newVariation("panel").next("panelclassic").next("smooth").next("chunk").next("goldborder").next("zelda").next("cell").next("cellbismuth").next("four").next("fourornate").next("ornate").next("masonryEmerald").next("emeraldCircle").next("emeraldPrismatic").build(b -> b.func_149672_a(SoundType.field_185851_d).func_149711_c(5.0f));
        }
    }
    ,
    END_PURPUR{

        @Override
        void addBlocks(ChiselBlockFactory factory) {
            IBlockState purpur_pillar = Blocks.field_185768_cU.func_176223_P();
            PropertyEnum prop = BlockRotatedPillar.field_176298_M;
            Carving.chisel.addVariation("purpur", Blocks.field_185767_cT.func_176223_P(), -5);
            Carving.chisel.addVariation("purpur", purpur_pillar.func_177226_a((IProperty)prop, (Comparable)EnumFacing.Axis.Y), -3);
            factory.newBlock(Material.field_151576_e, "purpur", provider).newVariation("cracked").next("bricks-soft").next("bricks-cracked").next("bricks-triple").next("bricks-encased").next("braid").next("array").next("tiles-large").next("tiles-small").next("chaotic-medium").next("chaotic-small").next("dent").next("french-1").next("french-2").next("jellybean").next("layers").next("mosaic").next("ornate").next("panel").next("road").next("slanted").next("zag").next("circularct").next("weaver").build(b -> b.func_149711_c(1.5f).func_149752_b(10.0f).func_149672_a(SoundType.field_185851_d));
            factory.newBlock(Material.field_151576_e, "purpurextra", provider).setGroup("purpur").setParentFolder("purpur").newVariation("bricks-solid").next("bricks-small").next("circular").next("twisted").next("prism").build(b -> b.func_149711_c(1.5f).func_149752_b(10.0f).func_149672_a(SoundType.field_185851_d));
        }
    }
    ,
    ENDSTONE{

        @Override
        void addBlocks(ChiselBlockFactory factory) {
            Carving.chisel.addVariation("endstone", Blocks.field_150377_bs.func_176223_P(), -21);
            Carving.chisel.addVariation("endstone", Blocks.field_185772_cY.func_176223_P(), -20);
            CarvingUtils.getChiselRegistry().registerOre("endstone", "endstone");
            factory.newBlock(Material.field_151576_e, "endstone", provider).newVariation("cracked").next("bricks-solid").next("bricks-cracked").next("bricks-triple").next("bricks-encased").next("braid").next("array").next("tiles-large").next("tiles-small").next("chaotic-medium").next("chaotic-small").next("dent").next("french-1").next("french-2").next("jellybean").next("layers").next("mosaic").next("ornate").next("panel").next("road").next("slanted").next("zag").next("circularct").next("weaver").build(b -> b.func_149711_c(3.0f).func_149752_b(15.0f).func_149672_a(SoundType.field_185851_d));
            factory.newBlock(Material.field_151576_e, "endstoneextra", provider).setGroup("endstone").setParentFolder("endstone").newVariation("bricks-small").next("circular").next("tiles-medium").next("pillar").next("twisted").next("prism").build(b -> b.func_149711_c(3.0f).func_149752_b(15.0f).func_149672_a(SoundType.field_185851_d));
        }
    }
    ,
    FACTORY{

        @Override
        void addBlocks(ChiselBlockFactory factory) {
            factory.newBlock(Material.field_151573_f, "factory", provider).newVariation("dots").next("rust2").next("rust").next("platex").next("wireframewhite").next("wireframe").next("hazard").next("hazardorange").next("circuit").next("metalbox").next("goldplate").next("goldplating").next("grinder").next("plating").next("rustplates").next("column").next("frameblue").next("iceiceice").next("tilemosaic").next("vent").next("wireframeblue").build();
        }

        @Override
        void addRecipes() {
            GameRegistry.addRecipe((ItemStack)new ItemStack((Block)ChiselBlocks.factory, 32, 0), (Object[])new Object[]{"SXS", "X X", "SXS", Character.valueOf('X'), new ItemStack(Blocks.field_150348_b, 1), Character.valueOf('S'), new ItemStack(Items.field_151042_j, 1)});
        }
    }
    ,
    FUTURA{

        @Override
        void addBlocks(ChiselBlockFactory factory) {
            factory.newBlock(Material.field_151576_e, "futura", provider).newVariation("screenMetallic").next("screenCyan").next("controller").next("wavy").next("controllerPurple").next("uberWavy").build();
        }

        @Override
        void addRecipes() {
            GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack((Block)ChiselBlocks.futura, 8, 0), new Object[]{"SSS", "SGS", "SSS", Character.valueOf('S'), "stone", Character.valueOf('G'), "dustRedstone"}));
        }
    }
    ,
    GLASS{

        @Override
        void addBlocks(ChiselBlockFactory factory) {
            Carving.chisel.addVariation("glass", Blocks.field_150359_w.func_176223_P(), -20);
            CarvingUtils.getChiselRegistry().registerOre("glass", "blockGlassColorless");
            factory.newBlock(Material.field_151592_s, "glass", provider).opaque(false).newVariation("terrain-glassbubble").next("terrain-glass-chinese").next("japanese").next("terrain-glassdungeon").next("terrain-glasslight").next("terrain-glassnoborder").next("terrain-glass-ornatesteel").next("terrain-glass-screen").next("terrain-glassshale").next("terrain-glass-steelframe").next("terrain-glassstone").next("terrain-glassstreak").next("terrain-glass-thickgrid").next("terrain-glass-thingrid").next("a1-glasswindow-ironfencemodern").next("chrono").build(b -> b.setQuantityDropped(0).setCanSilkHarvest(true).func_149672_a(SoundType.field_185853_f).func_149711_c(0.3f));
        }
    }
    ,
    GLASSDYED{

        @Override
        void addBlocks(ChiselBlockFactory factory) {
            IBlockState stainedGlass = Blocks.field_150399_cn.func_176223_P();
            PropertyEnum prop = BlockStainedGlass.field_176547_a;
            for (int c = 0; c < dyeColors.length; ++c) {
                Carving.chisel.addVariation("glassdyed" + dyeColors[c].toLowerCase(), stainedGlass.func_177226_a((IProperty)prop, (Comparable)EnumDyeColor.func_176766_a((int)c)), -1);
                CarvingUtils.getChiselRegistry().registerOre("glassdyed" + dyeColors[c].toLowerCase(), "blockGlass" + dyeColors[c]);
                factory.newBlock(Material.field_151592_s, "glassdyed" + dyeColors[c].toLowerCase(), provider).opaque(false).setParentFolder("glassdyed").newVariation(dyeColors[c].toLowerCase() + "-bubble").next(dyeColors[c].toLowerCase() + "-panel").next(dyeColors[c].toLowerCase() + "-panel-fancy").next(dyeColors[c].toLowerCase() + "-transparent").next(dyeColors[c].toLowerCase() + "-forestry").build(b -> b.setQuantityDropped(0).setCanSilkHarvest(true).func_149672_a(SoundType.field_185853_f).func_149711_c(0.3f));
            }
        }
    }
    ,
    GLOWSTONE{

        @Override
        void addBlocks(ChiselBlockFactory factory) {
            Carving.chisel.addVariation("glowstone", Blocks.field_150426_aN.func_176223_P(), -20);
            CarvingUtils.getChiselRegistry().registerOre("glowstone", "glowstone");
            factory.newBlock(Material.field_151576_e, "glowstone", provider).newVariation("cracked").next("bricks-soft").next("bricks-cracked").next("bricks-triple").next("bricks-encased").next("braid").next("array").next("tiles-large").next("tiles-small").next("chaotic-medium").next("chaotic-small").next("dent").next("french-1").next("french-2").next("jellybean").next("layers").next("mosaic").next("ornate").next("panel").next("road").next("slanted").next("bricks-solid").next("bricks-small").next("circular").next("tiles-medium").next("pillar").next("twisted").next("prism").next("bismuth").next("tiles-large-bismuth").next("tiles-medium-bismuth").next("neon").next("neon-panel").build(b -> b.func_149715_a(1.0f).func_149711_c(0.3f).func_149752_b(1.5f).func_149672_a(SoundType.field_185853_f));
        }
    }
    ,
    GOLD{

        @Override
        void addBlocks(ChiselBlockFactory factory) {
            Carving.chisel.addVariation("blockGold", Blocks.field_150340_R.func_176223_P(), -1);
            CarvingUtils.getChiselRegistry().registerOre("blockGold", "blockGold");
            factory.newBlock(Material.field_151573_f, "blockGold", provider).setParentFolder("metals/gold").newVariation("caution").next("crate").next("thermal").next("machine").next("badGreggy").next("bolted").next("scaffold").build(b -> b.func_149672_a(SoundType.field_185852_e).func_149711_c(3.0f));
            factory.newBlock(Material.field_151573_f, "gold", provider).setGroup("blockGold").newVariation("terrain-gold-largeingot").next("terrain-gold-smallingot").next("terrain-gold-brick").next("terrain-gold-cart").next("terrain-gold-coin-heads").next("terrain-gold-coin-tails").next("terrain-gold-crate-dark").next("terrain-gold-crate-light").next("terrain-gold-plates").next("terrain-gold-rivets").next("terrain-gold-star").next("terrain-gold-space").next("terrain-gold-spaceblack").next("terrain-gold-simple").next("goldEye").build(b -> b.func_149672_a(SoundType.field_185852_e).func_149711_c(3.0f));
        }
    }
    ,
    GRANITE{

        @Override
        void addBlocks(ChiselBlockFactory factory) {
            IBlockState stone = Blocks.field_150348_b.func_176223_P();
            PropertyEnum prop = BlockStone.field_176247_a;
            Carving.chisel.addVariation("granite", stone.func_177226_a((IProperty)prop, (Comparable)BlockStone.EnumType.GRANITE), -21);
            Carving.chisel.addVariation("granite", stone.func_177226_a((IProperty)prop, (Comparable)BlockStone.EnumType.GRANITE_SMOOTH), -20);
            CarvingUtils.getChiselRegistry().registerOre("granite", "stoneGranite");
            factory.newBlock(Material.field_151576_e, "granite", provider).newVariation("cracked").next("bricks-soft").next("bricks-cracked").next("bricks-triple").next("bricks-encased").next("braid").next("array").next("tiles-large").next("tiles-small").next("chaotic-medium").next("chaotic-small").next("dent").next("french-1").next("french-2").next("jellybean").next("layers").next("mosaic").next("ornate").next("panel").next("road").next("slanted").next("zag").next("circularct").next("weaver").next("bricks-solid").next("bricks-small").next("circular").next("tiles-medium").next("pillar").next("twisted").next("prism").build(b -> b.func_149711_c(1.5f).func_149752_b(30.0f).func_149672_a(SoundType.field_185851_d));
        }
    }
    ,
    HARDENED_CLAY{

        @Override
        void addBlocks(ChiselBlockFactory factory) {
            Carving.chisel.addVariation("hardenedclay", Blocks.field_150405_ch.func_176223_P(), -1);
            CarvingUtils.getChiselRegistry().registerOre("hardenedclay", "hardenedClay");
            factory.newBlock(Material.field_151576_e, "hardenedclay", provider).newVariation("cracked").next("bricks-soft").next("bricks-cracked").next("bricks-triple").next("bricks-encased").next("braid").next("array").next("tiles-large").next("tiles-small").next("chaotic-medium").next("chaotic-small").next("dent").next("french-1").next("french-2").next("jellybean").next("layers").next("mosaic").next("ornate").next("panel").next("road").next("slanted").next("zag").next("circularct").next("weaver").build(b -> b.func_149711_c(1.25f).func_149752_b(7.0f).func_149672_a(SoundType.field_185851_d));
            factory.newBlock(Material.field_151576_e, "hardenedclayextra", provider).setGroup("hardenedclay").setParentFolder("hardenedclay").newVariation("bricks-solid").next("bricks-small").next("circular").next("tiles-medium").next("pillar").next("twisted").next("prism").build(b -> b.func_149711_c(1.25f).func_149752_b(7.0f).func_149672_a(SoundType.field_185851_d));
        }
    }
    ,
    ICE{

        @Override
        void addBlocks(ChiselBlockFactory factory) {
            Carving.chisel.addVariation("ice", Blocks.field_150432_aD.func_176223_P(), -1);
        }
    }
    ,
    ICEPILLAR{

        @Override
        void addBlocks(ChiselBlockFactory factory) {
            factory.newBlock(Material.field_151588_w, "icepillar", provider).setGroup("ice").newVariation("plainplain").next("plaingreek").next("greekplain").next("greekgreek").next("convexplain").next("carved").next("ornamental").build(b -> b.func_149672_a(SoundType.field_185853_f).func_149711_c(0.5f));
        }
    }
    ,
    INVAR{

        @Override
        void addBlocks(ChiselBlockFactory factory) {
            factory.newBlock(Material.field_151573_f, "blockInvar", provider).setParentFolder("metals/invar").newVariation("caution").next("crate").next("thermal").next("machine").next("badGreggy").next("bolted").next("scaffold").build(b -> b.func_149672_a(SoundType.field_185852_e).func_149711_c(5.0f));
        }
    }
    ,
    IRON{

        @Override
        void addBlocks(ChiselBlockFactory factory) {
            Carving.chisel.addVariation("blockIron", Blocks.field_150339_S.func_176223_P(), -20);
            CarvingUtils.getChiselRegistry().registerOre("blockIron", "blockIron");
            factory.newBlock(Material.field_151573_f, "blockIron", provider).setParentFolder("metals/iron").newVariation("caution").next("crate").next("thermal").next("machine").next("badGreggy").next("bolted").next("scaffold").build(b -> b.func_149672_a(SoundType.field_185852_e).func_149711_c(5.0f));
            factory.newBlock(Material.field_151573_f, "iron", provider).setGroup("blockIron").newVariation("terrain-iron-largeingot").next("terrain-iron-smallingot").next("terrain-iron-gears").next("terrain-iron-brick").next("terrain-iron-plates").next("terrain-iron-rivets").next("terrain-iron-coin-heads").next("terrain-iron-coin-tails").next("terrain-iron-crate-dark").next("terrain-iron-crate-light").next("terrain-iron-moon").next("terrain-iron-space").next("terrain-iron-spaceblack").next("terrain-iron-vents").next("terrain-iron-simple").build(b -> b.func_149672_a(SoundType.field_185852_e).func_149711_c(5.0f));
        }
    }
    ,
    IRONPANE{

        @Override
        void addBlocks(ChiselBlockFactory factory) {
            factory.newBlock(Material.field_151573_f, "ironpane", provider).newVariation("fenceIron").next("barbedwire").next("cage").next("fenceIronTop").next("terrain-glass-thickgrid").next("terrain-glass-thingrid").next("terrain-glass-ornatesteel").next("bars").next("spikes").next("a1-ironbars-ironclassicnew").next("a1-ironbars-ironfence").next("a1-ironbars-ironfencemodern").build(b -> b.func_149672_a(SoundType.field_185852_e).func_149711_c(5.0f));
        }
    }
    ,
    LABORATORY{

        @Override
        void addBlocks(ChiselBlockFactory factory) {
            factory.newBlock(Material.field_151576_e, "laboratory", provider).newVariation("wallpanel").next("dottedpanel").next("largewall").next("roundel").next("wallvents").next("largetile").next("smalltile").next("floortile").next("checkertile").next("clearscreen").next("fuzzscreen").next("largesteel").next("smallsteel").next("directionright").next("directionleft").next("infocon").build();
        }

        @Override
        void addRecipes() {
            GameRegistry.addRecipe((ItemStack)new ItemStack((Block)ChiselBlocks.laboratory, 8), (Object[])new Object[]{"***", "*X*", "***", Character.valueOf('*'), new ItemStack(Blocks.field_150348_b, 1), Character.valueOf('X'), new ItemStack(Items.field_151128_bU, 1)});
        }
    }
    ,
    LAPIS{

        @Override
        void addBlocks(ChiselBlockFactory factory) {
            Carving.chisel.addVariation("lapis", Blocks.field_150368_y.func_176223_P(), -1);
            CarvingUtils.getChiselRegistry().registerOre("lapis", "blockLapis");
            factory.newBlock(Material.field_151576_e, "lapis", provider).newVariation("terrain-lapisblock-chunky").next("terrain-lapisblock-panel").next("terrain-lapisblock-zelda").next("terrain-lapisornate").next("terrain-lapistile").next("a1-blocklapis-panel").next("a1-blocklapis-smooth").next("a1-blocklapis-ornatelayer").next("masonryLapis").build(b -> b.func_149711_c(3.0f).func_149752_b(5.0f).func_149672_a(SoundType.field_185851_d));
        }
    }
    ,
    LAVASTONE{

        @Override
        void addBlocks(ChiselBlockFactory factory) {
            factory.newBlock(Material.field_151576_e, "lavastone", provider).newVariation("cracked").next("bricks-soft").next("bricks-cracked").next("bricks-triple").next("bricks-encased").next("braid").next("array").next("tiles-large").next("tiles-small").next("chaotic-medium").next("chaotic-small").next("dent").next("french-1").next("french-2").next("jellybean").next("layers").next("mosaic").next("ornate").next("panel").next("road").next("slanted").next("zag").next("circularct").next("weaver").next("bricks-solid").next("bricks-small").next("circular").next("tiles-medium").next("pillar").next("twisted").next("prism").build(b -> b.func_149711_c(4.0f).func_149752_b(50.0f).func_149672_a(SoundType.field_185851_d));
        }

        @Override
        void addRecipes() {
            GameRegistry.addRecipe((ItemStack)new ItemStack((Block)ChiselBlocks.lavastone, 8, 0), (Object[])new Object[]{"***", "*X*", "***", Character.valueOf('*'), new ItemStack(Blocks.field_150348_b, 1), Character.valueOf('X'), new ItemStack(Items.field_151129_at, 1)});
        }
    }
    ,
    LEAD{

        @Override
        void addBlocks(ChiselBlockFactory factory) {
            factory.newBlock(Material.field_151573_f, "blockLead", provider).setParentFolder("metals/lead").newVariation("caution").next("crate").next("thermal").next("machine").next("badGreggy").next("bolted").next("scaffold").build(b -> b.func_149672_a(SoundType.field_185852_e).func_149711_c(5.0f));
            CarvingUtils.getChiselRegistry().registerOre("blockLead", "blockLead");
        }
    }
    ,
    LIMESTONE{

        @Override
        void addBlocks(ChiselBlockFactory factory) {
            factory.newBlock(Material.field_151576_e, "limestone", provider).newVariation("cracked").next("bricks-soft").next("bricks-cracked").next("bricks-triple").next("bricks-encased").next("braid").next("array").next("tiles-large").next("tiles-small").next("chaotic-medium").next("chaotic-small").next("dent").next("french-1").next("french-2").next("jellybean").next("layers").next("mosaic").next("ornate").next("panel").next("road").next("slanted").next("zag").next("circularct").next("weaver").build(b -> b.func_149711_c(1.5f).func_149752_b(10.0f).func_149672_a(SoundType.field_185851_d));
            factory.newBlock(Material.field_151576_e, "limestoneextra", provider).setGroup("limestone").setParentFolder("limestone").newVariation("bricks-solid").next("bricks-small").next("circular").next("tiles-medium").next("pillar").next("twisted").next("prism").next("raw").setOrder(-100).build(b -> b.func_149711_c(1.5f).func_149752_b(10.0f).func_149672_a(SoundType.field_185851_d));
            CarvingUtils.getChiselRegistry().registerOre("limestone", "stoneLimestone");
        }

        @Override
        void addRecipes() {
            GenerationHandler.INSTANCE.addGeneration(ChiselBlocks.limestoneextra.func_176223_P().func_177226_a((IProperty)ChiselBlocks.limestoneextra.getMetaProp(), (Comparable)Integer.valueOf(7)), new GenerationHandler.WorldGenInfo(Configurations.limestoneAmount, 32, 64, 1.0, (Predicate<IBlockState>)BlockMatcher.func_177642_a((Block)Blocks.field_150348_b)));
        }
    }
    ,
    MARBLE{

        @Override
        void addBlocks(ChiselBlockFactory factory) {
            factory.newBlock(Material.field_151576_e, "marble", provider).newVariation("cracked").next("bricks-soft").next("bricks-cracked").next("bricks-triple").next("bricks-encased").next("braid").next("array").next("tiles-large").next("tiles-small").next("chaotic-medium").next("chaotic-small").next("dent").next("french-1").next("french-2").next("jellybean").next("layers").next("mosaic").next("ornate").next("panel").next("road").next("slanted").next("zag").next("circularct").next("weaver").build(b -> b.func_149711_c(1.5f).func_149752_b(10.0f).func_149672_a(SoundType.field_185851_d));
            factory.newBlock(Material.field_151576_e, "marbleextra", provider).setGroup("marble").setParentFolder("marble").newVariation("bricks-solid").next("bricks-small").next("circular").next("tiles-medium").next("pillar").next("twisted").next("prism").setOrder(-100).next("raw").build(b -> b.func_149711_c(1.5f).func_149752_b(10.0f).func_149672_a(SoundType.field_185851_d));
            CarvingUtils.getChiselRegistry().registerOre("marble", "stoneMarble");
        }

        @Override
        void addRecipes() {
            GenerationHandler.INSTANCE.addGeneration(ChiselBlocks.marbleextra.func_176223_P().func_177226_a((IProperty)ChiselBlocks.marbleextra.getMetaProp(), (Comparable)Integer.valueOf(7)), new GenerationHandler.WorldGenInfo(Configurations.marbleAmount, 32, 64, 1.0, (Predicate<IBlockState>)BlockMatcher.func_177642_a((Block)Blocks.field_150348_b)));
        }
    }
    ,
    MARBLEPILLAR{

        @Override
        void addBlocks(ChiselBlockFactory factory) {
            if (Configurations.oldPillars) {
                factory.newBlock(Material.field_151576_e, "marblepillarold", provider).setGroup("marble").newVariation("column").next("capstone").next("base").next("small").next("pillar-carved").next("a1-stoneornamental-marblegreek").next("a1-stonepillar-greek").next("a1-stonepillar-plain").next("a1-stonepillar-greektopplain").next("a1-stonepillar-plaintopplain").next("a1-stonepillar-greekbottomplain").next("a1-stonepillar-plainbottomplain").next("a1-stonepillar-greektopgreek").next("a1-stonepillar-plaintopgreek").next("a1-stonepillar-greekbottomgreek").next("a1-stonepillar-plainbottomgreek").build(b -> b.func_149711_c(1.5f).func_149752_b(10.0f).func_149672_a(SoundType.field_185851_d));
            } else {
                factory.newBlock(Material.field_151576_e, "marblepillar", provider).setGroup("marble").newVariation("pillar").next("default").next("simple").next("convex").next("rough").next("greekdecor").next("greekgreek").next("greekplain").next("plaindecor").next("plaingreek").next("plainplain").next("widedecor").next("widegreek").next("wideplain").next("carved").next("ornamental").build(b -> b.func_149711_c(1.5f).func_149752_b(10.0f).func_149672_a(SoundType.field_185851_d));
            }
        }
    }
    ,
    NETHERBRICK{

        @Override
        void addBlocks(ChiselBlockFactory factory) {
            Carving.chisel.addVariation("netherbrick", Blocks.field_150385_bj.func_176223_P(), -1);
            factory.newBlock(Material.field_151576_e, "netherbrick", provider).newVariation("a1-netherbrick-brinstar").next("a1-netherbrick-classicspatter").next("a1-netherbrick-guts").next("a1-netherbrick-gutsdark").next("a1-netherbrick-gutssmall").next("a1-netherbrick-lavabrinstar").next("a1-netherbrick-lavabrown").next("a1-netherbrick-lavaobsidian").next("a1-netherbrick-lavastonedark").next("a1-netherbrick-meat").next("a1-netherbrick-meatred").next("a1-netherbrick-meatredsmall").next("a1-netherbrick-meatsmall").next("a1-netherbrick-red").next("a1-netherbrick-redsmall").next("netherFancyBricks").build(b -> b.func_149711_c(2.0f).func_149752_b(10.0f).func_149672_a(SoundType.field_185851_d));
        }
    }
    ,
    NETHERRACK{

        @Override
        void addBlocks(ChiselBlockFactory factory) {
            Carving.chisel.addVariation("netherrack", Blocks.field_150424_aL.func_176223_P(), -20);
            CarvingUtils.getChiselRegistry().registerOre("netherrack", "netherrack");
            factory.newBlock(Material.field_151576_e, "netherrack", provider).newVariation("a1-netherrack-bloodgravel").next("a1-netherrack-bloodrock").next("a1-netherrack-bloodrockgrey").next("a1-netherrack-brinstar").next("a1-netherrack-brinstarshale").next("a1-netherrack-classic").next("a1-netherrack-classicspatter").next("a1-netherrack-guts").next("a1-netherrack-gutsdark").next("a1-netherrack-meat").next("a1-netherrack-meatred").next("a1-netherrack-meatrock").next("a1-netherrack-red").next("a1-netherrack-wells").build(b -> b.func_149711_c(0.4f).func_149672_a(SoundType.field_185851_d));
        }
    }
    ,
    NICKEL{

        @Override
        void addBlocks(ChiselBlockFactory factory) {
            factory.newBlock(Material.field_151576_e, "blockNickel", provider).setParentFolder("metals/nickel").newVariation("caution").next("crate").next("thermal").next("machine").next("badGreggy").next("bolted").next("scaffold").build(b -> b.func_149672_a(SoundType.field_185852_e).func_149711_c(5.0f));
            CarvingUtils.getChiselRegistry().registerOre("blockNickel", "blockNickel");
        }
    }
    ,
    OBSIDIAN{

        @Override
        void addBlocks(ChiselBlockFactory factory) {
            Carving.chisel.addVariation("obsidian", Blocks.field_150343_Z.func_176223_P(), -1);
            CarvingUtils.getChiselRegistry().registerOre("obsidian", "obsidian");
            factory.newBlock(Material.field_151576_e, "obsidian", provider).newVariation("pillar").next("pillar-quartz").next("chiseled").next("panel-shiny").next("panel").next("chunks").next("growth").next("crystal").next("map-a").next("map-b").next("panel-light").next("blocks").next("tiles").next("greek").next("crate").build(b -> b.func_149711_c(50.0f).func_149752_b(2000.0f).func_149672_a(SoundType.field_185851_d));
        }
    }
    ,
    PAPER{

        @Override
        void addBlocks(ChiselBlockFactory factory) {
            factory.newBlock(Material.field_151585_k, "paper", provider).newVariation("box").next("throughMiddle").next("cross").next("sixSections").next("vertical").next("horizontal").next("floral").next("plain").next("door").build(b -> b.func_149672_a(SoundType.field_185850_c).func_149711_c(1.5f));
        }

        @Override
        void addRecipes() {
            GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack((Block)ChiselBlocks.paper, 32), new Object[]{"ppp", "psp", "ppp", Character.valueOf('p'), Items.field_151121_aF, Character.valueOf('s'), "stickWood"}));
        }
    }
    ,
    PLANKS{

        @Override
        void addBlocks(ChiselBlockFactory factory) {
            IBlockState planks = Blocks.field_150344_f.func_176223_P();
            PropertyEnum prop = BlockPlanks.field_176383_a;
            for (int c = 0; c < this.plank_names.length; ++c) {
                Carving.chisel.addVariation("planks-" + this.plank_names[c], planks.func_177226_a((IProperty)prop, (Comparable)BlockPlanks.EnumType.func_176837_a((int)c)), -1);
                factory.newBlock(Material.field_151575_d, "planks-" + this.plank_names[c], provider).newVariation("clean").next("short").next("fancy").next("panel-nails").next("double").next("crate").next("crate-fancy").next("large").next("vertical").next("vertical-uneven").next("parquet").next("blinds").next("crateex").next("chaotic-hor").next("chaotic").build(b -> b.func_149711_c(2.0f).func_149752_b(5.0f).func_149672_a(SoundType.field_185848_a));
            }
        }
    }
    ,
    PLATINUM{

        @Override
        void addBlocks(ChiselBlockFactory factory) {
            factory.newBlock(Material.field_151573_f, "blockPlatinum", provider).setParentFolder("metals/platinum").newVariation("caution").next("crate").next("thermal").next("machine").next("badGreggy").next("bolted").next("scaffold").build(b -> b.func_149672_a(SoundType.field_185852_e).func_149711_c(5.0f));
            CarvingUtils.getChiselRegistry().registerOre("blockPlatinum", "blockPlatinum");
        }
    }
    ,
    PRISMARINE{

        @Override
        void addBlocks(ChiselBlockFactory factory) {
            IBlockState prismarine = Blocks.field_180397_cI.func_176223_P();
            PropertyEnum prop = BlockPrismarine.field_176332_a;
            Carving.chisel.addVariation("prismarine", prismarine.func_177226_a((IProperty)prop, (Comparable)BlockPrismarine.EnumType.ROUGH), -3);
            Carving.chisel.addVariation("prismarine", prismarine.func_177226_a((IProperty)prop, (Comparable)BlockPrismarine.EnumType.BRICKS), -2);
            Carving.chisel.addVariation("prismarine", prismarine.func_177226_a((IProperty)prop, (Comparable)BlockPrismarine.EnumType.DARK), -1);
            CarvingUtils.getChiselRegistry().registerOre("prismarine", "prismarine");
            factory.newBlock(Material.field_151576_e, "prismarine", provider).newVariation("cracked").next("bricks-soft").next("bricks-cracked").next("bricks-triple").next("bricks-encased").next("braid").next("array").next("tiles-large").next("tiles-small").next("chaotic-medium").next("chaotic-small").next("dent").next("french-1").next("french-2").next("jellybean").next("layers").next("mosaic").next("ornate").next("panel").next("road").next("slanted").next("zag").next("circularct").next("weaver").build(b -> b.func_149711_c(1.5f).func_149752_b(10.0f).func_149672_a(SoundType.field_185851_d));
            factory.newBlock(Material.field_151576_e, "prismarineextra", provider).setGroup("prismarine").setParentFolder("prismarine").newVariation("bricks-solid").next("bricks-small").next("circular").next("tiles-medium").next("pillar").next("twisted").build(b -> b.func_149711_c(1.5f).func_149752_b(10.0f).func_149672_a(SoundType.field_185851_d));
        }
    }
    ,
    QUARTZ{

        @Override
        void addBlocks(ChiselBlockFactory factory) {
            IBlockState quartzBlock = Blocks.field_150371_ca.func_176223_P();
            PropertyEnum prop = BlockQuartz.field_176335_a;
            Carving.chisel.addVariation("quartz", quartzBlock.func_177226_a((IProperty)prop, (Comparable)BlockQuartz.EnumType.DEFAULT), -25);
            Carving.chisel.addVariation("quartz", quartzBlock.func_177226_a((IProperty)prop, (Comparable)BlockQuartz.EnumType.CHISELED), -24);
            Carving.chisel.addVariation("quartz", quartzBlock.func_177226_a((IProperty)prop, (Comparable)BlockQuartz.EnumType.LINES_Y), -22);
            CarvingUtils.getChiselRegistry().registerOre("quartz", "blockQuartz");
            factory.newBlock(Material.field_151576_e, "quartz", provider).newVariation("cracked").next("bricks-soft").next("bricks-cracked").next("bricks-triple").next("bricks-encased").next("braid").next("array").next("tiles-large").next("tiles-small").next("chaotic-medium").next("chaotic-small").next("dent").next("french-1").next("french-2").next("jellybean").next("layers").next("mosaic").next("ornate").next("panel").next("road").next("slanted").next("zag").next("circularct").next("weaver").next("bricks-solid").next("bricks-small").next("circular").next("tiles-medium").next("pillar").next("prism").build(b -> b.func_149711_c(0.8f).func_149752_b(4.0f).func_149672_a(SoundType.field_185851_d));
        }
    }
    ,
    REDSTONE{

        @Override
        void addBlocks(ChiselBlockFactory factory) {
            Carving.chisel.addVariation("redstone", Blocks.field_150451_bX.func_176223_P(), -20);
            CarvingUtils.getChiselRegistry().registerOre("redstone", "blockRedstone");
            factory.newBlock(Material.field_151576_e, "redstone", provider).newVariation("cracked").next("bricks-soft").next("bricks-cracked").next("bricks-triple").next("bricks-encased").next("braid").next("array").next("tiles-large").next("tiles-small").next("chaotic-medium").next("chaotic-small").next("dent").next("french-1").next("french-2").next("jellybean").next("layers").next("mosaic").next("ornate").next("panel").next("road").next("slanted").next("bricks-solid").next("bricks-small").next("circular").next("tiles-medium").next("pillar").next("twisted").next("prism").build(b -> b.setRedstoneLevel(15).func_149711_c(5.0f).func_149752_b(10.0f).func_149672_a(SoundType.field_185852_e));
        }
    }
    ,
    SANDSTONE{

        @Override
        void addBlocks(ChiselBlockFactory factory) {
            IBlockState ss = Blocks.field_150322_A.func_176223_P();
            PropertyEnum prop = BlockSandStone.field_176297_a;
            Carving.chisel.addVariation("sandstoneyellow", ss.func_177226_a((IProperty)prop, (Comparable)BlockSandStone.EnumType.DEFAULT), -3);
            Carving.chisel.addVariation("sandstoneyellow", ss.func_177226_a((IProperty)prop, (Comparable)BlockSandStone.EnumType.SMOOTH), -2);
            Carving.chisel.addVariation("sandstoneyellow", ss.func_177226_a((IProperty)prop, (Comparable)BlockSandStone.EnumType.CHISELED), -1);
            factory.newBlock(Material.field_151576_e, "sandstoneyellow", provider).newVariation("cracked").next("bricks-soft").next("bricks-cracked").next("bricks-triple").next("bricks-encased").next("braid").next("array").next("tiles-large").next("tiles-small").next("chaotic-medium").next("chaotic-small").next("dent").next("french-1").next("french-2").next("jellybean").next("layers").next("mosaic").next("ornate").next("panel").next("road").next("slanted").next("zag").next("circularct").next("weaver").build(b -> b.func_149672_a(SoundType.field_185851_d).func_149711_c(0.8f));
            factory.newBlock(Material.field_151576_e, "sandstoneyellowextra", provider).setGroup("sandstoneyellow").setParentFolder("sandstoneyellow").newVariation("bricks-solid").next("bricks-small").next("circular").next("tiles-medium").next("pillar").next("twisted").next("prism").build(b -> b.func_149672_a(SoundType.field_185851_d).func_149711_c(0.8f));
        }
    }
    ,
    SANDSTONE_RED{

        @Override
        void addBlocks(ChiselBlockFactory factory) {
            IBlockState ss = Blocks.field_180395_cM.func_176223_P();
            PropertyEnum prop = BlockRedSandstone.field_176336_a;
            Carving.chisel.addVariation("sandstonered", ss.func_177226_a((IProperty)prop, (Comparable)BlockRedSandstone.EnumType.DEFAULT), -3);
            Carving.chisel.addVariation("sandstonered", ss.func_177226_a((IProperty)prop, (Comparable)BlockRedSandstone.EnumType.SMOOTH), -2);
            Carving.chisel.addVariation("sandstonered", ss.func_177226_a((IProperty)prop, (Comparable)BlockRedSandstone.EnumType.CHISELED), -1);
            factory.newBlock(Material.field_151576_e, "sandstonered", provider).newVariation("cracked").next("bricks-soft").next("bricks-cracked").next("bricks-triple").next("bricks-encased").next("braid").next("array").next("tiles-large").next("tiles-small").next("chaotic-medium").next("chaotic-small").next("dent").next("french-1").next("french-2").next("jellybean").next("layers").next("mosaic").next("ornate").next("panel").next("road").next("slanted").next("zag").next("circularct").next("weaver").build(b -> b.func_149672_a(SoundType.field_185851_d).func_149711_c(0.8f));
            factory.newBlock(Material.field_151576_e, "sandstoneredextra", provider).setGroup("sandstonered").setParentFolder("sandstonered").newVariation("bricks-solid").next("bricks-small").next("circular").next("tiles-medium").next("pillar").next("twisted").next("prism").build(b -> b.func_149672_a(SoundType.field_185851_d).func_149711_c(0.8f));
        }
    }
    ,
    SANDSTONE_SCRIBBLES{

        @Override
        void addBlocks(ChiselBlockFactory factory) {
            factory.newBlock(Material.field_151576_e, "sandstone-scribbles", provider).setGroup("sandstone").newVariation("scribbles-0").next("scribbles-1").next("scribbles-2").next("scribbles-3").next("scribbles-4").next("scribbles-5").next("scribbles-6").next("scribbles-7").next("scribbles-8").next("scribbles-9").next("scribbles-10").next("scribbles-11").next("scribbles-12").next("scribbles-13").next("scribbles-14").next("scribbles-15").build(b -> b.func_149672_a(SoundType.field_185851_d).func_149711_c(0.8f));
        }
    }
    ,
    SILVER{

        @Override
        void addBlocks(ChiselBlockFactory factory) {
            factory.newBlock(Material.field_151576_e, "blockSilver", provider).setParentFolder("metals/silver").newVariation("caution").next("crate").next("thermal").next("machine").next("badGreggy").next("bolted").next("scaffold").build();
            CarvingUtils.getChiselRegistry().registerOre("blockSilver", "blockSilver");
        }
    }
    ,
    STEEL{

        @Override
        void addBlocks(ChiselBlockFactory factory) {
            factory.newBlock(Material.field_151576_e, "blockSteel", provider).setParentFolder("metals/steel").newVariation("caution").next("crate").next("thermal").next("machine").next("badGreggy").next("bolted").next("scaffold").build();
            CarvingUtils.getChiselRegistry().registerOre("blockSteel", "blockSteel");
        }
    }
    ,
    STONEBRICK{

        @Override
        void addBlocks(ChiselBlockFactory factory) {
            IBlockState stoneBricks = Blocks.field_150417_aV.func_176223_P();
            PropertyEnum prop = BlockStoneBrick.field_176249_a;
            Carving.chisel.addVariation("stonebrick", stoneBricks.func_177226_a((IProperty)prop, (Comparable)BlockStoneBrick.EnumType.DEFAULT), -26);
            Carving.chisel.addVariation("stonebrick", stoneBricks.func_177226_a((IProperty)prop, (Comparable)BlockStoneBrick.EnumType.MOSSY), -25);
            Carving.chisel.addVariation("stonebrick", stoneBricks.func_177226_a((IProperty)prop, (Comparable)BlockStoneBrick.EnumType.CRACKED), -24);
            Carving.chisel.addVariation("stonebrick", stoneBricks.func_177226_a((IProperty)prop, (Comparable)BlockStoneBrick.EnumType.CHISELED), -23);
            Carving.chisel.addVariation("stonebrick", Blocks.field_150348_b.func_176223_P(), -22);
            CarvingUtils.getChiselRegistry().registerOre("stonebrick", "stone");
            factory.newBlock(Material.field_151576_e, "stonebrick", provider).setParentFolder("stone").newVariation("cracked").next("bricks-soft").next("bricks-cracked").next("bricks-triple").next("bricks-encased").next("braid").next("array").next("tiles-large").next("tiles-small").next("chaotic-medium").next("chaotic-small").next("dent").next("french-1").next("french-2").next("jellybean").next("layers").next("mosaic").next("ornate").next("panel").next("road").next("slanted").next("zag").next("circularct").next("weaver").build(b -> b.func_149711_c(1.5f).func_149752_b(10.0f).func_149672_a(SoundType.field_185851_d));
            factory.newBlock(Material.field_151576_e, "stonebrickextra", provider).setGroup("stonebrick").setParentFolder("stone").newVariation("bricks-small").next("tiles-medium").next("pillar").next("twisted").next("prism").next("largeornate").next("poison").next("sunken").build(b -> b.func_149711_c(1.5f).func_149752_b(10.0f).func_149672_a(SoundType.field_185851_d));
        }
    }
    ,
    TECHNICAL{

        @Override
        void addBlocks(ChiselBlockFactory factory) {
            factory.newBlock(Material.field_151573_f, "technical", provider).setGroup("factory").newVariation("scaffold").next("cautiontape").next("industrialrelic").next("pipesLarge").next("fanFast").next("pipesSmall").next("fanStill").next("vent").next("ventGlowing").next("insulationv2").next("spinningStuffAnim").next("cables").next("rustyBoltedPlates").next("grate").next("malfunctionFan").next("grateRusty").next("scaffoldTransparent").opaque(false).next("fanFastTransparent").opaque(false).next("fanStillTransparent").opaque(false).next("massiveFan").next("massiveHexPlating").build();
            factory.newBlock(Material.field_151573_f, "technicalNew", provider).setGroup("factory").setParentFolder("technical/new").newVariation("weatheredGreenPanels").next("weatheredOrangePanels").next("Sturdy").next("MegaCell").next("ExhaustPlating").next("MakeshiftPanels").next("engineering").next("scaffoldLarge").next("Piping").build();
        }
    }
    ,
    TEMPLE{

        @Override
        void addBlocks(ChiselBlockFactory factory) {
            factory.newBlock(Material.field_151576_e, "temple", provider).newVariation("cobble").next("ornate").next("plate").next("plate-cracked").next("bricks").next("bricks-large").next("bricks-weared").next("bricks-disarray").next("column").next("stand").next("tiles").next("smalltiles").next("tiles-light").next("smalltiles-light").next("stand-creeper").next("stand-mosaic").build(b -> b.func_149711_c(1.5f).func_149752_b(10.0f).func_149672_a(SoundType.field_185851_d));
            factory.newBlock(Material.field_151576_e, "templemossy", provider).setGroup("temple").newVariation("cobble").next("ornate").next("plate").next("plate-cracked").next("bricks").next("bricks-large").next("bricks-weared").next("bricks-disarray").next("column").next("stand").next("tiles").next("smalltiles").next("tiles-light").next("smalltiles-light").next("stand-creeper").next("stand-mosaic").build(b -> b.func_149711_c(1.5f).func_149752_b(10.0f).func_149672_a(SoundType.field_185851_d));
        }

        @Override
        void addRecipes() {
            GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack((Block)ChiselBlocks.temple, 8), new Object[]{"***", "*X*", "***", Character.valueOf('*'), new ItemStack(Blocks.field_150348_b, 1), Character.valueOf('X'), new ItemStack(Items.field_151100_aR, 1, 6)}));
        }
    }
    ,
    TIN{

        @Override
        void addBlocks(ChiselBlockFactory factory) {
            factory.newBlock(Material.field_151576_e, "blockTin", provider).setParentFolder("metals/tin").newVariation("caution").next("crate").next("thermal").next("machine").next("badGreggy").next("bolted").next("scaffold").build();
            CarvingUtils.getChiselRegistry().registerOre("blockTin", "blockTin");
        }
    }
    ,
    TYRIAN{

        @Override
        void addBlocks(ChiselBlockFactory factory) {
            factory.newBlock(Material.field_151573_f, "tyrian", provider).newVariation("shining").next("tyrian").next("chaotic").next("softplate").next("rust").next("elaborate").next("routes").next("platform").next("platetiles").next("diagonal").next("dent").next("blueplating").next("black").next("black2").next("opening").next("plate").build();
        }

        @Override
        void addRecipes() {
            GameRegistry.addRecipe((ItemStack)new ItemStack((Block)ChiselBlocks.tyrian, 32, 0), (Object[])new Object[]{"SXS", "X X", "SXS", Character.valueOf('S'), new ItemStack(Blocks.field_150348_b, 1), Character.valueOf('X'), new ItemStack(Items.field_151042_j, 1)});
        }
    }
    ,
    URANIUM{

        @Override
        void addBlocks(ChiselBlockFactory factory) {
            factory.newBlock(Material.field_151576_e, "blockUranium", provider).setParentFolder("metals/uranium").newVariation("caution").next("crate").next("thermal").next("machine").next("badGreggy").next("bolted").next("scaffold").build();
            CarvingUtils.getChiselRegistry().registerOre("blockUranium", "blockUranium");
        }
    }
    ,
    VALENTINES{

        @Override
        void addBlocks(ChiselBlockFactory factory) {
            factory.newBlock(Material.field_151576_e, "valentines", provider).newVariation("1").next("2").next("3").next("4").next("5").next("6").next("7").next("8").next("9").next("companion").build(b -> b.func_149711_c(1.5f).func_149752_b(20.0f).func_149672_a(SoundType.field_185851_d));
        }

        @Override
        void addRecipes() {
            GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack((Block)ChiselBlocks.valentines, 4), new Object[]{"***", "*X*", "***", Character.valueOf('*'), "stone", Character.valueOf('X'), new ItemStack(Items.field_151100_aR, 1, 9)}));
            GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack((Block)ChiselBlocks.valentines, 32, 9), new Object[]{"***", "*X*", "***", Character.valueOf('*'), "stone", Character.valueOf('X'), new ItemStack(Items.field_151144_bL, 1, Short.MAX_VALUE)}));
        }
    }
    ,
    VOIDSTONE{

        @Override
        void addBlocks(ChiselBlockFactory factory) {
            factory.newBlock(Material.field_151576_e, "voidstone", provider).newVariation("raw").next("quarters").next("smooth").next("skulls").next("rune").next("metalborder").next("eye").next("bevel").build();
            factory.newBlock(Material.field_151576_e, "energizedVoidstone", provider).setGroup("voidstone").setParentFolder("voidstone/animated").newVariation("raw").next("quarters").next("smooth").next("skulls").next("rune").next("metalborder").next("eye").next("bevel").build();
            factory.newBlock(Material.field_151576_e, "voidstoneRunic", provider).setParentFolder("voidstone/runes").setGroup("voidstone").newVariation("black").next("red").next("green").next("brown").next("blue").next("purple").next("cyan").next("lightgray").next("gray").next("pink").next("lime").next("yellow").next("lightblue").next("magenta").next("orange").build();
        }

        @Override
        void addRecipes() {
            GameRegistry.addRecipe((ItemStack)new ItemStack((Block)ChiselBlocks.voidstone, 16, 0), (Object[])new Object[]{" E ", "OOO", " E ", Character.valueOf('E'), new ItemStack(Items.field_151061_bv), Character.valueOf('O'), new ItemStack(Blocks.field_150343_Z)});
            GameRegistry.addRecipe((ItemStack)new ItemStack((Block)ChiselBlocks.voidstone, 48, 0), (Object[])new Object[]{" P ", "PEP", " P ", Character.valueOf('E'), new ItemStack(Items.field_151079_bi), Character.valueOf('P'), new ItemStack(Blocks.field_185767_cT)});
        }
    }
    ,
    WATERSTONE{

        @Override
        void addBlocks(ChiselBlockFactory factory) {
            factory.newBlock(Material.field_151576_e, "waterstone", provider).opaque(false).newVariation("cracked").next("bricks-soft").next("bricks-cracked").next("bricks-triple").next("bricks-encased").next("braid").next("array").next("tiles-large").next("tiles-small").next("chaotic-medium").next("chaotic-small").next("dent").next("french-1").next("french-2").next("jellybean").next("layers").next("mosaic").next("ornate").next("panel").next("road").next("slanted").next("zag").next("circularct").next("weaver").next("bricks-solid").next("bricks-small").next("circular").next("tiles-medium").next("pillar").next("twisted").next("prism").build(b -> b.func_149711_c(4.0f).func_149752_b(50.0f).func_149672_a(SoundType.field_185851_d));
        }

        @Override
        void addRecipes() {
            GameRegistry.addRecipe((ItemStack)new ItemStack((Block)ChiselBlocks.waterstone, 8, 0), (Object[])new Object[]{"***", "*X*", "***", Character.valueOf('*'), new ItemStack(Blocks.field_150348_b, 1), Character.valueOf('X'), new ItemStack(Items.field_151131_as, 1)});
        }
    };

    private static final String[] dyeColors;
    private static final String[] dyeOres;
    public final String[] plank_names = new String[]{"oak", "spruce", "birch", "jungle", "acacia", "dark-oak"};
    @Nonnull
    private static final BlockCreator<BlockCarvable> creator;
    @Nonnull
    private static final ChiselBlockProvider<BlockCarvable> provider;
    private Features parent;
    private String requiredMod;

    static void init() {
        Chisel.logger.info("Starting init...");
        Features.loadRecipes();
        Chisel.logger.info("Init finished.");
    }

    private static void loadBlocks() {
        Chisel.logger.info("Loading blocks...");
        int num = 0;
        ChiselBlockFactory factory = ChiselBlockFactory.newFactory("chisel");
        for (Features f : Features.values()) {
            if (f.enabled()) {
                f.addBlocks(factory);
                ++num;
                continue;
            }
            Features.logDisabled(f);
        }
        Chisel.logger.info(num + " Feature's blocks loaded.");
        Chisel.logger.info("Loading Tile Entities...");
        Chisel.proxy.registerTileEntities();
        Chisel.logger.info("Tile Entities loaded.");
    }

    private static void loadItems() {
        Chisel.logger.info("Loading items...");
        int num = 0;
        for (Features f : Features.values()) {
            if (f.enabled()) {
                f.addItems();
                ++num;
                continue;
            }
            Features.logDisabled(f);
        }
        Chisel.logger.info(num + " Feature's items loaded.");
    }

    private static void loadRecipes() {
        Chisel.logger.info("Loading recipes...");
        int num = 0;
        for (Features f : Features.values()) {
            if (f.enabled()) {
                f.addRecipes();
                ++num;
                continue;
            }
            Features.logDisabled(f);
        }
        Chisel.logger.info(num + " Feature's recipes loaded.");
    }

    private static void logDisabled(Features f) {
        if (!f.hasParentFeature() && f.parent != null) {
            Chisel.logger.info("Skipping feature {} as its parent feature {} was disabled.", new Object[]{Configurations.featureName(f), Configurations.featureName(f.parent)});
        } else if (!f.hasRequiredMod() && f.getRequiredMod() != null) {
            Chisel.logger.info("Skipping feature {} as its required mod {} was missing.", new Object[]{Configurations.featureName(f), f.getRequiredMod()});
        } else {
            Chisel.logger.info("Skipping feature {} as it was disabled in the config.", new Object[]{Configurations.featureName(f)});
        }
    }

    public static boolean oneModdedFeatureLoaded() {
        for (Features f : Features.values()) {
            if (!f.hasRequiredMod()) continue;
            return true;
        }
        return false;
    }

    static void preInit() {
        Chisel.logger.info("Starting pre-init...");
        Features.loadBlocks();
        Features.loadItems();
        Chisel.logger.info("Pre-init finished.");
    }

    private Features() {
        this(null, null);
    }

    private Features(Features parent) {
        this(null, parent);
    }

    private Features(String requiredMod) {
        this(requiredMod, null);
    }

    private Features(String requriedMod, Features parent) {
        this.requiredMod = requriedMod;
        this.parent = parent;
    }

    void addBlocks(ChiselBlockFactory factory) {
    }

    void addItems() {
    }

    void addRecipes() {
    }

    public boolean enabled() {
        return Configurations.featureEnabled(this) && this.hasRequiredMod() && this.hasParentFeature();
    }

    private final boolean hasParentFeature() {
        return this.parent == null || this.parent.enabled();
    }

    private final boolean hasRequiredMod() {
        return this.getRequiredMod() == null || Loader.isModLoaded((String)this.getRequiredMod());
    }

    private String getRequiredMod() {
        return this.requiredMod;
    }

    boolean needsMetaRecipes() {
        return false;
    }

    private static void registerSlabTop(@Nonnull Block bottom, Block top) {
        ResourceLocation block = (ResourceLocation)Block.field_149771_c.func_177774_c((Object)bottom);
        String name = block.func_110623_a() + "_top";
    }

    static {
        dyeColors = new String[]{"Black", "Red", "Green", "Brown", "Blue", "Purple", "Cyan", "LightGray", "Gray", "Pink", "Lime", "Yellow", "LightBlue", "Magenta", "Orange", "White"};
        dyeOres = new String[]{"dyeBlack", "dyeRed", "dyeGreen", "dyeBrown", "dyeBlue", "dyePurple", "dyeCyan", "dyeLightGray", "dyeGray", "dyePink", "dyeLime", "dyeYellow", "dyeLightBlue", "dyeMagenta", "dyeOrange", "dyeWhite"};
        creator = BlockCarvable::new;
        provider = new ChiselBlockProvider<BlockCarvable>(creator, BlockCarvable.class);
    }

    @ParametersAreNonnullByDefault
    private static class ChiselBlockProvider<T extends Block>
    implements BlockProvider<T> {
        private final BlockCreator<T> creator;
        private final Class<T> blockClass;

        @Override
        public T createBlock(Material mat, int index, int maxVariation, VariationData ... data) {
            return this.creator.createBlock(mat, index, maxVariation, data);
        }

        @Override
        public ItemBlock createItemBlock(T block) {
            return (ItemBlock)new ItemChiselBlock((Block)block).setRegistryName(block.getRegistryName());
        }

        @ConstructorProperties(value={"creator", "blockClass"})
        public ChiselBlockProvider(BlockCreator<T> creator, Class<T> blockClass) {
            this.creator = creator;
            this.blockClass = blockClass;
        }

        @Override
        public Class<T> getBlockClass() {
            return this.blockClass;
        }
    }
}

