/*
 * Decompiled with CFR 0.152.
 */
package team.chisel.client;

import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import team.chisel.Chisel;
import team.chisel.api.block.ClientVariationData;
import team.chisel.api.block.VariationData;
import team.chisel.api.render.IBlockRenderType;
import team.chisel.api.render.IChiselFace;
import team.chisel.api.render.IChiselTexture;
import team.chisel.client.ChiselFace;
import team.chisel.common.util.json.JsonHelper;

public class BlockFaceData {
    private VariationFaceData[] variationData;
    private Set<BlockRenderLayer> layers;

    public BlockFaceData(VariationData[] clientVariationData) {
        this.variationData = new VariationFaceData[clientVariationData.length];
        for (int i = 0; i < clientVariationData.length; ++i) {
            this.variationData[i] = new VariationFaceData((ClientVariationData)clientVariationData[i]);
        }
    }

    public VariationFaceData getForMeta(int meta) {
        try {
            return this.variationData[meta];
        }
        catch (ArrayIndexOutOfBoundsException exception) {
            Chisel.debug("Meta " + meta + " out of bounds");
            return this.variationData[0];
        }
    }

    public boolean isValid(BlockRenderLayer layer) {
        if (this.layers == null) {
            this.layers = EnumSet.noneOf(BlockRenderLayer.class);
            for (VariationFaceData data : this.variationData) {
                for (IChiselFace face : data.getAllFaces()) {
                    for (IChiselTexture<?> tex : face.getTextureList()) {
                        this.layers.add(tex.getLayer());
                    }
                }
            }
        }
        return this.layers.contains(layer);
    }

    public static class VariationFaceData {
        public IChiselFace defaultFace;
        private Map<EnumFacing, IChiselFace> sideOverrides;
        private List<IBlockRenderType> typesUsed;

        public VariationFaceData(ClientVariationData data) {
            this(JsonHelper.getOrCreateFace(VariationFaceData.toBlock(data.defaultFace)), VariationFaceData.transformMap(data.sideOverrides));
        }

        private static Map<EnumFacing, IChiselFace> transformMap(Map<EnumFacing, ResourceLocation> mapIn) {
            HashMap<EnumFacing, IChiselFace> map = new HashMap<EnumFacing, IChiselFace>();
            for (Map.Entry<EnumFacing, ResourceLocation> e : mapIn.entrySet()) {
                map.put(e.getKey(), JsonHelper.getOrCreateFace(VariationFaceData.toBlock(e.getValue())));
            }
            return map;
        }

        private static ResourceLocation toBlock(ResourceLocation loc) {
            return new ResourceLocation(loc.func_110624_b(), loc.func_110623_a() + ".cf");
        }

        public VariationFaceData(IChiselFace defaultFace, Map<EnumFacing, IChiselFace> sideOverrides) {
            this.defaultFace = defaultFace;
            this.sideOverrides = sideOverrides;
            this.typesUsed = new ArrayList<IBlockRenderType>();
            for (IChiselFace iChiselFace : sideOverrides.values()) {
                for (IChiselTexture<?> texture : iChiselFace.getTextureList()) {
                    if (this.typesUsed.contains(texture.getType())) continue;
                    this.typesUsed.add((IBlockRenderType)texture.getType());
                }
            }
            for (IChiselTexture iChiselTexture : defaultFace.getTextureList()) {
                if (this.typesUsed.contains(iChiselTexture.getType())) continue;
                this.typesUsed.add((IBlockRenderType)iChiselTexture.getType());
            }
        }

        public List<IChiselFace> getAllFaces() {
            ArrayList<IChiselFace> faces = new ArrayList<IChiselFace>();
            faces.add(this.defaultFace);
            faces.addAll(this.sideOverrides.values());
            return faces;
        }

        public void setDefaultFace(ChiselFace face) {
            this.defaultFace = face;
        }

        public void setFace(EnumFacing facing, ChiselFace face) {
            this.sideOverrides.put(facing, face);
        }

        public List<IBlockRenderType> getTypesUsed() {
            return this.typesUsed;
        }

        public IChiselFace getFaceForSide(EnumFacing facing) {
            if (facing == null) {
                return this.defaultFace;
            }
            if (this.sideOverrides.containsKey(facing)) {
                return this.sideOverrides.get(facing);
            }
            return this.defaultFace;
        }
    }
}

