/*
 * Decompiled with CFR 0.152.
 */
package team.chisel.client.gui;

import io.netty.buffer.ByteBuf;
import java.util.Optional;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import team.chisel.common.inventory.ContainerChisel;

public class PacketChiselButton
implements IMessage {
    private ItemStack target;
    private int chiselSlot;
    private int[] slotIds;

    public PacketChiselButton(ItemStack target, int chiselSlot, int ... slots) {
        this.target = target;
        this.chiselSlot = chiselSlot;
        this.slotIds = slots;
    }

    public void toBytes(ByteBuf buf) {
        ByteBufUtils.writeItemStack((ByteBuf)buf, (ItemStack)this.target);
        buf.writeByte(this.chiselSlot);
        buf.writeByte(this.slotIds.length);
        for (int i : this.slotIds) {
            buf.writeByte(i);
        }
    }

    public void fromBytes(ByteBuf buf) {
        this.target = ByteBufUtils.readItemStack((ByteBuf)buf);
        this.chiselSlot = buf.readByte();
        byte len = buf.readByte();
        this.slotIds = new int[len];
        for (int i = 0; i < this.slotIds.length; ++i) {
            this.slotIds[i] = buf.readByte();
        }
    }

    public static void chiselAll(EntityPlayer player, int chiselSlot, ItemStack target, int[] slots) {
        if (player.field_71070_bA instanceof ContainerChisel) {
            ContainerChisel container = (ContainerChisel)player.field_71070_bA;
            ItemStack chisel = player.field_71071_by.func_70301_a(chiselSlot);
            if (chisel == null) {
                return;
            }
            for (int i : slots) {
                ItemStack stack = target.func_77946_l();
                int damageLeft = chisel.func_77958_k() - chisel.func_77952_i() + 1;
                Optional.ofNullable(player.field_71071_by.func_70301_a(i)).ifPresent(s -> {
                    int toCraft;
                    itemStack.field_77994_a = toCraft = Math.min(s.field_77994_a, damageLeft);
                    entityPlayer.field_71071_by.func_70299_a(i, stack);
                    chisel.func_77972_a(toCraft, (EntityLivingBase)player);
                    if (itemStack2.field_77994_a <= 0) {
                        containerChisel.getInventoryChisel().getStackInSpecialSlot().field_77994_a = s.field_77994_a - toCraft;
                        entityPlayer.field_71071_by.func_70299_a(chiselSlot, null);
                        if (s.field_77994_a > toCraft) {
                            ItemStack remainder = s.func_77946_l();
                            remainder.field_77994_a = s.field_77994_a - toCraft;
                            if (!entityPlayer.field_71071_by.func_70441_a(remainder)) {
                                player.func_71019_a(remainder, false);
                            }
                        }
                    }
                });
                if (chisel.field_77994_a >= 1) continue;
                return;
            }
        }
    }

    public PacketChiselButton() {
    }

    public static class Handler
    implements IMessageHandler<PacketChiselButton, IMessage> {
        public IMessage onMessage(PacketChiselButton message, MessageContext ctx) {
            EntityPlayerMP player = ctx.getServerHandler().field_147369_b;
            PacketChiselButton.chiselAll((EntityPlayer)player, message.chiselSlot, message.target, message.slotIds);
            return null;
        }
    }
}

