/*
 * Decompiled with CFR 0.152.
 */
package team.chisel.common.block;

import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.particle.ParticleManager;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.property.ExtendedBlockState;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import team.chisel.Chisel;
import team.chisel.api.block.ICarvable;
import team.chisel.api.block.VariationData;
import team.chisel.api.render.IBlockRenderType;
import team.chisel.api.render.RenderContextList;
import team.chisel.client.BlockFaceData;
import team.chisel.client.ClientUtil;
import team.chisel.common.init.ChiselTabs;
import team.chisel.common.util.PropertyAnyInteger;
import team.chisel.common.util.PropertyRenderContextList;

@ParametersAreNonnullByDefault
public class BlockCarvable
extends Block
implements ICarvable {
    private final PropertyAnyInteger metaProp;
    public static final PropertyRenderContextList CTX_LIST = new PropertyRenderContextList();
    private final int index;
    @SideOnly(value=Side.CLIENT)
    @Nullable
    private BlockFaceData blockFaceData;
    private final VariationData[] variations;
    private final BlockStateContainer realBlockState;
    private final int maxVariation;
    private int redstoneLevel = 0;
    private int quantityDropped = 1;
    private int bonusRandQuantity = 0;
    private Item drop;
    private float enchantPowerBonus = 0.0f;
    private boolean canSilkHarvest = true;

    public BlockCarvable(Material material, int index, int max, VariationData ... variations) {
        super(material);
        this.func_149647_a(ChiselTabs.tab);
        this.index = index;
        this.variations = variations;
        this.maxVariation = max;
        this.metaProp = PropertyAnyInteger.create("variation", 0, max > index * 16 ? 15 : max % 16);
        this.realBlockState = this.createRealBlockState(this.metaProp);
        this.setupStates();
        Chisel.proxy.initiateFaceData(this);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    @Nullable
    public BlockFaceData getBlockFaceData() {
        return this.blockFaceData;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void setBlockFaceData(BlockFaceData data) {
        this.blockFaceData = data;
    }

    @Override
    public int getVariationIndex(IBlockState state) {
        return this.func_176201_c(state);
    }

    @Override
    public int getTotalVariations() {
        return this.maxVariation + 1;
    }

    public BlockStateContainer func_176194_O() {
        return this.realBlockState;
    }

    @Override
    public int getIndex() {
        return this.index;
    }

    @Override
    public VariationData getVariationData(int meta) {
        return this.variations[MathHelper.func_76125_a((int)meta, (int)0, (int)(this.variations.length - 1))];
    }

    private BlockStateContainer createRealBlockState(PropertyAnyInteger p) {
        return new ExtendedBlockState((Block)this, new IProperty[]{p}, new IUnlistedProperty[]{CTX_LIST});
    }

    public BlockStateContainer func_180661_e() {
        return Blocks.field_150350_a.func_176194_O();
    }

    private void setupStates() {
        IBlockState state = this.getExtendedBlockState().withProperty((IUnlistedProperty)CTX_LIST, (Object)new RenderContextList()).func_177226_a((IProperty)this.metaProp, (Comparable)Integer.valueOf(0));
        state = state.func_177226_a((IProperty)this.metaProp, (Comparable)Integer.valueOf(0));
        this.func_180632_j(state);
    }

    public BlockCarvable setRedstoneLevel(int level) {
        this.redstoneLevel = level;
        return this;
    }

    public BlockCarvable setEnchantPowerBonus(float bonus) {
        this.enchantPowerBonus = bonus;
        return this;
    }

    public BlockCarvable setQuantityDropped(int amount) {
        this.quantityDropped = amount;
        return this;
    }

    public BlockCarvable setQuantityBonusDropped(int amount) {
        this.bonusRandQuantity = amount;
        return this;
    }

    public BlockCarvable setDrop(Item drop) {
        this.drop = drop;
        return this;
    }

    public BlockCarvable setCanSilkHarvest(boolean bool) {
        this.canSilkHarvest = bool;
        return this;
    }

    public float getEnchantPowerBonus(World world, BlockPos pos) {
        return this.enchantPowerBonus;
    }

    public boolean func_149744_f(IBlockState state) {
        return this.redstoneLevel > 0;
    }

    public int func_180656_a(IBlockState blockState, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
        return this.redstoneLevel;
    }

    public ExtendedBlockState getBaseExtendedState() {
        return (ExtendedBlockState)this.func_176194_O();
    }

    public IExtendedBlockState getExtendedBlockState() {
        return (IExtendedBlockState)this.getBaseExtendedState().func_177621_b();
    }

    public int func_180651_a(IBlockState state) {
        return this.func_176201_c(state);
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176194_O().func_177621_b().func_177226_a((IProperty)this.metaProp, (Comparable)Integer.valueOf(meta));
    }

    public int func_176201_c(IBlockState state) {
        return (Integer)state.func_177229_b((IProperty)this.metaProp);
    }

    public String getIndexName() {
        if (this.index == 0) {
            return this.func_149739_a();
        }
        return this.func_149739_a() + this.index;
    }

    @SideOnly(value=Side.CLIENT)
    public IBlockState getExtendedState(IBlockState stateIn, IBlockAccess w, BlockPos pos) {
        if (stateIn.func_185904_a() == Material.field_151579_a) {
            return stateIn;
        }
        BlockFaceData data = this.blockFaceData;
        if (data != null) {
            IExtendedBlockState state = (IExtendedBlockState)stateIn;
            List<IBlockRenderType> types = data.getForMeta(this.func_176201_c((IBlockState)state)).getTypesUsed();
            RenderContextList ctxList = new RenderContextList(types, w, pos);
            return state.withProperty((IUnlistedProperty)CTX_LIST, (Object)ctxList);
        }
        return stateIn;
    }

    public static BlockPos pos(int x, int y, int z) {
        return new BlockPos(x, y, z);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149666_a(Item item, CreativeTabs tab, List list) {
        int curIndex = 0;
        for (VariationData var : this.variations) {
            if (var == null) continue;
            ItemStack stack = new ItemStack(item, 1, curIndex);
            ++curIndex;
            list.add(stack);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public boolean addHitEffects(IBlockState state, World worldObj, RayTraceResult target, ParticleManager effectRenderer) {
        ClientUtil.addHitEffects(worldObj, target.func_178782_a(), target.field_178784_b);
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean addDestroyEffects(World world, BlockPos pos, ParticleManager effectRenderer) {
        ClientUtil.addDestroyEffects(world, pos, world.func_180495_p(pos));
        return true;
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean canRenderInLayer(BlockRenderLayer layer) {
        BlockFaceData data = this.blockFaceData;
        if (data != null) {
            return this.blockFaceData == null ? false : data.isValid(layer);
        }
        return false;
    }

    public boolean func_149730_j(IBlockState state) {
        return true;
    }

    public boolean func_149686_d(IBlockState state) {
        return state.func_185914_p();
    }

    @Deprecated
    public boolean func_149662_c(IBlockState state) {
        return this.getVariationData((int)this.func_176201_c((IBlockState)state)).opaque;
    }

    public int getLightOpacity(IBlockState state, IBlockAccess world, BlockPos pos) {
        return this.func_149662_c(state) ? 255 : 0;
    }

    @Deprecated
    @SideOnly(value=Side.CLIENT)
    public boolean func_176225_a(IBlockState blockState, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
        IBlockState other = blockAccess.func_180495_p(pos.func_177972_a(side));
        if (other instanceof IExtendedBlockState) {
            other = ((IExtendedBlockState)other).getClean();
        }
        return ((IExtendedBlockState)blockState).getClean() != other;
    }

    public boolean func_176214_u() {
        return true;
    }

    public int func_149745_a(Random random) {
        return this.quantityDropped + random.nextInt(this.bonusRandQuantity + 1);
    }

    @Nullable
    public Item func_180660_a(IBlockState blockState, Random rand, int fortune) {
        if (this.drop == null) {
            return super.func_180660_a(blockState, rand, fortune);
        }
        return this.drop;
    }

    protected boolean func_149700_E() {
        return this.canSilkHarvest;
    }

    public PropertyAnyInteger getMetaProp() {
        return this.metaProp;
    }

    @Override
    public VariationData[] getVariations() {
        return this.variations;
    }
}

