/*
 * Decompiled with CFR 0.152.
 */
package baubles.common.network;

import baubles.common.Baubles;
import baubles.common.lib.PlayerHandler;
import io.netty.buffer.ByteBuf;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class PacketSyncBauble
implements IMessage,
IMessageHandler<PacketSyncBauble, IMessage> {
    int slot;
    int playerId;
    ItemStack bauble = null;

    public PacketSyncBauble() {
    }

    public PacketSyncBauble(EntityPlayer player, int slot) {
        this.slot = slot;
        this.bauble = PlayerHandler.getPlayerBaubles(player).func_70301_a(slot);
        this.playerId = player.func_145782_y();
    }

    public void toBytes(ByteBuf buffer) {
        buffer.writeByte(this.slot);
        buffer.writeInt(this.playerId);
        ByteBufUtils.writeItemStack((ByteBuf)buffer, (ItemStack)this.bauble);
    }

    public void fromBytes(ByteBuf buffer) {
        this.slot = buffer.readByte();
        this.playerId = buffer.readInt();
        this.bauble = ByteBufUtils.readItemStack((ByteBuf)buffer);
    }

    @SideOnly(value=Side.CLIENT)
    public IMessage onMessage(final PacketSyncBauble message, MessageContext ctx) {
        Minecraft.func_71410_x().func_152344_a(new Runnable(){

            @Override
            public void run() {
                PacketSyncBauble.this.processMessage(message);
            }
        });
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    void processMessage(PacketSyncBauble message) {
        World world = Baubles.proxy.getClientWorld();
        if (world == null) {
            return;
        }
        Entity p = world.func_73045_a(message.playerId);
        if (p != null && p instanceof EntityPlayer) {
            PlayerHandler.getPlayerBaubles((EntityPlayer)((EntityPlayer)p)).stackList[message.slot] = message.bauble;
        }
    }
}

