/*
 * Decompiled with CFR 0.152.
 */
package the_fireplace.fluidity.blocks;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleManager;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import the_fireplace.fluidity.Fluidity;
import the_fireplace.fluidity.entity.tile.TileEntityFluidityIronChest;
import the_fireplace.fluidity.enums.FluidityIronChestType;
import the_fireplace.fluidity.particle.ParticleIronChest;

public class BlockFluidityIronChest
extends BlockContainer {
    public static final PropertyEnum<FluidityIronChestType> VARIANT_PROP = PropertyEnum.func_177709_a((String)"variant", FluidityIronChestType.class);
    protected static final AxisAlignedBB IRON_CHEST_AABB = new AxisAlignedBB(0.0625, 0.0, 0.0625, 0.9375, 0.875, 0.9375);
    private static final EnumFacing[] validRotationAxes = new EnumFacing[]{EnumFacing.UP, EnumFacing.DOWN};

    public BlockFluidityIronChest() {
        super(Material.field_151573_f);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a(VARIANT_PROP, (Comparable)((Object)FluidityIronChestType.BRONZE)));
        this.func_149711_c(3.0f);
        this.func_149663_c("iron_chest");
        this.setRegistryName("fluidity_iron_chest");
    }

    public int func_149750_m(IBlockState state) {
        if (((FluidityIronChestType)((Object)state.func_177229_b(VARIANT_PROP))).equals((Object)FluidityIronChestType.STARSTEEL)) {
            return 7;
        }
        return this.field_149784_t;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return IRON_CHEST_AABB;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.ENTITYBLOCK_ANIMATED;
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState blockState, EntityPlayer player, EnumHand hand, ItemStack heldItem, EnumFacing direction, float p_180639_6_, float p_180639_7_, float p_180639_8_) {
        TileEntity te = world.func_175625_s(pos);
        if (te == null || !(te instanceof TileEntityFluidityIronChest)) {
            return true;
        }
        if (world.isSideSolid(pos.func_177982_a(0, 1, 0), EnumFacing.DOWN)) {
            return true;
        }
        if (world.field_72995_K) {
            return true;
        }
        player.openGui((Object)Fluidity.instance, ((TileEntityFluidityIronChest)te).getType().ordinal(), world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
        return true;
    }

    public TileEntity func_149915_a(World world, int metadata) {
        return FluidityIronChestType.makeEntity(metadata);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149666_a(Item itemIn, CreativeTabs tab, List list) {
        for (FluidityIronChestType type : FluidityIronChestType.values()) {
            if (!type.isValidForCreativeMode()) continue;
            list.add(new ItemStack(itemIn, 1, type.ordinal()));
        }
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(VARIANT_PROP, (Comparable)((Object)FluidityIronChestType.values()[meta]));
    }

    public int func_176201_c(IBlockState blockState) {
        return ((FluidityIronChestType)((Object)blockState.func_177229_b(VARIANT_PROP))).ordinal();
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{VARIANT_PROP});
    }

    public ArrayList<ItemStack> getDrops(IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        ArrayList items = Lists.newArrayList();
        ItemStack stack = new ItemStack((Block)this, 1, this.func_176201_c(state));
        items.add(stack);
        return items;
    }

    public void func_176213_c(World world, BlockPos pos, IBlockState blockState) {
        super.func_176213_c(world, pos, blockState);
        world.func_184138_a(pos, blockState, blockState, 3);
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState blockState, EntityLivingBase entityliving, ItemStack itemStack) {
        TileEntity te = world.func_175625_s(pos);
        if (te != null && te instanceof TileEntityFluidityIronChest) {
            TileEntityFluidityIronChest teic = (TileEntityFluidityIronChest)te;
            teic.wasPlaced(entityliving, itemStack);
            teic.setFacing(entityliving.func_174811_aO().func_176734_d());
            world.func_184138_a(pos, blockState, blockState, 3);
        }
    }

    public int func_180651_a(IBlockState state) {
        return ((FluidityIronChestType)((Object)state.func_177229_b(VARIANT_PROP))).ordinal();
    }

    public void func_180663_b(World world, BlockPos pos, IBlockState blockState) {
        TileEntityFluidityIronChest tileentitychest = (TileEntityFluidityIronChest)world.func_175625_s(pos);
        if (tileentitychest != null) {
            tileentitychest.removeAdornments();
            InventoryHelper.func_180175_a((World)world, (BlockPos)pos, (IInventory)tileentitychest);
        }
        super.func_180663_b(world, pos, blockState);
    }

    public float getExplosionResistance(World world, BlockPos pos, Entity exploder, Explosion explosion) {
        TileEntityFluidityIronChest teic;
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof TileEntityFluidityIronChest && (teic = (TileEntityFluidityIronChest)te).getType().isExplosionResistant()) {
            return 10000.0f;
        }
        return super.getExplosionResistance(world, pos, exploder, explosion);
    }

    public boolean func_149740_M(IBlockState state) {
        return true;
    }

    public int func_180641_l(IBlockState state, World world, BlockPos pos) {
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof IInventory) {
            return Container.func_94526_b((IInventory)((IInventory)te));
        }
        return 0;
    }

    public EnumFacing[] getValidRotations(World worldObj, BlockPos pos) {
        return validRotationAxes;
    }

    public boolean rotateBlock(World worldObj, BlockPos pos, EnumFacing axis) {
        if (worldObj.field_72995_K) {
            return false;
        }
        if (axis == EnumFacing.UP || axis == EnumFacing.DOWN) {
            TileEntity tileEntity = worldObj.func_175625_s(pos);
            if (tileEntity instanceof TileEntityFluidityIronChest) {
                TileEntityFluidityIronChest icte = (TileEntityFluidityIronChest)tileEntity;
                icte.rotateAround();
            }
            return true;
        }
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean addHitEffects(IBlockState state, World worldObj, RayTraceResult target, ParticleManager manager) {
        BlockPos pos = target.func_178782_a();
        Random rand = new Random();
        EnumFacing side = target.field_178784_b;
        int i = pos.func_177958_n();
        int j = pos.func_177956_o();
        int k = pos.func_177952_p();
        float f = 0.1f;
        AxisAlignedBB axisalignedbb = state.func_185900_c((IBlockAccess)worldObj, pos);
        double d0 = (double)i + rand.nextDouble() * (axisalignedbb.field_72336_d - axisalignedbb.field_72340_a - (double)(f * 2.0f)) + (double)f + axisalignedbb.field_72340_a;
        double d1 = (double)j + rand.nextDouble() * (axisalignedbb.field_72337_e - axisalignedbb.field_72338_b - (double)(f * 2.0f)) + (double)f + axisalignedbb.field_72338_b;
        double d2 = (double)k + rand.nextDouble() * (axisalignedbb.field_72334_f - axisalignedbb.field_72339_c - (double)(f * 2.0f)) + (double)f + axisalignedbb.field_72339_c;
        if (side == EnumFacing.DOWN) {
            d1 = (double)j + axisalignedbb.field_72338_b - (double)f;
        }
        if (side == EnumFacing.UP) {
            d1 = (double)j + axisalignedbb.field_72337_e + (double)f;
        }
        if (side == EnumFacing.NORTH) {
            d2 = (double)k + axisalignedbb.field_72339_c - (double)f;
        }
        if (side == EnumFacing.SOUTH) {
            d2 = (double)k + axisalignedbb.field_72334_f + (double)f;
        }
        if (side == EnumFacing.WEST) {
            d0 = (double)i + axisalignedbb.field_72340_a - (double)f;
        }
        if (side == EnumFacing.EAST) {
            d0 = (double)i + axisalignedbb.field_72336_d + (double)f;
        }
        manager.func_78873_a(new ParticleIronChest(worldObj, d0, d1, d2, 0.0, 0.0, 0.0, state).setBlockPos(pos).func_70543_e(0.2f).func_70541_f(0.6f));
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean addDestroyEffects(World world, BlockPos pos, ParticleManager manager) {
        IBlockState state = world.func_180495_p(pos).func_185899_b((IBlockAccess)world, pos);
        int i = 4;
        for (int j = 0; j < i; ++j) {
            for (int k = 0; k < i; ++k) {
                for (int l = 0; l < i; ++l) {
                    double d0 = (double)pos.func_177958_n() + ((double)j + 0.5) / (double)i;
                    double d1 = (double)pos.func_177956_o() + ((double)k + 0.5) / (double)i;
                    double d2 = (double)pos.func_177952_p() + ((double)l + 0.5) / (double)i;
                    manager.func_78873_a((Particle)new ParticleIronChest(world, d0, d1, d2, d0 - (double)pos.func_177958_n() - 0.5, d1 - (double)pos.func_177956_o() - 0.5, d2 - (double)pos.func_177952_p() - 0.5, state).setBlockPos(pos));
                }
            }
        }
        return true;
    }
}

