/*
 * Decompiled with CFR 0.152.
 */
package the_fireplace.fluidity.compat;

import com.google.common.collect.Maps;
import cyano.basemetals.init.Materials;
import cyano.basemetals.material.MetalMaterial;
import java.util.Collection;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import the_fireplace.fluidity.Fluidity;
import the_fireplace.fluidity.blocks.BaseMetalAnvil;
import the_fireplace.fluidity.compat.IModCompat;
import the_fireplace.fluidity.events.BaseMetalsMoreAnvilsClientEvents;
import the_fireplace.fluidity.items.ItemBaseMetalAnvil;
import the_fireplace.fluidity.tools.Registry;

public class BaseMetalsMoreAnvils
implements IModCompat {
    private static Map<MetalMaterial, Block> anvils = Maps.newHashMap();
    private static Collection<MetalMaterial> materials;

    private void buildAnvils() {
        for (MetalMaterial mat : materials) {
            BaseMetalAnvil anvil = new BaseMetalAnvil(mat);
            anvils.put(mat, (Block)anvil);
        }
    }

    private void registerAnvils() {
        for (MetalMaterial mat : materials) {
            GameRegistry.registerBlock((Block)anvils.get(mat), ItemBaseMetalAnvil.class);
        }
    }

    private void registerAnvilRenderers() {
        for (MetalMaterial mat : materials) {
            this.registerAnvilRenderer(anvils.get(mat));
        }
    }

    private void addAnvilRecipes() {
        for (MetalMaterial mat : materials) {
            this.addAnvilRecipe(mat, "block" + mat.getCapitalizedName(), "ingot" + mat.getCapitalizedName());
        }
    }

    private void addAnvilRecipe(MetalMaterial mat, String blockName, String ingotName) {
        Registry.addRecipe(new ItemStack(anvils.get(mat)), "bbb", " i ", "iii", Character.valueOf('b'), blockName, Character.valueOf('i'), ingotName);
    }

    @Override
    public void preInit() {
        Materials.init();
        materials = Materials.getAllMetals();
        materials.remove(Materials.vanilla_diamond);
        materials.remove(Materials.vanilla_gold);
        materials.remove(Materials.vanilla_iron);
        materials.remove(Materials.vanilla_stone);
        materials.remove(Materials.vanilla_wood);
        materials.remove(Materials.zinc);
        this.buildAnvils();
        this.registerAnvils();
    }

    @Override
    public void init() {
        this.addAnvilRecipes();
        if (Fluidity.instance.isClient) {
            MinecraftForge.EVENT_BUS.register((Object)new BaseMetalsMoreAnvilsClientEvents());
        }
    }

    @Override
    public void postInit() {
    }

    @Override
    public void registerInvRenderers() {
        this.registerAnvilRenderers();
    }

    @SideOnly(value=Side.CLIENT)
    public void registerAnvilRenderer(Block anvil) {
        ModelLoader.registerItemVariants((Item)Item.func_150898_a((Block)anvil), (ResourceLocation[])new ResourceLocation[]{new ModelResourceLocation("fluidity:" + anvil.func_149739_a().substring(5) + "_intact", "inventory"), new ModelResourceLocation("fluidity:" + anvil.func_149739_a().substring(5) + "_slightly_damaged", "inventory"), new ModelResourceLocation("fluidity:" + anvil.func_149739_a().substring(5) + "_very_damaged", "inventory")});
        ModelLoader.setCustomModelResourceLocation((Item)Item.func_150898_a((Block)anvil), (int)0, (ModelResourceLocation)new ModelResourceLocation("fluidity:" + anvil.func_149739_a().substring(5) + "_intact", "inventory"));
        ModelLoader.setCustomModelResourceLocation((Item)Item.func_150898_a((Block)anvil), (int)1, (ModelResourceLocation)new ModelResourceLocation("fluidity:" + anvil.func_149739_a().substring(5) + "_slightly_damaged", "inventory"));
        ModelLoader.setCustomModelResourceLocation((Item)Item.func_150898_a((Block)anvil), (int)2, (ModelResourceLocation)new ModelResourceLocation("fluidity:" + anvil.func_149739_a().substring(5) + "_very_damaged", "inventory"));
    }
}

