/*
 * Decompiled with CFR 0.152.
 */
package the_fireplace.fluidity.compat;

import cpw.mods.ironchest.IronChest;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.network.IGuiHandler;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.common.registry.IForgeRegistryEntry;
import net.minecraftforge.oredict.OreDictionary;
import the_fireplace.fluidity.Fluidity;
import the_fireplace.fluidity.blocks.BlockFluidityIronChest;
import the_fireplace.fluidity.compat.IModCompat;
import the_fireplace.fluidity.enums.FluidityChestChangerType;
import the_fireplace.fluidity.enums.FluidityIronChestChangerType;
import the_fireplace.fluidity.enums.FluidityIronChestType;
import the_fireplace.fluidity.enums.IronFluidityChestChangerType;
import the_fireplace.fluidity.events.FluidityIronChestsCommonEvents;
import the_fireplace.fluidity.handler.FluidityIronChestsGuiHandler;
import the_fireplace.fluidity.items.ItemFluidityIronChest;
import the_fireplace.fluidity.tools.Registry;

public class FluidityIronChests
implements IModCompat {
    public static Block fluidityChest;
    public static ArrayList<Item> creativeQueue;

    @Override
    public void preInit() {
        fluidityChest = new BlockFluidityIronChest();
        FluidityChestChangerType.buildItems();
        FluidityIronChestChangerType.buildItems();
        IronFluidityChestChangerType.buildItems();
        GameRegistry.register((IForgeRegistryEntry)fluidityChest);
        GameRegistry.register((IForgeRegistryEntry)new ItemFluidityIronChest(fluidityChest));
        if (Fluidity.proxy.getBMICProxy() != null) {
            Fluidity.proxy.getBMICProxy().register();
        }
    }

    @Override
    public void postInit() {
    }

    @Override
    public void init() {
        FluidityIronChestType.registerBlocksAndRecipes((BlockFluidityIronChest)fluidityChest);
        FluidityChestChangerType.generateRecipes();
        FluidityIronChestChangerType.generateRecipes();
        IronFluidityChestChangerType.generateRecipes();
        for (FluidityIronChestType chestType : FluidityIronChestType.VALUES) {
            GameRegistry.registerTileEntity(chestType.clazz, (String)("Fluidity." + chestType.name()));
        }
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)Fluidity.instance, (IGuiHandler)new FluidityIronChestsGuiHandler());
        this.addRecipes();
        MinecraftForge.EVENT_BUS.register((Object)new FluidityIronChestsCommonEvents());
        if (FluidityIronChests.canIronChest()) {
            fluidityChest.func_149647_a(Fluidity.tabFluidity);
            for (Item i : creativeQueue) {
                i.func_77637_a(Fluidity.tabFluidity);
            }
        }
    }

    private void addRecipes() {
        ItemStack ironChestStack = new ItemStack((Block)IronChest.ironChestBlock, 1, 0);
        ItemStack silverChestStack = new ItemStack((Block)IronChest.ironChestBlock, 1, 4);
        ItemStack goldChestStack = new ItemStack((Block)IronChest.ironChestBlock, 1, 1);
        ItemStack diamondChestStack = new ItemStack((Block)IronChest.ironChestBlock, 1, 2);
        ItemStack bronzeChestStack = new ItemStack(fluidityChest, 1, 0);
        ItemStack invarChestStack = new ItemStack(fluidityChest, 1, 1);
        ItemStack electrumChestStack = new ItemStack(fluidityChest, 1, 2);
        ItemStack tinChestStack = new ItemStack(fluidityChest, 1, 3);
        ItemStack brassChestStack = new ItemStack(fluidityChest, 1, 4);
        ItemStack leadChestStack = new ItemStack(fluidityChest, 1, 5);
        ItemStack steelChestStack = new ItemStack(fluidityChest, 1, 6);
        ItemStack nickelChestStack = new ItemStack(fluidityChest, 1, 7);
        ItemStack coldironChestStack = new ItemStack(fluidityChest, 1, 8);
        Registry.addRecipe(ironChestStack, "igi", "gcg", "igi", Character.valueOf('i'), "ingotIron", Character.valueOf('c'), tinChestStack, Character.valueOf('g'), "blockGlass");
        Registry.addRecipe(ironChestStack, "igi", "gcg", "igi", Character.valueOf('i'), "ingotIron", Character.valueOf('c'), brassChestStack, Character.valueOf('g'), "blockGlass");
        Registry.addRecipe(silverChestStack, "igi", "gcg", "igi", Character.valueOf('i'), "ingotSilver", Character.valueOf('c'), bronzeChestStack, Character.valueOf('g'), "blockGlass");
        Registry.addRecipe(silverChestStack, "iii", "ici", "iii", Character.valueOf('i'), "ingotSilver", Character.valueOf('c'), tinChestStack);
        Registry.addRecipe(silverChestStack, "iii", "ici", "iii", Character.valueOf('i'), "ingotSilver", Character.valueOf('c'), brassChestStack);
        Registry.addRecipe(goldChestStack, "iii", "ici", "iii", Character.valueOf('i'), "ingotGold", Character.valueOf('c'), bronzeChestStack);
        Registry.addRecipe(goldChestStack, "igi", "gcg", "igi", Character.valueOf('i'), "ingotGold", Character.valueOf('c'), leadChestStack, Character.valueOf('g'), "blockGlass");
        Registry.addRecipe(goldChestStack, "igi", "gcg", "igi", Character.valueOf('i'), "ingotGold", Character.valueOf('c'), coldironChestStack, Character.valueOf('g'), "blockGlass");
        Registry.addRecipe(goldChestStack, "igi", "gcg", "igi", Character.valueOf('i'), "ingotGold", Character.valueOf('c'), nickelChestStack, Character.valueOf('g'), "blockGlass");
        Registry.addRecipe(goldChestStack, "igi", "gcg", "igi", Character.valueOf('i'), "ingotGold", Character.valueOf('c'), steelChestStack, Character.valueOf('g'), "blockGlass");
        Registry.addRecipe(diamondChestStack, "ggg", "ici", "ggg", Character.valueOf('i'), "gemDiamond", Character.valueOf('c'), invarChestStack, Character.valueOf('g'), "blockGlass");
        Registry.addRecipe(diamondChestStack, "ggg", "ici", "ggg", Character.valueOf('i'), "gemDiamond", Character.valueOf('c'), electrumChestStack, Character.valueOf('g'), "blockGlass");
    }

    @Override
    public void registerInvRenderers() {
        for (FluidityIronChestType chestType : FluidityIronChestType.values()) {
            Item chestItem = Item.func_150898_a((Block)fluidityChest);
            ModelLoader.setCustomModelResourceLocation((Item)chestItem, (int)chestType.ordinal(), (ModelResourceLocation)new ModelResourceLocation("fluidity:chest_" + chestType.func_176610_l().toLowerCase(), "inventory"));
            ModelLoader.registerItemVariants((Item)chestItem, (ResourceLocation[])new ResourceLocation[]{new ResourceLocation("fluidity:chest_" + chestType.func_176610_l().toLowerCase())});
        }
    }

    public static boolean canIronChest() {
        String[] names;
        for (String name : names = new String[]{"ingotBronze", "ingotTin", "ingotLead", "ingotNickel", "ingotPlatinum", "ingotCupronickel", "ingotBrass", "ingotColdiron", "ingotSteel", "ingotInvar", "ingotElectrum", "ingotMithril"}) {
            if (OreDictionary.getOres((String)name).isEmpty()) continue;
            return true;
        }
        return false;
    }

    static {
        creativeQueue = new ArrayList();
    }
}

