/*
 * Decompiled with CFR 0.152.
 */
package the_fireplace.fluidity.entity.tile;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntityLockableLoot;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import the_fireplace.fluidity.compat.FluidityIronChests;
import the_fireplace.fluidity.container.ContainerFluidityIronChest;
import the_fireplace.fluidity.enums.FluidityIronChestType;

public class TileEntityFluidityIronChest
extends TileEntityLockableLoot
implements ITickable,
IInventory {
    private int ticksSinceSync = -1;
    public float prevLidAngle;
    public float lidAngle;
    private int numUsingPlayers;
    private FluidityIronChestType type;
    public ItemStack[] chestContents;
    private EnumFacing facing;
    private boolean inventoryTouched;
    private String customName;
    public static final int UPDATE_PLAYERNUMBERS = 1;
    public static final int UPDATE_FACING = 2;

    public TileEntityFluidityIronChest() {
        this(FluidityIronChestType.BRONZE);
    }

    protected TileEntityFluidityIronChest(FluidityIronChestType type) {
        this.type = type;
        this.chestContents = new ItemStack[this.func_70302_i_()];
        this.facing = EnumFacing.NORTH;
    }

    public void setContents(ItemStack[] contents) {
        this.chestContents = new ItemStack[this.func_70302_i_()];
        for (int i = 0; i < contents.length; ++i) {
            if (i >= this.chestContents.length) continue;
            this.chestContents[i] = contents[i];
        }
        this.inventoryTouched = true;
    }

    public int func_70302_i_() {
        return this.type.size;
    }

    public EnumFacing getFacing() {
        return this.facing;
    }

    public FluidityIronChestType getType() {
        return this.type;
    }

    public ItemStack func_70301_a(int i) {
        this.func_184281_d(null);
        this.inventoryTouched = true;
        return this.chestContents[i];
    }

    @Nullable
    public ItemStack func_70298_a(int i, int j) {
        this.func_184281_d(null);
        ItemStack itemstack = ItemStackHelper.func_188382_a((ItemStack[])this.chestContents, (int)i, (int)j);
        if (itemstack != null) {
            this.func_70296_d();
        }
        return itemstack;
    }

    public void func_70299_a(int i, ItemStack itemstack) {
        this.func_184281_d(null);
        this.chestContents[i] = itemstack;
        if (itemstack != null && itemstack.field_77994_a > this.func_70297_j_()) {
            itemstack.field_77994_a = this.func_70297_j_();
        }
        this.func_70296_d();
    }

    public String func_70005_c_() {
        return this.func_145818_k_() ? this.customName : this.type.name();
    }

    public boolean func_145818_k_() {
        return this.customName != null && this.customName.length() > 0;
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.chestContents = new ItemStack[this.func_70302_i_()];
        if (compound.func_150297_b("CustomName", 8)) {
            this.customName = compound.func_74779_i("CustomName");
        }
        if (!this.func_184283_b(compound)) {
            NBTTagList itemList = compound.func_150295_c("Items", 10);
            for (int itemNumber = 0; itemNumber < itemList.func_74745_c(); ++itemNumber) {
                NBTTagCompound item = itemList.func_150305_b(itemNumber);
                int slot = item.func_74771_c("Slot") & 0xFF;
                if (slot < 0 || slot >= this.chestContents.length) continue;
                this.chestContents[slot] = ItemStack.func_77949_a((NBTTagCompound)item);
            }
        }
        this.facing = EnumFacing.field_82609_l[compound.func_74771_c("facing")];
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        super.func_189515_b(compound);
        if (!this.func_184282_c(compound)) {
            NBTTagList itemList = new NBTTagList();
            for (int slot = 0; slot < this.chestContents.length; ++slot) {
                if (this.chestContents[slot] == null) continue;
                NBTTagCompound tag = new NBTTagCompound();
                tag.func_74774_a("Slot", (byte)slot);
                this.chestContents[slot].func_77955_b(tag);
                itemList.func_74742_a((NBTBase)tag);
            }
            compound.func_74782_a("Items", (NBTBase)itemList);
        }
        compound.func_74774_a("facing", (byte)this.facing.ordinal());
        if (this.func_145818_k_()) {
            compound.func_74778_a("CustomName", this.customName);
        }
        return compound;
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_70300_a(EntityPlayer entityplayer) {
        if (this.field_145850_b == null) {
            return true;
        }
        return this.field_145850_b.func_175625_s(this.field_174879_c) == this && entityplayer.func_70092_e((double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5) <= 64.0;
    }

    public void func_73660_a() {
        if (this.field_145850_b != null && !this.field_145850_b.field_72995_K && this.numUsingPlayers != 0 && (this.ticksSinceSync + this.field_174879_c.func_177958_n() + this.field_174879_c.func_177956_o() + this.field_174879_c.func_177952_p()) % 200 == 0) {
            this.numUsingPlayers = 0;
            float var1 = 5.0f;
            List var2 = this.field_145850_b.func_72872_a(EntityPlayer.class, new AxisAlignedBB((double)((float)this.field_174879_c.func_177958_n() - var1), (double)((float)this.field_174879_c.func_177956_o() - var1), (double)((float)this.field_174879_c.func_177952_p() - var1), (double)((float)(this.field_174879_c.func_177958_n() + 1) + var1), (double)((float)(this.field_174879_c.func_177956_o() + 1) + var1), (double)((float)(this.field_174879_c.func_177952_p() + 1) + var1)));
            for (EntityPlayer var4 : var2) {
                if (!(var4.field_71070_bA instanceof ContainerFluidityIronChest)) continue;
                ++this.numUsingPlayers;
            }
        }
        if (this.field_145850_b != null && !this.field_145850_b.field_72995_K && this.ticksSinceSync < 0) {
            this.field_145850_b.func_175641_c(this.field_174879_c, FluidityIronChests.fluidityChest, 1, this.numUsingPlayers);
            this.field_145850_b.func_175641_c(this.field_174879_c, FluidityIronChests.fluidityChest, 2, this.facing.ordinal());
        }
        if (!this.field_145850_b.field_72995_K && this.inventoryTouched) {
            this.inventoryTouched = false;
        }
        ++this.ticksSinceSync;
        this.prevLidAngle = this.lidAngle;
        float f = 0.1f;
        if (this.numUsingPlayers > 0 && this.lidAngle == 0.0f) {
            double d = (double)this.field_174879_c.func_177958_n() + 0.5;
            double d1 = (double)this.field_174879_c.func_177952_p() + 0.5;
            this.field_145850_b.func_184148_a(null, d, (double)this.field_174879_c.func_177956_o() + 0.5, d1, SoundEvents.field_187657_V, SoundCategory.BLOCKS, 0.5f, this.field_145850_b.field_73012_v.nextFloat() * 0.1f + 0.9f);
        }
        if (this.numUsingPlayers == 0 && this.lidAngle > 0.0f || this.numUsingPlayers > 0 && this.lidAngle < 1.0f) {
            float f2;
            float f1 = this.lidAngle;
            this.lidAngle = this.numUsingPlayers > 0 ? (this.lidAngle += f) : (this.lidAngle -= f);
            if (this.lidAngle > 1.0f) {
                this.lidAngle = 1.0f;
            }
            if (this.lidAngle < (f2 = 0.5f) && f1 >= f2) {
                double d2 = (double)this.field_174879_c.func_177958_n() + 0.5;
                double d3 = (double)this.field_174879_c.func_177952_p() + 0.5;
                this.field_145850_b.func_184148_a(null, d2, (double)this.field_174879_c.func_177956_o() + 0.5, d3, SoundEvents.field_187651_T, SoundCategory.BLOCKS, 0.5f, this.field_145850_b.field_73012_v.nextFloat() * 0.1f + 0.9f);
            }
            if (this.lidAngle < 0.0f) {
                this.lidAngle = 0.0f;
            }
        }
    }

    public boolean func_145842_c(int eventId, int eventArgs) {
        if (eventId == 1) {
            this.numUsingPlayers = eventArgs;
        } else if (eventId == 2) {
            this.facing = EnumFacing.field_82609_l[eventArgs];
        }
        return true;
    }

    public void func_174889_b(EntityPlayer player) {
        if (this.field_145850_b == null) {
            return;
        }
        ++this.numUsingPlayers;
        this.field_145850_b.func_175641_c(this.field_174879_c, FluidityIronChests.fluidityChest, 1, this.numUsingPlayers);
        this.field_145850_b.func_175685_c(this.field_174879_c, FluidityIronChests.fluidityChest);
        this.field_145850_b.func_175685_c(this.field_174879_c.func_177977_b(), FluidityIronChests.fluidityChest);
    }

    public void func_174886_c(EntityPlayer player) {
        if (this.field_145850_b == null) {
            return;
        }
        --this.numUsingPlayers;
        this.field_145850_b.func_175641_c(this.field_174879_c, FluidityIronChests.fluidityChest, 1, this.numUsingPlayers);
        this.field_145850_b.func_175685_c(this.field_174879_c, FluidityIronChests.fluidityChest);
        this.field_145850_b.func_175685_c(this.field_174879_c.func_177977_b(), FluidityIronChests.fluidityChest);
    }

    public void setFacing(EnumFacing newFacing) {
        this.facing = newFacing;
        if (this.func_145830_o()) {
            this.field_145850_b.func_175641_c(this.field_174879_c, FluidityIronChests.fluidityChest, 2, this.facing.ordinal());
        }
    }

    public NBTTagCompound func_189517_E_() {
        return this.func_189515_b(new NBTTagCompound());
    }

    public SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.field_174879_c, this.type.ordinal(), this.func_189517_E_());
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        this.func_145839_a(pkt.func_148857_g());
    }

    @Nullable
    public ItemStack func_70304_b(int index) {
        this.func_184281_d(null);
        return ItemStackHelper.func_188383_a((ItemStack[])this.chestContents, (int)index);
    }

    public boolean func_94041_b(int i, ItemStack itemstack) {
        return this.type.acceptsStack(itemstack);
    }

    public void rotateAround() {
        this.setFacing(this.facing.func_176746_e());
    }

    public void wasPlaced(EntityLivingBase entityliving, ItemStack itemStack) {
    }

    public void removeAdornments() {
    }

    public int func_174887_a_(int id) {
        return 0;
    }

    public void func_174885_b(int id, int value) {
    }

    public int func_174890_g() {
        return 0;
    }

    public void func_174888_l() {
        this.func_184281_d(null);
        for (int i = 0; i < this.chestContents.length; ++i) {
            this.chestContents[i] = null;
        }
    }

    public Container func_174876_a(InventoryPlayer playerInventory, EntityPlayer player) {
        this.func_184281_d(null);
        return new ContainerFluidityIronChest((IInventory)playerInventory, this, this.type, 0, 0);
    }

    public String func_174875_k() {
        return "Fluidity:" + this.type.name();
    }

    public boolean canRenderBreaking() {
        return true;
    }
}

