/*
 * Decompiled with CFR 0.152.
 */
package the_fireplace.fluidity.enums;

import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.common.registry.IForgeRegistryEntry;
import net.minecraftforge.fml.relauncher.Side;
import the_fireplace.fluidity.compat.FluidityIronChests;
import the_fireplace.fluidity.enums.FluidityIronChestType;
import the_fireplace.fluidity.items.FluidityItemChestChanger;
import the_fireplace.fluidity.tools.Registry;

public enum FluidityChestChangerType {
    BRONZEINVAR(FluidityIronChestType.BRONZE, FluidityIronChestType.INVAR, "bronzeInvarUpgrade", "mmm", "msm", "mmm"),
    BRONZEELECTRUM(FluidityIronChestType.BRONZE, FluidityIronChestType.ELECTRUM, "bronzeElectrumUpgrade", "mmm", "msm", "mmm"),
    BRONZEPLATINUM(FluidityIronChestType.BRONZE, FluidityIronChestType.PLATINUM, "bronzePlatinumUpgrade", "mmm", "msm", "mmm"),
    BRONZELEAD(FluidityIronChestType.BRONZE, FluidityIronChestType.LEAD, "bronzeLeadUpgrade", "mGm", "GsG", "mGm"),
    BRONZESTEEL(FluidityIronChestType.BRONZE, FluidityIronChestType.STEEL, "bronzeSteelUpgrade", "mGm", "GsG", "mGm"),
    BRONZENICKEL(FluidityIronChestType.BRONZE, FluidityIronChestType.NICKEL, "bronzeNickelUpgrade", "mGm", "GsG", "mGm"),
    BRONZECOLDIRON(FluidityIronChestType.BRONZE, FluidityIronChestType.COLDIRON, "bronzeColdironUpgrade", "mGm", "GsG", "mGm"),
    CUPRONICKELINVAR(FluidityIronChestType.CUPRONICKEL, FluidityIronChestType.INVAR, "cupronickelInvarUpgrade", "mmm", "msm", "mmm"),
    CUPRONICKELELECTRUM(FluidityIronChestType.CUPRONICKEL, FluidityIronChestType.ELECTRUM, "cupronickelElectrumUpgrade", "mmm", "msm", "mmm"),
    CUPRONICKELPLATINUM(FluidityIronChestType.CUPRONICKEL, FluidityIronChestType.PLATINUM, "cupronickelPlatinumUpgrade", "mmm", "msm", "mmm"),
    CUPRONICKELLEAD(FluidityIronChestType.CUPRONICKEL, FluidityIronChestType.LEAD, "cupronickelLeadUpgrade", "mGm", "GsG", "mGm"),
    CUPRONICKELSTEEL(FluidityIronChestType.CUPRONICKEL, FluidityIronChestType.STEEL, "cupronickelSteelUpgrade", "mGm", "GsG", "mGm"),
    CUPRONICKELNICKEL(FluidityIronChestType.CUPRONICKEL, FluidityIronChestType.NICKEL, "cupronickelNickelUpgrade", "mGm", "GsG", "mGm"),
    CUPRONICKELCOLDIRON(FluidityIronChestType.CUPRONICKEL, FluidityIronChestType.COLDIRON, "cupronickelColdironUpgrade", "mGm", "GsG", "mGm"),
    TINLEAD(FluidityIronChestType.TIN, FluidityIronChestType.LEAD, "tinLeadUpgrade", "mmm", "msm", "mmm"),
    TINSTEEL(FluidityIronChestType.TIN, FluidityIronChestType.STEEL, "tinSteelUpgrade", "mmm", "msm", "mmm"),
    TINNICKEL(FluidityIronChestType.TIN, FluidityIronChestType.NICKEL, "tinNickelUpgrade", "mmm", "msm", "mmm"),
    TINCOLDIRON(FluidityIronChestType.TIN, FluidityIronChestType.COLDIRON, "tinColdironUpgrade", "mmm", "msm", "mmm"),
    TINBRONZE(FluidityIronChestType.TIN, FluidityIronChestType.BRONZE, "tinBronzeUpgrade", "mGm", "GsG", "mGm"),
    TINCUPRONICKEL(FluidityIronChestType.TIN, FluidityIronChestType.BRONZE, "tinCupronickelUpgrade", "mGm", "GsG", "mGm"),
    BRASSLEAD(FluidityIronChestType.BRASS, FluidityIronChestType.LEAD, "brassLeadUpgrade", "mmm", "msm", "mmm"),
    BRASSSTEEL(FluidityIronChestType.BRASS, FluidityIronChestType.STEEL, "brassSteelUpgrade", "mmm", "msm", "mmm"),
    BRASSNICKEL(FluidityIronChestType.BRASS, FluidityIronChestType.NICKEL, "brassNickelUpgrade", "mmm", "msm", "mmm"),
    BRASSCOLDIRON(FluidityIronChestType.BRASS, FluidityIronChestType.COLDIRON, "brassColdironUpgrade", "mmm", "msm", "mmm"),
    BRASSBRONZE(FluidityIronChestType.BRASS, FluidityIronChestType.BRONZE, "brassBronzeUpgrade", "mGm", "GsG", "mGm"),
    BRASSCUPRONICKEL(FluidityIronChestType.BRASS, FluidityIronChestType.CUPRONICKEL, "brassCupronickelUpgrade", "mGm", "GsG", "mGm"),
    LEADINVAR(FluidityIronChestType.LEAD, FluidityIronChestType.INVAR, "leadInvarUpgrade", "mGm", "GsG", "mGm"),
    LEADELECTRUM(FluidityIronChestType.LEAD, FluidityIronChestType.ELECTRUM, "leadElectrumUpgrade", "mGm", "GsG", "mGm"),
    LEADPLATINUM(FluidityIronChestType.LEAD, FluidityIronChestType.PLATINUM, "leadPlatinumUpgrade", "mGm", "GsG", "mGm"),
    STEELINVAR(FluidityIronChestType.STEEL, FluidityIronChestType.INVAR, "steelInvarUpgrade", "mGm", "GsG", "mGm"),
    STEELELECTRUM(FluidityIronChestType.STEEL, FluidityIronChestType.ELECTRUM, "steelElectrumUpgrade", "mGm", "GsG", "mGm"),
    STEELPLATINUM(FluidityIronChestType.STEEL, FluidityIronChestType.PLATINUM, "steelPlatinumUpgrade", "mGm", "GsG", "mGm"),
    NICKELINVAR(FluidityIronChestType.NICKEL, FluidityIronChestType.INVAR, "nickelInvarUpgrade", "mGm", "GsG", "mGm"),
    NICKELELECTRUM(FluidityIronChestType.NICKEL, FluidityIronChestType.ELECTRUM, "nickelElectrumUpgrade", "mGm", "GsG", "mGm"),
    NICKELPLATINUM(FluidityIronChestType.NICKEL, FluidityIronChestType.PLATINUM, "nickelPlatinumUpgrade", "mGm", "GsG", "mGm"),
    COLDIRONINVAR(FluidityIronChestType.COLDIRON, FluidityIronChestType.INVAR, "coldironInvarUpgrade", "mGm", "GsG", "mGm"),
    COLDIRONELECTRUM(FluidityIronChestType.COLDIRON, FluidityIronChestType.ELECTRUM, "coldironElectrumUpgrade", "mGm", "GsG", "mGm"),
    COLDIRONPLATINUM(FluidityIronChestType.COLDIRON, FluidityIronChestType.PLATINUM, "coldironPlatinumUpgrade", "mGm", "GsG", "mGm"),
    INVARMITHRIL(FluidityIronChestType.INVAR, FluidityIronChestType.MITHRIL, "invarMithrilUpgrade", "mmm", "msm", "mmm"),
    INVARAQUARIUM(FluidityIronChestType.INVAR, FluidityIronChestType.AQUARIUM, "invarAquariumUpgrade", "mmm", "msm", "mmm"),
    ELECTRUMMITHRIL(FluidityIronChestType.ELECTRUM, FluidityIronChestType.MITHRIL, "electrumMithrilUpgrade", "mmm", "msm", "mmm"),
    ELECTRUMAQUARIUM(FluidityIronChestType.ELECTRUM, FluidityIronChestType.AQUARIUM, "electrumAquariumUpgrade", "mmm", "msm", "mmm"),
    PLATINUMMITHRIL(FluidityIronChestType.PLATINUM, FluidityIronChestType.MITHRIL, "platinumMithrilUpgrade", "mmm", "msm", "mmm"),
    PLATINUMAQUARIUM(FluidityIronChestType.PLATINUM, FluidityIronChestType.AQUARIUM, "platinumAquariumUpgrade", "mmm", "msm", "mmm"),
    MITHRILADAMANTINE(FluidityIronChestType.MITHRIL, FluidityIronChestType.ADAMANTINE, "mithrilAdamantineUpgrade", "mmm", "msm", "mmm"),
    AQUARIUMADAMANTINE(FluidityIronChestType.AQUARIUM, FluidityIronChestType.ADAMANTINE, "aquariumAdamantineUpgrade", "mmm", "msm", "mmm"),
    MITHRILSTARSTEEL(FluidityIronChestType.MITHRIL, FluidityIronChestType.STARSTEEL, "mithrilStarsteelUpgrade", "mmm", "GsG", "mmm"),
    AQUARIUMSTARSTEEL(FluidityIronChestType.AQUARIUM, FluidityIronChestType.STARSTEEL, "aquariumStarsteelUpgrade", "mmm", "GsG", "mmm");

    private FluidityIronChestType source;
    private FluidityIronChestType target;
    public String sourcename;
    public String targetname;
    public String itemName;
    public FluidityItemChestChanger item;
    private String[] recipe;

    private FluidityChestChangerType(FluidityIronChestType source, FluidityIronChestType target, String itemName, String ... recipe) {
        this.source = source;
        this.target = target;
        this.sourcename = source.func_176610_l();
        this.targetname = target.func_176610_l();
        this.itemName = itemName;
        this.recipe = recipe;
    }

    public boolean canUpgrade(FluidityIronChestType from) {
        return from == this.source;
    }

    public int getTarget() {
        return this.target.ordinal();
    }

    public FluidityItemChestChanger buildItem() {
        this.item = new FluidityItemChestChanger(this);
        this.item.setRegistryName(this.itemName);
        GameRegistry.register((IForgeRegistryEntry)this.item);
        if (FMLCommonHandler.instance().getEffectiveSide() == Side.CLIENT) {
            Registry.registerRender(this.item, this.itemName);
        }
        FluidityIronChests.creativeQueue.add(this.item);
        return this.item;
    }

    public void addRecipes() {
        for (String sourceMat : this.source.getMatList()) {
            for (String targetMat : this.target.getMatList()) {
                Object targetMaterial = FluidityIronChestType.translateOreName(targetMat);
                Object sourceMaterial = FluidityIronChestType.translateOreName(sourceMat);
                FluidityIronChestType.addRecipe(new ItemStack((Item)this.item), this.recipe, Character.valueOf('m'), targetMaterial, Character.valueOf('s'), sourceMaterial, Character.valueOf('G'), Blocks.field_150359_w, Character.valueOf('O'), Blocks.field_150343_Z);
            }
        }
    }

    public static void buildItems() {
        for (FluidityChestChangerType type : FluidityChestChangerType.values()) {
            type.buildItem();
        }
    }

    public static void generateRecipes() {
        for (FluidityChestChangerType item : FluidityChestChangerType.values()) {
            item.addRecipes();
        }
    }
}

