/*
 * Decompiled with CFR 0.152.
 */
package the_fireplace.fluidity.enums;

import cpw.mods.ironchest.IronChestType;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.common.registry.IForgeRegistryEntry;
import net.minecraftforge.fml.relauncher.Side;
import the_fireplace.fluidity.enums.FluidityIronChestType;
import the_fireplace.fluidity.items.FluidityItemChestChanger;
import the_fireplace.fluidity.tools.Registry;

public enum FluidityIronChestChangerType {
    BRONZEGOLD(FluidityIronChestType.BRONZE, IronChestType.GOLD, "bronzeGoldUpgrade", "mmm", "msm", "mmm"),
    BRONZESILVER(FluidityIronChestType.BRONZE, IronChestType.SILVER, "bronzeSilverUpgrade", "mGm", "GsG", "mGm"),
    CUPRONICKELGOLD(FluidityIronChestType.CUPRONICKEL, IronChestType.GOLD, "cupronickelGoldUpgrade", "mmm", "msm", "mmm"),
    CUPRONICKELSILVER(FluidityIronChestType.CUPRONICKEL, IronChestType.SILVER, "cupronickelSilverUpgrade", "mGm", "GsG", "mGm"),
    TINSILVER(FluidityIronChestType.TIN, IronChestType.SILVER, "tinSilverUpgrade", "mmm", "msm", "mmm"),
    TINIRON(FluidityIronChestType.TIN, IronChestType.IRON, "tinIronUpgrade", "mGm", "GsG", "mGm"),
    BRASSSILVER(FluidityIronChestType.BRASS, IronChestType.SILVER, "brassSilverUpgrade", "mmm", "msm", "mmm"),
    BRASSIRON(FluidityIronChestType.BRASS, IronChestType.IRON, "brassIronUpgrade", "mGm", "GsG", "mGm"),
    LEADGOLD(FluidityIronChestType.LEAD, IronChestType.GOLD, "leadGoldUpgrade", "mGm", "GsG", "mGm"),
    STEELGOLD(FluidityIronChestType.STEEL, IronChestType.GOLD, "steelGoldUpgrade", "mGm", "GsG", "mGm"),
    NICKELGOLD(FluidityIronChestType.NICKEL, IronChestType.GOLD, "nickelGoldUpgrade", "mGm", "GsG", "mGm"),
    COLDIRONGOLD(FluidityIronChestType.COLDIRON, IronChestType.GOLD, "coldironGoldUpgrade", "mGm", "GsG", "mGm"),
    INVARDIAMOND(FluidityIronChestType.INVAR, IronChestType.DIAMOND, "invarDiamondUpgrade", "GGG", "msm", "GGG"),
    ELECTRUMDIAMOND(FluidityIronChestType.ELECTRUM, IronChestType.DIAMOND, "electrumDiamondUpgrade", "GGG", "msm", "GGG"),
    PLATINUMDIAMOND(FluidityIronChestType.PLATINUM, IronChestType.DIAMOND, "platinumDiamondUpgrade", "GGG", "msm", "GGG");

    private FluidityIronChestType source;
    private IronChestType target;
    public String sourcename;
    public String targetname;
    public String itemName;
    public FluidityItemChestChanger item;
    private String[] recipe;

    private FluidityIronChestChangerType(FluidityIronChestType source, IronChestType target, String itemName, String ... recipe) {
        this.source = source;
        this.target = target;
        this.sourcename = source.func_176610_l();
        this.targetname = target.func_176610_l();
        this.itemName = itemName;
        this.recipe = recipe;
    }

    public boolean canUpgrade(FluidityIronChestType from) {
        return from == this.source;
    }

    public int getTarget() {
        return this.target.ordinal();
    }

    public FluidityItemChestChanger buildItem() {
        this.item = new FluidityItemChestChanger(this);
        this.item.setRegistryName(this.itemName);
        GameRegistry.register((IForgeRegistryEntry)this.item);
        if (FMLCommonHandler.instance().getEffectiveSide() == Side.CLIENT) {
            Registry.registerRender(this.item, this.itemName);
        }
        return this.item;
    }

    public void addRecipes() {
        for (String sourceMat : this.source.getMatList()) {
            for (String targetMat : this.target.matList) {
                Object targetMaterial = FluidityIronChestType.translateOreName(targetMat);
                Object sourceMaterial = FluidityIronChestType.translateOreName(sourceMat);
                FluidityIronChestType.addRecipe(new ItemStack((Item)this.item), this.recipe, Character.valueOf('m'), targetMaterial, Character.valueOf('s'), sourceMaterial, Character.valueOf('G'), Blocks.field_150359_w, Character.valueOf('O'), Blocks.field_150343_Z);
            }
        }
    }

    public static void buildItems() {
        for (FluidityIronChestChangerType type : FluidityIronChestChangerType.values()) {
            type.buildItem();
        }
    }

    public static void generateRecipes() {
        for (FluidityIronChestChangerType item : FluidityIronChestChangerType.values()) {
            item.addRecipes();
        }
    }
}

