/*
 * Decompiled with CFR 0.152.
 */
package the_fireplace.fluidity.enums;

import cpw.mods.ironchest.IronChest;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.oredict.ShapedOreRecipe;
import the_fireplace.fluidity.blocks.BlockFluidityIronChest;
import the_fireplace.fluidity.container.ValidatingIronChestSlot;
import the_fireplace.fluidity.entity.tile.TileEntityAdamantineChest;
import the_fireplace.fluidity.entity.tile.TileEntityAquariumChest;
import the_fireplace.fluidity.entity.tile.TileEntityBrassChest;
import the_fireplace.fluidity.entity.tile.TileEntityColdIronChest;
import the_fireplace.fluidity.entity.tile.TileEntityCupronickelChest;
import the_fireplace.fluidity.entity.tile.TileEntityElectrumChest;
import the_fireplace.fluidity.entity.tile.TileEntityFluidityIronChest;
import the_fireplace.fluidity.entity.tile.TileEntityInvarChest;
import the_fireplace.fluidity.entity.tile.TileEntityLeadChest;
import the_fireplace.fluidity.entity.tile.TileEntityMithrilChest;
import the_fireplace.fluidity.entity.tile.TileEntityNickelChest;
import the_fireplace.fluidity.entity.tile.TileEntityPlatinumChest;
import the_fireplace.fluidity.entity.tile.TileEntityStarSteelChest;
import the_fireplace.fluidity.entity.tile.TileEntitySteelChest;
import the_fireplace.fluidity.entity.tile.TileEntityTinChest;

public enum FluidityIronChestType implements IStringSerializable
{
    BRONZE(54, 9, "Bronze Chest", "bronzechest.png", 0, Collections.singletonList("ingotBronze"), TileEntityFluidityIronChest.class, "mmmmCmmmm", "mGmGBGmGm", "mGmG3GmGm", "mGmG4GmGm"),
    INVAR(81, 9, "Invar Chest", "invarchest.png", 1, Collections.singletonList("ingotInvar"), TileEntityInvarChest.class, "mmmm0mmmm", "mmmmdmmmm", "mmmmImmmm", "mGmG5GmGm", "mGmG6GmGm", "mGmG7GmGm", "mGmG8GmGm"),
    ELECTRUM(81, 9, "Electrum Chest", "electrumchest.png", 2, Collections.singletonList("ingotElectrum"), TileEntityElectrumChest.class, "mmmm0mmmm", "mmmmdmmmm", "mmmmImmmm", "mGmG5GmGm", "mGmG6GmGm", "mGmG7GmGm", "mGmG8GmGm"),
    TIN(45, 9, "Tin Chest", "tinchest.png", 3, Collections.singletonList("ingotTin"), TileEntityTinChest.class, "mmmmCmmmm"),
    BRASS(45, 9, "Brass Chest", "brasschest.png", 4, Collections.singletonList("ingotBrass"), TileEntityBrassChest.class, "mmmmCmmmm"),
    LEAD(72, 9, "Lead Chest", "leadchest.png", 5, Collections.singletonList("ingotLead"), TileEntityLeadChest.class, "mmmmBmmmm", "mmmm3mmmm", "mmmm4mmmm", "mGmG0GmGm", "mGmGdGmGm", "mGmGIGmGm"),
    STEEL(72, 9, "Steel Chest", "steelchest.png", 6, Collections.singletonList("ingotSteel"), TileEntitySteelChest.class, "mmmmBmmmm", "mmmm3mmmm", "mmmm4mmmm", "mGmG0GmGm", "mGmGdGmGm", "mGmGIGmGm"),
    NICKEL(72, 9, "Nickel Chest", "nickelchest.png", 7, Collections.singletonList("ingotNickel"), TileEntityNickelChest.class, "mmmmBmmmm", "mmmm3mmmm", "mmmm4mmmm", "mGmG0GmGm", "mGmGdGmGm", "mGmGIGmGm"),
    COLDIRON(72, 9, "Cold-Iron Chest", "coldironchest.png", 8, Collections.singletonList("ingotColdiron"), TileEntityColdIronChest.class, "mmmmBmmmm", "mmmm3mmmm", "mmmm4mmmm", "mGmG0GmGm", "mGmGdGmGm", "mGmGIGmGm"),
    ADAMANTINE(117, 13, "Adamantine Chest", "adamantinechest.png", 9, Collections.singletonList("ingotAdamantine"), TileEntityAdamantineChest.class, "mmmmDmmmm", "mmmmammmm", "mmmmbmmmm"),
    AQUARIUM(108, 12, "Aquarium Chest", "aquariumchest.png", 10, Collections.singletonList("ingotAquarium"), TileEntityAquariumChest.class, "mmmmgmmmm", "mmmm1mmmm", "mmmm2mmmm", "mmmmemmmm"),
    MITHRIL(108, 12, "Mithril Chest", "mithrilchest.png", 11, Collections.singletonList("ingotMithril"), TileEntityMithrilChest.class, "mmmmgmmmm", "mmmm1mmmm", "mmmm2mmmm", "mmmmemmmm"),
    STARSTEEL(117, 13, "Star-Steel Chest", "starsteelchest.png", 12, Collections.singletonList("plateStarsteel"), TileEntityStarSteelChest.class, "mmmGDGmmm", "mmmGaGmmm", "mmmGbGmmm"),
    CUPRONICKEL(54, 9, "Cupronickel Chest", "cupronickelchest.png", 13, Collections.singletonList("ingotCupronickel"), TileEntityCupronickelChest.class, "mmmmCmmmm", "mGmGBGmGm", "mGmG3GmGm", "mGmG4GmGm"),
    PLATINUM(81, 9, "Platinum Chest", "platinumchest.png", 14, Collections.singletonList("ingotPlatinum"), TileEntityPlatinumChest.class, "mmmm0mmmm", "mmmmdmmmm", "mmmmImmmm", "mGmG5GmGm", "mGmG6GmGm", "mGmG7GmGm", "mGmG8GmGm");

    public static final FluidityIronChestType[] VALUES;
    public final int size;
    public final int rowLength;
    public String friendlyName;
    public final ResourceLocation modelTexture;
    private String breakTexture;
    private int textureRow;
    public Class<? extends TileEntityFluidityIronChest> clazz;
    private String[] recipes;
    private ArrayList<String> matList;
    private Item itemFilter;

    private FluidityIronChestType(int size, int rowLength, String friendlyName, String modelTexture, int textureRow, List<String> mats, Class<? extends TileEntityFluidityIronChest> clazz, String ... recipes) {
        this(size, rowLength, friendlyName, modelTexture, textureRow, mats, clazz, (Item)null, recipes);
    }

    private FluidityIronChestType(int size, int rowLength, String friendlyName, String modelTexture, int textureRow, List<String> mats, Class<? extends TileEntityFluidityIronChest> clazz, Item itemFilter, String ... recipes) {
        this.size = size;
        this.rowLength = rowLength;
        this.friendlyName = friendlyName;
        this.modelTexture = new ResourceLocation("fluidity", "textures/model/" + modelTexture);
        this.textureRow = textureRow;
        this.clazz = clazz;
        this.itemFilter = itemFilter;
        this.recipes = recipes;
        this.matList = new ArrayList();
        this.matList.addAll(mats);
    }

    public String func_176610_l() {
        return this.name().toLowerCase();
    }

    public ResourceLocation getModelTexture() {
        return this.modelTexture;
    }

    public int getTextureRow() {
        return this.textureRow;
    }

    public static TileEntityFluidityIronChest makeEntity(int metadata) {
        int chesttype = FluidityIronChestType.validateMeta(metadata);
        if (chesttype == metadata) {
            try {
                TileEntityFluidityIronChest te = FluidityIronChestType.values()[chesttype].clazz.newInstance();
                return te;
            }
            catch (InstantiationException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public static void registerBlocksAndRecipes(BlockFluidityIronChest blockResult) {
        for (FluidityIronChestType typ : FluidityIronChestType.values()) {
            FluidityIronChestType.generateRecipesForType(blockResult, typ);
        }
    }

    public static void generateRecipesForType(BlockFluidityIronChest blockResult, FluidityIronChestType type) {
        for (String recipe : type.recipes) {
            String[] recipeSplit = new String[]{recipe.substring(0, 3), recipe.substring(3, 6), recipe.substring(6, 9)};
            for (String mat : type.matList) {
                Object mainMaterial = FluidityIronChestType.translateOreName(mat);
                FluidityIronChestType.addRecipe(new ItemStack((Block)blockResult, 1, type.ordinal()), recipeSplit, Character.valueOf('m'), mainMaterial, Character.valueOf('G'), "blockGlass", Character.valueOf('C'), "chestWood", Character.valueOf('0'), new ItemStack((Block)blockResult, 1, 0), Character.valueOf('1'), new ItemStack((Block)blockResult, 1, 1), Character.valueOf('2'), new ItemStack((Block)blockResult, 1, 2), Character.valueOf('3'), new ItemStack((Block)blockResult, 1, 3), Character.valueOf('4'), new ItemStack((Block)blockResult, 1, 4), Character.valueOf('5'), new ItemStack((Block)blockResult, 1, 5), Character.valueOf('6'), new ItemStack((Block)blockResult, 1, 6), Character.valueOf('7'), new ItemStack((Block)blockResult, 1, 7), Character.valueOf('8'), new ItemStack((Block)blockResult, 1, 8), Character.valueOf('9'), new ItemStack((Block)blockResult, 1, 9), Character.valueOf('a'), new ItemStack((Block)blockResult, 1, 10), Character.valueOf('b'), new ItemStack((Block)blockResult, 1, 11), Character.valueOf('c'), new ItemStack((Block)blockResult, 1, 12), Character.valueOf('d'), new ItemStack((Block)blockResult, 1, 13), Character.valueOf('e'), new ItemStack((Block)blockResult, 1, 14), Character.valueOf('I'), new ItemStack((Block)IronChest.ironChestBlock, 1, 0), Character.valueOf('g'), new ItemStack((Block)IronChest.ironChestBlock, 1, 1), Character.valueOf('D'), new ItemStack((Block)IronChest.ironChestBlock, 1, 2), Character.valueOf('B'), new ItemStack((Block)IronChest.ironChestBlock, 1, 3), Character.valueOf('S'), new ItemStack((Block)IronChest.ironChestBlock, 1, 4));
            }
        }
    }

    public static Object translateOreName(String mat) {
        return mat;
    }

    public static void addRecipe(ItemStack is, Object ... parts) {
        ShapedOreRecipe oreRecipe = new ShapedOreRecipe(is, parts);
        GameRegistry.addRecipe((IRecipe)oreRecipe);
    }

    public int getRowCount() {
        return this.size / this.rowLength;
    }

    public int getRowLength() {
        return this.rowLength;
    }

    public List<String> getMatList() {
        return this.matList;
    }

    public static int validateMeta(int i) {
        if (i < FluidityIronChestType.values().length && FluidityIronChestType.values()[i].size > 0) {
            return i;
        }
        return 0;
    }

    public boolean isValidForCreativeMode() {
        return FluidityIronChestType.validateMeta(this.ordinal()) == this.ordinal();
    }

    public Slot makeSlot(IInventory chestInventory, int index, int x, int y) {
        return new ValidatingIronChestSlot(chestInventory, index, x, y, this);
    }

    public boolean acceptsStack(ItemStack itemstack) {
        return this.itemFilter == null || itemstack == null || itemstack.func_77973_b() == this.itemFilter;
    }

    public boolean isExplosionResistant() {
        return this == ADAMANTINE;
    }

    public String getParticleTexture() {
        if (this.breakTexture == null) {
            this.breakTexture = Loader.isModLoaded((String)"basemetals") ? "basemetals:blocks/" + this.func_176610_l() + "_block" : "fluidity:blocks/" + this.func_176610_l() + "_anvil_base";
        }
        return this.breakTexture;
    }

    static {
        VALUES = FluidityIronChestType.values();
    }
}

