/*
 * Decompiled with CFR 0.152.
 */
package the_fireplace.fluidity.enums;

import cpw.mods.ironchest.IronChestType;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.common.registry.IForgeRegistryEntry;
import net.minecraftforge.fml.relauncher.Side;
import the_fireplace.fluidity.enums.FluidityIronChestType;
import the_fireplace.fluidity.items.FluidityItemChestChanger;
import the_fireplace.fluidity.tools.Registry;

public enum IronFluidityChestChangerType {
    IRONINVAR(IronChestType.IRON, FluidityIronChestType.INVAR, "ironInvarUpgrade", "mmm", "msm", "mmm"),
    IRONELECTRUM(IronChestType.IRON, FluidityIronChestType.ELECTRUM, "ironElectrumUpgrade", "mmm", "msm", "mmm"),
    IRONPLATINUM(IronChestType.IRON, FluidityIronChestType.PLATINUM, "ironPlatinumUpgrade", "mmm", "msm", "mmm"),
    IRONLEAD(IronChestType.IRON, FluidityIronChestType.LEAD, "ironLeadUpgrade", "mGm", "GsG", "mGm"),
    IRONSTEEL(IronChestType.IRON, FluidityIronChestType.STEEL, "ironSteelUpgrade", "mGm", "GsG", "mGm"),
    IRONNICKEL(IronChestType.IRON, FluidityIronChestType.NICKEL, "ironNickelUpgrade", "mGm", "GsG", "mGm"),
    IRONCOLDIRON(IronChestType.IRON, FluidityIronChestType.COLDIRON, "ironColdironUpgrade", "mGm", "GsG", "mGm"),
    COPPERLEAD(IronChestType.COPPER, FluidityIronChestType.LEAD, "copperLeadUpgrade", "mmm", "msm", "mmm"),
    COPPERSTEEL(IronChestType.COPPER, FluidityIronChestType.STEEL, "copperSteelUpgrade", "mmm", "msm", "mmm"),
    COPPERNICKEL(IronChestType.COPPER, FluidityIronChestType.NICKEL, "copperNickelUpgrade", "mmm", "msm", "mmm"),
    COPPERCOLDIRON(IronChestType.COPPER, FluidityIronChestType.COLDIRON, "copperColdironUpgrade", "mmm", "msm", "mmm"),
    COPPERBRONZE(IronChestType.COPPER, FluidityIronChestType.BRONZE, "copperBronzeUpgrade", "mGm", "GsG", "mGm"),
    COPPERCUPRONICKEL(IronChestType.COPPER, FluidityIronChestType.CUPRONICKEL, "copperCupronickelUpgrade", "mGm", "GsG", "mGm"),
    WOODTIN(IronChestType.WOOD, FluidityIronChestType.TIN, "woodTinUpgrade", "mGm", "GsG", "mGm"),
    WOODBRASS(IronChestType.WOOD, FluidityIronChestType.BRASS, "woodBrassUpgrade", "mGm", "GsG", "mGm"),
    WOODBRONZE(IronChestType.WOOD, FluidityIronChestType.BRONZE, "woodBronzeUpgrade", "mmm", "msm", "mmm"),
    WOODCUPRONICKEL(IronChestType.WOOD, FluidityIronChestType.CUPRONICKEL, "woodCupronickelUpgrade", "mmm", "msm", "mmm"),
    SILVERINVAR(IronChestType.SILVER, FluidityIronChestType.INVAR, "silverInvarUpgrade", "mGm", "GsG", "mGm"),
    SILVERELECTRUM(IronChestType.SILVER, FluidityIronChestType.ELECTRUM, "silverElectrumUpgrade", "mGm", "GsG", "mGm"),
    SILVERPLATINUM(IronChestType.SILVER, FluidityIronChestType.PLATINUM, "silverPlatinumUpgrade", "mGm", "GsG", "mGm"),
    GOLDMITHRIL(IronChestType.GOLD, FluidityIronChestType.MITHRIL, "goldMithrilUpgrade", "mmm", "msm", "mmm"),
    GOLDAQUARIUM(IronChestType.GOLD, FluidityIronChestType.AQUARIUM, "goldAquariumUpgrade", "mmm", "msm", "mmm"),
    DIAMONDADAMANTINE(IronChestType.DIAMOND, FluidityIronChestType.ADAMANTINE, "diamondAdamantineUpgrade", "mmm", "msm", "mmm"),
    DIAMONDSTARSTEEL(IronChestType.DIAMOND, FluidityIronChestType.STARSTEEL, "diamondStarsteelUpgrade", "mmm", "GsG", "mmm");

    private IronChestType source;
    private FluidityIronChestType target;
    public String sourcename;
    public String targetname;
    public String itemName;
    public FluidityItemChestChanger item;
    private String[] recipe;

    private IronFluidityChestChangerType(IronChestType source, FluidityIronChestType target, String itemName, String ... recipe) {
        this.source = source;
        this.target = target;
        this.sourcename = source.func_176610_l();
        this.targetname = target.func_176610_l();
        this.itemName = itemName;
        this.recipe = recipe;
    }

    public boolean canUpgrade(IronChestType from) {
        return from == this.source;
    }

    public int getTarget() {
        return this.target.ordinal();
    }

    public FluidityItemChestChanger buildItem() {
        this.item = new FluidityItemChestChanger(this);
        this.item.setRegistryName(this.itemName);
        GameRegistry.register((IForgeRegistryEntry)this.item);
        if (FMLCommonHandler.instance().getEffectiveSide() == Side.CLIENT) {
            Registry.registerRender(this.item, this.itemName);
        }
        return this.item;
    }

    public void addRecipes() {
        for (String sourceMat : this.source.matList) {
            for (String targetMat : this.target.getMatList()) {
                Object targetMaterial = FluidityIronChestType.translateOreName(targetMat);
                Object sourceMaterial = FluidityIronChestType.translateOreName(sourceMat);
                FluidityIronChestType.addRecipe(new ItemStack((Item)this.item), this.recipe, Character.valueOf('m'), targetMaterial, Character.valueOf('s'), sourceMaterial, Character.valueOf('G'), Blocks.field_150359_w, Character.valueOf('O'), Blocks.field_150343_Z);
            }
        }
    }

    public static void buildItems() {
        for (IronFluidityChestChangerType type : IronFluidityChestChangerType.values()) {
            type.buildItem();
        }
    }

    public static void generateRecipes() {
        for (IronFluidityChestChangerType item : IronFluidityChestChangerType.values()) {
            item.addRecipes();
        }
    }

    public IronChestType getSource() {
        return this.source;
    }
}

