/*
 * Decompiled with CFR 0.152.
 */
package the_fireplace.fluidity.items;

import cpw.mods.ironchest.IronChest;
import cpw.mods.ironchest.IronChestType;
import cpw.mods.ironchest.TileEntityCopperChest;
import cpw.mods.ironchest.TileEntityCrystalChest;
import cpw.mods.ironchest.TileEntityDiamondChest;
import cpw.mods.ironchest.TileEntityDirtChest;
import cpw.mods.ironchest.TileEntityGoldChest;
import cpw.mods.ironchest.TileEntityIronChest;
import cpw.mods.ironchest.TileEntityObsidianChest;
import cpw.mods.ironchest.TileEntitySilverChest;
import net.minecraft.block.BlockChest;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.World;
import the_fireplace.fluidity.compat.FluidityIronChests;
import the_fireplace.fluidity.entity.tile.TileEntityFluidityIronChest;
import the_fireplace.fluidity.enums.FluidityChestChangerType;
import the_fireplace.fluidity.enums.FluidityIronChestChangerType;
import the_fireplace.fluidity.enums.FluidityIronChestType;
import the_fireplace.fluidity.enums.IronFluidityChestChangerType;

public class FluidityItemChestChanger
extends Item {
    private byte useType;
    private FluidityChestChangerType type1;
    private FluidityIronChestChangerType type2;
    private IronFluidityChestChangerType type3;

    public FluidityItemChestChanger(FluidityChestChangerType type) {
        this.type1 = type;
        this.useType = 0;
        this.func_77625_d(1);
        this.func_77655_b("fluidity:" + type.name());
    }

    public FluidityItemChestChanger(FluidityIronChestChangerType type) {
        this.type2 = type;
        this.useType = 1;
        this.func_77625_d(1);
        this.func_77655_b("fluidity:" + type.name());
    }

    public FluidityItemChestChanger(IronFluidityChestChangerType type) {
        this.type3 = type;
        this.useType = (byte)2;
        this.func_77625_d(1);
        this.func_77655_b("fluidity:" + type.name());
    }

    public String func_77653_i(ItemStack stack) {
        return String.format(I18n.func_74838_a((String)"fluidity.upgrade"), I18n.func_74838_a((String)("fluidity." + this.getSourceName().toLowerCase())), I18n.func_74838_a((String)("fluidity." + this.getTargetName().toLowerCase())));
    }

    public EnumActionResult onItemUseFirst(ItemStack stack, EntityPlayer player, World world, BlockPos pos, EnumFacing side, float hitX, float hitY, float hitZ, EnumHand hand) {
        if (world.field_72995_K) {
            return EnumActionResult.PASS;
        }
        switch (this.useType) {
            case 0: {
                if (world.func_180495_p(pos) != FluidityIronChests.fluidityChest.func_176203_a(FluidityIronChestType.valueOf(this.type1.sourcename.toUpperCase()).ordinal())) {
                    return EnumActionResult.PASS;
                }
                TileEntity te = world.func_175625_s(pos);
                TileEntityFluidityIronChest newchest = new TileEntityFluidityIronChest();
                ItemStack[] chestContents = new ItemStack[27];
                if (te != null && te instanceof TileEntityFluidityIronChest) {
                    chestContents = ((TileEntityFluidityIronChest)te).chestContents;
                    newchest = FluidityIronChestType.makeEntity(this.getTargetChestOrdinal());
                    if (newchest == null) {
                        return EnumActionResult.PASS;
                    }
                }
                te.func_145836_u();
                world.func_175713_t(pos);
                world.func_175698_g(pos);
                world.func_175690_a(pos, (TileEntity)newchest);
                IBlockState state = FluidityIronChests.fluidityChest.func_176203_a(newchest.getType().ordinal());
                world.func_180501_a(pos, state, 3);
                world.func_184138_a(pos, state, state, 3);
                TileEntity te2 = world.func_175625_s(pos);
                if (te2 instanceof TileEntityFluidityIronChest) {
                    ((TileEntityFluidityIronChest)te2).setContents(chestContents);
                }
                stack.field_77994_a = player.field_71075_bZ.field_75098_d ? stack.field_77994_a : stack.field_77994_a - 1;
                return EnumActionResult.SUCCESS;
            }
            case 1: {
                if (world.func_180495_p(pos) != FluidityIronChests.fluidityChest.func_176203_a(FluidityIronChestType.valueOf(this.type2.sourcename.toUpperCase()).ordinal())) {
                    return EnumActionResult.PASS;
                }
                TileEntity te = world.func_175625_s(pos);
                TileEntityIronChest newchest = new TileEntityIronChest();
                ItemStack[] chestContents = new ItemStack[27];
                if (te != null && te instanceof TileEntityFluidityIronChest) {
                    chestContents = ((TileEntityFluidityIronChest)te).chestContents;
                    newchest = this.makeEntity(IronChestType.VALUES[this.getTargetChestOrdinal()]);
                    if (newchest == null) {
                        return EnumActionResult.PASS;
                    }
                }
                te.func_145836_u();
                world.func_175713_t(pos);
                world.func_175698_g(pos);
                world.func_175690_a(pos, (TileEntity)newchest);
                IBlockState state = IronChest.ironChestBlock.func_176203_a(this.getTargetChestOrdinal());
                world.func_180501_a(pos, state, 3);
                world.func_184138_a(pos, state, state, 3);
                TileEntity te2 = world.func_175625_s(pos);
                if (te2 instanceof TileEntityIronChest) {
                    ((TileEntityIronChest)te2).setContents(chestContents);
                }
                stack.field_77994_a = player.field_71075_bZ.field_75098_d ? stack.field_77994_a : stack.field_77994_a - 1;
                return EnumActionResult.SUCCESS;
            }
            case 2: {
                if (this.type3.getSource() == IronChestType.WOOD ? !(world.func_180495_p(pos).func_177230_c() instanceof BlockChest) : world.func_180495_p(pos) != IronChest.ironChestBlock.func_176203_a(IronChestType.valueOf((String)this.type3.sourcename.toUpperCase()).ordinal())) {
                    return EnumActionResult.PASS;
                }
                TileEntity te = world.func_175625_s(pos);
                TileEntityFluidityIronChest newchest = new TileEntityFluidityIronChest();
                ItemStack[] chestContents = new ItemStack[27];
                if (te != null) {
                    if (te instanceof TileEntityIronChest) {
                        chestContents = ((TileEntityIronChest)te).chestContents;
                        newchest = FluidityIronChestType.makeEntity(this.getTargetChestOrdinal());
                        if (newchest == null) {
                            return EnumActionResult.PASS;
                        }
                    } else if (te instanceof TileEntityChest) {
                        if (((TileEntityChest)te).field_145987_o > 0) {
                            return EnumActionResult.PASS;
                        }
                        if (!this.type3.canUpgrade(IronChestType.WOOD)) {
                            return EnumActionResult.PASS;
                        }
                        chestContents = new ItemStack[((TileEntityChest)te).func_70302_i_()];
                        for (int i = 0; i < chestContents.length; ++i) {
                            chestContents[i] = ((TileEntityChest)te).func_70301_a(i);
                        }
                        newchest = FluidityIronChestType.makeEntity(this.getTargetChestOrdinal());
                    }
                }
                te.func_145836_u();
                if (te instanceof TileEntityChest) {
                    ((TileEntityChest)te).func_145979_i();
                }
                world.func_175713_t(pos);
                world.func_175698_g(pos);
                world.func_175690_a(pos, (TileEntity)newchest);
                IBlockState state = FluidityIronChests.fluidityChest.func_176203_a(newchest.getType().ordinal());
                world.func_180501_a(pos, state, 3);
                world.func_184138_a(pos, state, state, 3);
                TileEntity te2 = world.func_175625_s(pos);
                if (te2 instanceof TileEntityFluidityIronChest) {
                    ((TileEntityFluidityIronChest)te2).setContents(chestContents);
                }
                stack.field_77994_a = player.field_71075_bZ.field_75098_d ? stack.field_77994_a : stack.field_77994_a - 1;
                return EnumActionResult.SUCCESS;
            }
        }
        return EnumActionResult.FAIL;
    }

    public int getTargetChestOrdinal() {
        switch (this.useType) {
            case 0: {
                return this.type1.getTarget();
            }
            case 1: {
                return this.type2.getTarget();
            }
            case 2: {
                return this.type3.getTarget();
            }
        }
        System.out.println("Error with chest changer use type");
        return 0;
    }

    public String getSourceName() {
        switch (this.useType) {
            case 0: {
                return this.type1.sourcename;
            }
            case 1: {
                return this.type2.sourcename;
            }
            case 2: {
                return this.type3.sourcename;
            }
        }
        System.out.println("Error with chest changer use type");
        return null;
    }

    public String getTargetName() {
        switch (this.useType) {
            case 0: {
                return this.type1.targetname;
            }
            case 1: {
                return this.type2.targetname;
            }
            case 2: {
                return this.type3.targetname;
            }
        }
        System.out.println("Error with chest changer use type");
        return null;
    }

    public TileEntityIronChest makeEntity(IronChestType entityType) {
        switch (entityType) {
            case DIRTCHEST9000: {
                return new TileEntityDirtChest();
            }
            case OBSIDIAN: {
                return new TileEntityObsidianChest();
            }
            case IRON: {
                return new TileEntityIronChest();
            }
            case GOLD: {
                return new TileEntityGoldChest();
            }
            case DIAMOND: {
                return new TileEntityDiamondChest();
            }
            case COPPER: {
                return new TileEntityCopperChest();
            }
            case SILVER: {
                return new TileEntitySilverChest();
            }
            case CRYSTAL: {
                return new TileEntityCrystalChest();
            }
        }
        return null;
    }
}

