/*
 * Decompiled with CFR 0.152.
 */
package the_fireplace.fluidity.particle;

import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.IParticleFactory;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.renderer.VertexBuffer;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import the_fireplace.fluidity.blocks.BlockFluidityIronChest;
import the_fireplace.fluidity.enums.FluidityIronChestType;

@SideOnly(value=Side.CLIENT)
public class ParticleIronChest
extends Particle {
    private IBlockState sourceState;
    private BlockPos sourcePos;

    public ParticleIronChest(World worldIn, double xCoordIn, double yCoordIn, double zCoordIn, double xSpeedIn, double ySpeedIn, double zSpeedIn, IBlockState state) {
        super(worldIn, xCoordIn, yCoordIn, zCoordIn, xSpeedIn, ySpeedIn, zSpeedIn);
        this.sourceState = state;
        if (state.func_177228_b().containsKey(BlockFluidityIronChest.VARIANT_PROP)) {
            this.func_187117_a(Minecraft.func_71410_x().func_147117_R().getTextureExtry(FluidityIronChestType.VALUES[((FluidityIronChestType)((Object)state.func_177229_b(BlockFluidityIronChest.VARIANT_PROP))).ordinal()].getParticleTexture()));
        }
        this.field_70545_g = state.func_177230_c().field_149763_I;
        this.field_70551_j = 0.6f;
        this.field_70553_i = 0.6f;
        this.field_70552_h = 0.6f;
        this.field_70544_f /= 2.0f;
    }

    public ParticleIronChest setBlockPos(BlockPos pos) {
        this.sourcePos = pos;
        if (this.sourceState.func_177230_c() == Blocks.field_150349_c) {
            return this;
        }
        this.multiplyColor(pos);
        return this;
    }

    public ParticleIronChest init() {
        this.sourcePos = new BlockPos(this.field_187126_f, this.field_187127_g, this.field_187128_h);
        Block block = this.sourceState.func_177230_c();
        if (block == Blocks.field_150349_c) {
            return this;
        }
        this.multiplyColor(null);
        return this;
    }

    protected void multiplyColor(@Nullable BlockPos p_187154_1_) {
        int i = Minecraft.func_71410_x().func_184125_al().func_186724_a(this.sourceState, (IBlockAccess)this.field_187122_b, p_187154_1_, 0);
        this.field_70552_h *= (float)(i >> 16 & 0xFF) / 255.0f;
        this.field_70553_i *= (float)(i >> 8 & 0xFF) / 255.0f;
        this.field_70551_j *= (float)(i & 0xFF) / 255.0f;
    }

    public int func_70537_b() {
        return 1;
    }

    public void func_180434_a(VertexBuffer worldRendererIn, Entity entityIn, float partialTicks, float rotationX, float rotationZ, float rotationYZ, float rotationXY, float rotationXZ) {
        float f = ((float)this.field_94054_b + this.field_70548_b / 4.0f) / 16.0f;
        float f1 = f + 0.015609375f;
        float f2 = ((float)this.field_94055_c + this.field_70549_c / 4.0f) / 16.0f;
        float f3 = f2 + 0.015609375f;
        float f4 = 0.1f * this.field_70544_f;
        if (this.field_187119_C != null) {
            f = this.field_187119_C.func_94214_a((double)(this.field_70548_b / 4.0f * 16.0f));
            f1 = this.field_187119_C.func_94214_a((double)((this.field_70548_b + 1.0f) / 4.0f * 16.0f));
            f2 = this.field_187119_C.func_94207_b((double)(this.field_70549_c / 4.0f * 16.0f));
            f3 = this.field_187119_C.func_94207_b((double)((this.field_70549_c + 1.0f) / 4.0f * 16.0f));
        }
        float f5 = (float)(this.field_187123_c + (this.field_187126_f - this.field_187123_c) * (double)partialTicks - field_70556_an);
        float f6 = (float)(this.field_187124_d + (this.field_187127_g - this.field_187124_d) * (double)partialTicks - field_70554_ao);
        float f7 = (float)(this.field_187125_e + (this.field_187128_h - this.field_187125_e) * (double)partialTicks - field_70555_ap);
        int i = this.func_189214_a(partialTicks);
        int j = i >> 16 & 0xFFFF;
        int k = i & 0xFFFF;
        worldRendererIn.func_181662_b((double)(f5 - rotationX * f4 - rotationXY * f4), (double)(f6 - rotationZ * f4), (double)(f7 - rotationYZ * f4 - rotationXZ * f4)).func_187315_a((double)f, (double)f3).func_181666_a(this.field_70552_h, this.field_70553_i, this.field_70551_j, 1.0f).func_187314_a(j, k).func_181675_d();
        worldRendererIn.func_181662_b((double)(f5 - rotationX * f4 + rotationXY * f4), (double)(f6 + rotationZ * f4), (double)(f7 - rotationYZ * f4 + rotationXZ * f4)).func_187315_a((double)f, (double)f2).func_181666_a(this.field_70552_h, this.field_70553_i, this.field_70551_j, 1.0f).func_187314_a(j, k).func_181675_d();
        worldRendererIn.func_181662_b((double)(f5 + rotationX * f4 + rotationXY * f4), (double)(f6 + rotationZ * f4), (double)(f7 + rotationYZ * f4 + rotationXZ * f4)).func_187315_a((double)f1, (double)f2).func_181666_a(this.field_70552_h, this.field_70553_i, this.field_70551_j, 1.0f).func_187314_a(j, k).func_181675_d();
        worldRendererIn.func_181662_b((double)(f5 + rotationX * f4 - rotationXY * f4), (double)(f6 - rotationZ * f4), (double)(f7 + rotationYZ * f4 - rotationXZ * f4)).func_187315_a((double)f1, (double)f3).func_181666_a(this.field_70552_h, this.field_70553_i, this.field_70551_j, 1.0f).func_187314_a(j, k).func_181675_d();
    }

    public int func_189214_a(float p_189214_1_) {
        int i = super.func_189214_a(p_189214_1_);
        int j = 0;
        if (this.field_187122_b.func_175667_e(this.sourcePos)) {
            j = this.field_187122_b.func_175626_b(this.sourcePos, 0);
        }
        return i == 0 ? j : i;
    }

    @SideOnly(value=Side.CLIENT)
    public static class Factory
    implements IParticleFactory {
        public Particle func_178902_a(int particleID, World worldIn, double xCoordIn, double yCoordIn, double zCoordIn, double xSpeedIn, double ySpeedIn, double zSpeedIn, int ... p_178902_15_) {
            return new ParticleIronChest(worldIn, xCoordIn, yCoordIn, zCoordIn, xSpeedIn, ySpeedIn, zSpeedIn, Block.func_176220_d((int)p_178902_15_[0])).init();
        }
    }
}

