/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.enderutilities.block;

import fi.dy.masa.enderutilities.block.base.BlockEnderUtilities;
import fi.dy.masa.enderutilities.block.base.BlockEnderUtilitiesTileEntity;
import fi.dy.masa.enderutilities.effects.Effects;
import fi.dy.masa.enderutilities.setup.EnderUtilitiesBlocks;
import fi.dy.masa.enderutilities.tileentity.TileEntityEnderUtilities;
import fi.dy.masa.enderutilities.tileentity.TileEntityPortal;
import fi.dy.masa.enderutilities.util.nbt.OwnerData;
import fi.dy.masa.enderutilities.util.nbt.TargetData;
import fi.dy.masa.enderutilities.util.teleport.TeleportEntity;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockEnderUtilitiesPortal
extends BlockEnderUtilitiesTileEntity {
    protected static final AxisAlignedBB PORTAL_BOUNDS_NS = new AxisAlignedBB(0.0, 0.0, 0.375, 1.0, 1.0, 0.625);
    protected static final AxisAlignedBB PORTAL_BOUNDS_WE = new AxisAlignedBB(0.375, 0.0, 0.0, 0.625, 1.0, 1.0);
    protected static final AxisAlignedBB PORTAL_BOUNDS_UD = new AxisAlignedBB(0.0, 0.375, 0.0, 1.0, 0.625, 1.0);

    public BlockEnderUtilitiesPortal(String name, float hardness, float resistance, int harvestLevel, Material material) {
        super(name, hardness, resistance, harvestLevel, material);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)FACING, (Comparable)BlockEnderUtilities.DEFAULT_FACING));
        this.func_149672_a(SoundType.field_185853_f);
        this.func_149722_s();
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{FACING});
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.func_82600_a((int)(meta & 7)));
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176745_a();
    }

    @Override
    public IBlockState func_176221_a(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        return state;
    }

    @Override
    protected TileEntityEnderUtilities createTileEntityInstance(World worldIn, IBlockState state) {
        return new TileEntityPortal();
    }

    public ItemStack func_185473_a(World worldIn, BlockPos pos, IBlockState state) {
        return null;
    }

    public AxisAlignedBB func_180646_a(IBlockState state, World worldIn, BlockPos pos) {
        return field_185506_k;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess blockAccess, BlockPos pos) {
        switch (((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176740_k()) {
            case X: {
                return PORTAL_BOUNDS_WE;
            }
            case Z: {
                return PORTAL_BOUNDS_NS;
            }
        }
        return PORTAL_BOUNDS_UD;
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.TRANSLUCENT;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_176225_a(IBlockState state, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
        EnumFacing facing = (EnumFacing)state.func_177229_b((IProperty)FACING);
        return side == facing || side == facing.func_176734_d();
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    @Override
    protected String[] generateUnlocalizedNames() {
        return new String[]{"portal"};
    }

    public boolean func_149740_M(IBlockState state) {
        return false;
    }

    public void func_180655_c(IBlockState state, World worldIn, BlockPos pos, Random rand) {
        Effects.spawnParticlesAround(worldIn, EnumParticleTypes.PORTAL, pos, 2, rand);
    }

    public void func_180634_a(World worldIn, BlockPos pos, IBlockState state, Entity entityIn) {
        if (!(entityIn instanceof EntityPlayer)) {
            this.teleportEntity(worldIn, pos, state, entityIn);
        }
    }

    public void teleportEntity(World worldIn, BlockPos pos, IBlockState state, Entity entityIn) {
        OwnerData owner;
        TargetData target;
        if (worldIn.field_72995_K) {
            return;
        }
        TileEntity te = worldIn.func_175625_s(pos);
        if (te instanceof TileEntityPortal && (target = ((TileEntityPortal)te).getDestination()) != null && ((owner = ((TileEntityPortal)te).getOwner()) == null || owner.canAccess(entityIn))) {
            TeleportEntity.teleportEntityUsingTarget(entityIn, target, true, true);
        }
    }

    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block blockIn) {
        EnumFacing facing = (EnumFacing)state.func_177229_b((IProperty)FACING);
        for (EnumFacing side : EnumFacing.values()) {
            Block block;
            if (side.func_176740_k() == facing.func_176740_k() || (block = worldIn.func_180495_p(pos.func_177972_a(side)).func_177230_c()) == this || block == EnderUtilitiesBlocks.blockPortalFrame) continue;
            worldIn.func_175698_g(pos);
            break;
        }
    }
}

