/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.enderutilities.block;

import fi.dy.masa.enderutilities.block.base.BlockEnderUtilities;
import fi.dy.masa.enderutilities.block.base.BlockEnderUtilitiesInventory;
import fi.dy.masa.enderutilities.tileentity.ITieredStorage;
import fi.dy.masa.enderutilities.tileentity.TileEntityEnderUtilities;
import fi.dy.masa.enderutilities.tileentity.TileEntityHandyChest;
import fi.dy.masa.enderutilities.tileentity.TileEntityMemoryChest;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockStorage
extends BlockEnderUtilitiesInventory {
    protected static final AxisAlignedBB SINGLE_CHEST_AABB = new AxisAlignedBB(0.0625, 0.0, 0.0625, 0.9375, 0.875, 0.9375);
    public static final PropertyEnum<EnumStorageType> TYPE = PropertyEnum.func_177709_a((String)"type", EnumStorageType.class);

    public BlockStorage(String name, float hardness, float resistance, int harvestLevel, Material material) {
        super(name, hardness, resistance, harvestLevel, material);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a(TYPE, (Comparable)((Object)EnumStorageType.MEMORY_CHEST_0)).func_177226_a((IProperty)FACING, (Comparable)BlockEnderUtilities.DEFAULT_FACING));
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{TYPE, FACING});
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return SINGLE_CHEST_AABB;
    }

    @Override
    protected String[] generateUnlocalizedNames() {
        return new String[]{"memorychest_0", "memorychest_1", "memorychest_2", "handychest_0", "handychest_1", "handychest_2", "handychest_3"};
    }

    @Override
    protected TileEntityEnderUtilities createTileEntityInstance(World worldIn, IBlockState state) {
        switch ((EnumStorageType)((Object)state.func_177229_b(TYPE))) {
            case MEMORY_CHEST_0: {
                return new TileEntityMemoryChest();
            }
            case MEMORY_CHEST_1: {
                return new TileEntityMemoryChest();
            }
            case MEMORY_CHEST_2: {
                return new TileEntityMemoryChest();
            }
            case HANDY_CHEST_0: {
                return new TileEntityHandyChest();
            }
            case HANDY_CHEST_1: {
                return new TileEntityHandyChest();
            }
            case HANDY_CHEST_2: {
                return new TileEntityHandyChest();
            }
            case HANDY_CHEST_3: {
                return new TileEntityHandyChest();
            }
        }
        return new TileEntityMemoryChest();
    }

    public void func_176213_c(World worldIn, BlockPos pos, IBlockState state) {
        if (worldIn.field_72995_K) {
            return;
        }
        TileEntity te = worldIn.func_175625_s(pos);
        if (te instanceof ITieredStorage) {
            ((ITieredStorage)te).setStorageTier(((EnumStorageType)((Object)state.func_177229_b(TYPE))).getTier());
        }
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(TYPE, (Comparable)((Object)EnumStorageType.fromMeta(meta)));
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumStorageType)((Object)state.func_177229_b(TYPE))).getMeta();
    }

    public void func_149666_a(Item item, CreativeTabs tab, List<ItemStack> list) {
        for (int meta = 0; meta < EnumStorageType.values().length; ++meta) {
            list.add(new ItemStack(item, 1, meta));
        }
    }

    public static enum EnumStorageType implements IStringSerializable
    {
        MEMORY_CHEST_0(0, "memorychest"),
        MEMORY_CHEST_1(1, "memorychest"),
        MEMORY_CHEST_2(2, "memorychest"),
        HANDY_CHEST_0(0, "handychest"),
        HANDY_CHEST_1(1, "handychest"),
        HANDY_CHEST_2(2, "handychest"),
        HANDY_CHEST_3(3, "handychest");

        private final int tier;
        private final String nameBase;

        private EnumStorageType(int tier, String nameBase) {
            this.tier = tier;
            this.nameBase = nameBase;
        }

        public String toString() {
            return this.nameBase + "_" + this.tier;
        }

        public String func_176610_l() {
            return this.toString();
        }

        public int getTier() {
            return this.tier;
        }

        public int getMeta() {
            return this.ordinal();
        }

        public static EnumStorageType fromMeta(int meta) {
            return EnumStorageType.values()[meta % EnumStorageType.values().length];
        }
    }
}

