/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.enderutilities.client.renderer.item;

import fi.dy.masa.enderutilities.item.ItemBuildersWand;
import fi.dy.masa.enderutilities.setup.Configs;
import fi.dy.masa.enderutilities.setup.EnderUtilitiesItems;
import fi.dy.masa.enderutilities.util.BlockInfo;
import fi.dy.masa.enderutilities.util.BlockPosEU;
import fi.dy.masa.enderutilities.util.BlockPosStateDist;
import fi.dy.masa.enderutilities.util.EntityUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderGlobal;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.VertexBuffer;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.Mirror;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.client.model.pipeline.LightUtil;
import org.lwjgl.opengl.GL11;

public class BuildersWandRenderer {
    protected final Minecraft mc = Minecraft.func_71410_x();
    protected final List<BlockPosStateDist> positions = new ArrayList<BlockPosStateDist>();
    protected float partialTicksLast;
    protected BlockPosEU posStartLast;

    public void renderSelectedArea(World world, EntityPlayer usingPlayer, ItemStack stack, EntityPlayer clientPlayer, float partialTicks) {
        BlockPosEU posEnd;
        ItemBuildersWand wand = (ItemBuildersWand)stack.func_77973_b();
        BlockPosEU posStart = wand.getPosition(stack, true);
        ItemBuildersWand.Mode mode = ItemBuildersWand.Mode.getMode(stack);
        if (posStart == null) {
            RayTraceResult rayTraceResult = EntityUtils.getRayTraceFromPlayer(world, usingPlayer, false);
            if (rayTraceResult == null || rayTraceResult.field_72313_a != RayTraceResult.Type.BLOCK) {
                return;
            }
            if (usingPlayer.func_70093_af() && rayTraceResult.field_178784_b == EnumFacing.UP && mode != ItemBuildersWand.Mode.REPLACE) {
                return;
            }
            posStart = mode == ItemBuildersWand.Mode.REPLACE ? new BlockPosEU(rayTraceResult.func_178782_a(), usingPlayer.field_71093_bK, rayTraceResult.field_178784_b) : new BlockPosEU(rayTraceResult.func_178782_a().func_177972_a(rayTraceResult.field_178784_b), usingPlayer.field_71093_bK, rayTraceResult.field_178784_b);
        }
        if (posStart == null || usingPlayer.field_71093_bK != posStart.dimension) {
            return;
        }
        BlockPosEU blockPosEU = posEnd = mode.isAreaMode() || mode == ItemBuildersWand.Mode.WALLS || mode == ItemBuildersWand.Mode.CUBE ? wand.getPosition(stack, false) : null;
        if (partialTicks < this.partialTicksLast || !posStart.equals(this.posStartLast)) {
            this.positions.clear();
            if (mode == ItemBuildersWand.Mode.CUBE || mode == ItemBuildersWand.Mode.WALLS) {
                wand.getBlockPositionsWalls(stack, world, this.positions, posStart, posEnd);
            } else if (!mode.isAreaMode()) {
                wand.getBlockPositions(stack, world, usingPlayer, this.positions, posStart);
            }
        }
        this.posStartLast = posStart;
        GlStateManager.func_179132_a((boolean)false);
        GlStateManager.func_179140_f();
        GlStateManager.func_179129_p();
        GlStateManager.func_179094_E();
        boolean renderGhostBlocks = wand.getRenderGhostBlocks(stack, mode);
        if (renderGhostBlocks) {
            this.renderGhostBlocks(clientPlayer, partialTicks);
        }
        GlStateManager.func_179090_x();
        if (!renderGhostBlocks && !mode.isAreaMode()) {
            this.renderBlockOutlines(mode, clientPlayer, posStart, posEnd, partialTicks);
        }
        this.renderStartAndEndPositions(mode, clientPlayer, posStart, posEnd, partialTicks);
        if (mode == ItemBuildersWand.Mode.MOVE_DST) {
            posStart = wand.getPosition(stack, ItemBuildersWand.Mode.MOVE_SRC, true);
            posEnd = wand.getPosition(stack, ItemBuildersWand.Mode.MOVE_SRC, false);
            this.renderStartAndEndPositions(ItemBuildersWand.Mode.MOVE_SRC, clientPlayer, posStart, posEnd, partialTicks, 255, 85, 85);
        }
        GlStateManager.func_179121_F();
        GlStateManager.func_179098_w();
        GlStateManager.func_179089_o();
        GlStateManager.func_179132_a((boolean)true);
        this.partialTicksLast = partialTicks;
    }

    private void renderBlockOutlines(ItemBuildersWand.Mode mode, EntityPlayer player, BlockPosEU posStart, BlockPosEU posEnd, float partialTicks) {
        GL11.glLineWidth((float)2.0f);
        float expand = mode == ItemBuildersWand.Mode.REPLACE ? 0.001f : 0.0f;
        for (int i = 0; i < this.positions.size(); ++i) {
            BlockPosEU pos = this.positions.get(i);
            if (pos.equals(posStart) || pos.equals(posEnd)) continue;
            AxisAlignedBB aabb = BuildersWandRenderer.makeBlockBoundingBox(pos.posX, pos.posY, pos.posZ, expand, partialTicks, player);
            RenderGlobal.func_189697_a((AxisAlignedBB)aabb, (float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
    }

    private void renderStartAndEndPositions(ItemBuildersWand.Mode mode, EntityPlayer player, BlockPosEU posStart, BlockPosEU posEnd, float partialTicks) {
        this.renderStartAndEndPositions(mode, player, posStart, posEnd, partialTicks, 255, 255, 255);
    }

    private void renderStartAndEndPositions(ItemBuildersWand.Mode mode, EntityPlayer player, BlockPosEU posStart, BlockPosEU posEnd, float partialTicks, int r, int g, int b) {
        float expand;
        if (posStart != null && posEnd != null && mode.isAreaMode()) {
            int minX = Math.min(posStart.posX, posEnd.posX);
            int minY = Math.min(posStart.posY, posEnd.posY);
            int minZ = Math.min(posStart.posZ, posEnd.posZ);
            int maxX = Math.max(posStart.posX, posEnd.posX) + 1;
            int maxY = Math.max(posStart.posY, posEnd.posY) + 1;
            int maxZ = Math.max(posStart.posZ, posEnd.posZ) + 1;
            AxisAlignedBB aabb = BuildersWandRenderer.makeBoundingBox(minX, minY, minZ, maxX, maxY, maxZ, 0.0, partialTicks, player);
            RenderGlobal.func_189697_a((AxisAlignedBB)aabb, (float)((float)r / 255.0f), (float)((float)g / 255.0f), (float)((float)b / 255.0f), (float)0.8f);
        }
        float f = expand = mode == ItemBuildersWand.Mode.REPLACE || mode.hasTwoPlacableCorners() ? 0.001f : 0.0f;
        if (posStart != null) {
            GL11.glLineWidth((float)3.0f);
            AxisAlignedBB aabb = BuildersWandRenderer.makeBlockBoundingBox(posStart.posX, posStart.posY, posStart.posZ, expand, partialTicks, player);
            RenderGlobal.func_189697_a((AxisAlignedBB)aabb, (float)1.0f, (float)0.06666667f, (float)0.06666667f, (float)1.0f);
        }
        if (posEnd != null && (mode.isAreaMode() || mode == ItemBuildersWand.Mode.WALLS || mode == ItemBuildersWand.Mode.CUBE)) {
            GL11.glLineWidth((float)3.0f);
            AxisAlignedBB aabb = BuildersWandRenderer.makeBlockBoundingBox(posEnd.posX, posEnd.posY, posEnd.posZ, expand, partialTicks, player);
            RenderGlobal.func_189697_a((AxisAlignedBB)aabb, (float)0.06666667f, (float)0.06666667f, (float)1.0f, (float)1.0f);
        }
    }

    private void renderGhostBlocks(EntityPlayer player, float partialTicks) {
        int i;
        double dx = player.field_70142_S + (player.field_70165_t - player.field_70142_S) * (double)partialTicks;
        double dy = player.field_70137_T + (player.field_70163_u - player.field_70137_T) * (double)partialTicks;
        double dz = player.field_70136_U + (player.field_70161_v - player.field_70136_U) * (double)partialTicks;
        if (partialTicks < this.partialTicksLast) {
            for (i = 0; i < this.positions.size(); ++i) {
                BlockPosStateDist pos = this.positions.get(i);
                pos.setSquaredDistance(pos.getSquaredDistanceFrom(dx, dy, dz));
            }
            Collections.sort(this.positions);
            Collections.reverse(this.positions);
        }
        this.mc.func_110434_K().func_110577_a(TextureMap.field_110575_b);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        for (i = 0; i < this.positions.size(); ++i) {
            BlockPosStateDist posEU = this.positions.get(i);
            if (posEU.blockInfo == null || posEU.blockInfo.blockStateActual == null) continue;
            IBlockState stateActual = posEU.blockInfo.blockStateActual;
            BlockPos pos = posEU.toBlockPos();
            GlStateManager.func_179094_E();
            GlStateManager.func_179089_o();
            GlStateManager.func_179126_j();
            GlStateManager.func_179137_b((double)((double)posEU.posX - dx), (double)((double)posEU.posY - dy), (double)((double)posEU.posZ - dz));
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            if (!this.mc.field_71441_e.func_175623_d(pos)) {
                GlStateManager.func_179137_b((double)-0.001, (double)-0.001, (double)-0.001);
                GlStateManager.func_179139_a((double)1.002, (double)1.002, (double)1.002);
            }
            if (Configs.buildersWandUseTranslucentGhostBlocks) {
                IBakedModel model = this.mc.func_175602_ab().func_184389_a(stateActual);
                int alpha = (int)(Configs.buildersWandGhostBlockAlpha * 255.0f) << 24;
                GlStateManager.func_179147_l();
                GlStateManager.func_179098_w();
                GlStateManager.func_179112_b((int)770, (int)771);
                GlStateManager.func_179135_a((boolean)false, (boolean)false, (boolean)false, (boolean)false);
                this.renderModel(stateActual, model, pos, alpha);
                GlStateManager.func_179135_a((boolean)true, (boolean)true, (boolean)true, (boolean)true);
                GlStateManager.func_179143_c((int)515);
                this.renderModel(stateActual, model, pos, alpha);
                GlStateManager.func_179084_k();
            } else {
                GlStateManager.func_179114_b((float)-90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                Minecraft.func_71410_x().func_175602_ab().func_175016_a(stateActual, 0.9f);
            }
            GlStateManager.func_179121_F();
        }
    }

    public void renderHud() {
        ItemStack stack = this.mc.field_71439_g.func_184614_ca();
        if (stack == null || stack.func_77973_b() != EnderUtilitiesItems.buildersWand) {
            return;
        }
        ArrayList<String> lines = new ArrayList<String>();
        this.getText(lines, stack);
        ScaledResolution scaledResolution = new ScaledResolution(this.mc);
        int scaledY = scaledResolution.func_78328_b();
        int lineHeight = this.mc.field_71466_p.field_78288_b + 2;
        int y = scaledY - lineHeight * lines.size();
        this.renderText(4, y, lines);
    }

    private void renderText(int posX, int posY, List<String> lines) {
        int y = posY;
        boolean useTextBackground = true;
        boolean useFontShadow = true;
        int textBgColor = Integer.MIN_VALUE;
        FontRenderer fontRenderer = this.mc.field_71466_p;
        for (String line : lines) {
            if (useTextBackground) {
                Gui.func_73734_a((int)(posX - 2), (int)(y - 2), (int)(posX + fontRenderer.func_78256_a(line) + 2), (int)(y + fontRenderer.field_78288_b), (int)textBgColor);
            }
            if (useFontShadow) {
                this.mc.field_71456_v.func_73731_b(fontRenderer, line, posX, y, -1);
            } else {
                fontRenderer.func_78276_b(line, posX, y, -1);
            }
            y += fontRenderer.field_78288_b + 2;
        }
    }

    private void getText(List<String> lines, ItemStack stack) {
        String str;
        ItemBuildersWand wand = (ItemBuildersWand)stack.func_77973_b();
        ItemBuildersWand.Mode mode = ItemBuildersWand.Mode.getMode(stack);
        String preGreen = TextFormatting.GREEN.toString();
        String preRed = TextFormatting.RED.toString();
        String rst = TextFormatting.RESET.toString() + TextFormatting.WHITE.toString();
        String preIta = TextFormatting.ITALIC.toString();
        String strNo = I18n.func_135052_a((String)"enderutilities.tooltip.item.no", (Object[])new Object[0]);
        String strYes = I18n.func_135052_a((String)"enderutilities.tooltip.item.yes", (Object[])new Object[0]);
        int index = wand.getSelectionIndex(stack);
        if (mode.isAreaMode()) {
            String strFacing;
            if (mode == ItemBuildersWand.Mode.DELETE || mode == ItemBuildersWand.Mode.MOVE_SRC || mode == ItemBuildersWand.Mode.MOVE_DST) {
                str = I18n.func_135052_a((String)"enderutilities.tooltip.item.area", (Object[])new Object[0]);
                lines.add(String.format("%s: [%s%d/%d%s]", str, preGreen, index + 1, 16, rst));
            } else {
                str = I18n.func_135052_a((String)"enderutilities.tooltip.item.template", (Object[])new Object[0]);
                String name = wand.getTemplateName(stack, mode);
                lines.add(String.format("%s [%s%d/%d%s]: %s%s%s", str, preGreen, index + 1, 16, rst, preIta, name, rst));
            }
            str = I18n.func_135052_a((String)"enderutilities.tooltip.item.rotation", (Object[])new Object[0]);
            EnumFacing facing = wand.getAreaFacing(stack, mode);
            String string = strFacing = facing != null ? preGreen + facing.toString().toLowerCase() : preRed + "N/A";
            if (wand.isMirrored(stack)) {
                String mirror = wand.getMirror(stack) == Mirror.FRONT_BACK ? "x" : "z";
                str = String.format("%s: %s%s - %s: %s%s%s", str, strFacing, rst, I18n.func_135052_a((String)"enderutilities.tooltip.item.mirror", (Object[])new Object[0]), preGreen, mirror, rst);
            } else {
                str = String.format("%s: %s%s - %s: %s%s%s", str, strFacing, rst, I18n.func_135052_a((String)"enderutilities.tooltip.item.mirror", (Object[])new Object[0]), preRed, strNo, rst);
            }
            lines.add(str);
        } else {
            str = I18n.func_135052_a((String)"enderutilities.tooltip.item.block", (Object[])new Object[0]);
            if (index >= 0) {
                lines.add(str + String.format(" [%s%d/%d%s]: %s%s", preGreen, index + 1, 16, rst, this.getBlockTypeName(wand, stack, index), rst));
            } else {
                lines.add(str + ": " + this.getBlockTypeName(wand, stack, index) + rst);
            }
            if (mode != ItemBuildersWand.Mode.WALLS && mode != ItemBuildersWand.Mode.CUBE) {
                if (mode != ItemBuildersWand.Mode.REPLACE) {
                    str = I18n.func_135052_a((String)"enderutilities.tooltip.item.area.flipped", (Object[])new Object[0]);
                    str = str + ": " + (wand.getAreaFlipped(stack) ? preGreen + wand.getAreaFlipAxis(stack, EnumFacing.UP) : preRed + strNo) + rst;
                    str = str + " - " + I18n.func_135052_a((String)"enderutilities.tooltip.item.move", (Object[])new Object[0]);
                    lines.add(str + ": " + (wand.getMovePosition(stack, mode) ? preGreen + strYes : preRed + strNo) + rst);
                }
                if (mode == ItemBuildersWand.Mode.COLUMN || mode == ItemBuildersWand.Mode.LINE || mode == ItemBuildersWand.Mode.PLANE || mode == ItemBuildersWand.Mode.EXTEND_AREA) {
                    str = I18n.func_135052_a((String)"enderutilities.tooltip.item.continuethrough", (Object[])new Object[0]);
                    lines.add(str + ": " + (wand.getContinueThrough(stack, mode) ? preGreen + strYes : preRed + strNo) + rst);
                } else if (mode == ItemBuildersWand.Mode.EXTEND_CONTINUOUS || mode == ItemBuildersWand.Mode.REPLACE && wand.getReplaceModeIsArea(stack)) {
                    str = I18n.func_135052_a((String)"enderutilities.tooltip.item.builderswand.allowdiagonals", (Object[])new Object[0]);
                    lines.add(str + ": " + (wand.getAllowDiagonals(stack, mode) ? preGreen + strYes : preRed + strNo) + rst);
                }
            }
        }
        String modeName = mode.getDisplayName();
        if (mode == ItemBuildersWand.Mode.REPLACE) {
            modeName = wand.getReplaceModeIsArea(stack) ? modeName + " (" + I18n.func_135052_a((String)"enderutilities.tooltip.item.area", (Object[])new Object[0]) + ")" : modeName + " (" + I18n.func_135052_a((String)"enderutilities.tooltip.item.single", (Object[])new Object[0]) + ")";
        }
        int modeId = mode.ordinal() + 1;
        int maxModeId = ItemBuildersWand.Mode.values().length;
        str = I18n.func_135052_a((String)"enderutilities.tooltip.item.mode", (Object[])new Object[0]);
        String strMode = String.format("%s [%s%d/%d%s]: %s%s%s", str, preGreen, modeId, maxModeId, rst, preGreen, modeName, rst);
        if (mode == ItemBuildersWand.Mode.PASTE || mode == ItemBuildersWand.Mode.MOVE_DST) {
            strMode = strMode + " - " + I18n.func_135052_a((String)"enderutilities.tooltip.item.replace", (Object[])new Object[0]);
            strMode = strMode + ": " + (wand.getReplaceExisting(stack, mode) ? preGreen + strYes : preRed + strNo) + rst;
        } else if (mode == ItemBuildersWand.Mode.DELETE) {
            strMode = strMode + " - " + I18n.func_135052_a((String)"enderutilities.tooltip.item.entities", (Object[])new Object[0]);
            strMode = strMode + ": " + (wand.getRemoveEntities(stack) ? preGreen + strYes : preRed + strNo) + rst;
        }
        lines.add(strMode);
    }

    private String getBlockTypeName(ItemBuildersWand wand, ItemStack stack, int index) {
        if (index >= 0) {
            ItemStack blockStack;
            BlockInfo blockInfo = wand.getSelectedFixedBlockType(stack);
            if (blockInfo != null && (blockStack = new ItemStack(blockInfo.block, 1, blockInfo.itemMeta)) != null && blockStack.func_77973_b() != null) {
                return TextFormatting.GREEN.toString() + blockStack.func_82833_r();
            }
            return TextFormatting.RED.toString() + "N/A";
        }
        if (index == -1) {
            return TextFormatting.AQUA.toString() + I18n.func_135052_a((String)"enderutilities.tooltip.item.blocktype.targeted", (Object[])new Object[0]);
        }
        return TextFormatting.AQUA.toString() + I18n.func_135052_a((String)"enderutilities.tooltip.item.blocktype.adjacent", (Object[])new Object[0]);
    }

    public static AxisAlignedBB makeBlockBoundingBox(int x, int y, int z, double expand, double partialTicks, EntityPlayer player) {
        return BuildersWandRenderer.makeBoundingBox(x, y, z, x + 1, y + 1, z + 1, expand, partialTicks, player);
    }

    public static AxisAlignedBB makeBoundingBox(int minX, int minY, int minZ, int maxX, int maxY, int maxZ, double expand, double partialTicks, EntityPlayer player) {
        double dx = player.field_70142_S + (player.field_70165_t - player.field_70142_S) * partialTicks;
        double dy = player.field_70137_T + (player.field_70163_u - player.field_70137_T) * partialTicks;
        double dz = player.field_70136_U + (player.field_70161_v - player.field_70136_U) * partialTicks;
        return new AxisAlignedBB((double)minX - dx - expand, (double)minY - dy - expand, (double)minZ - dz - expand, (double)maxX - dx + expand, (double)maxY - dy + expand, (double)maxZ - dz + expand);
    }

    private void renderModel(IBlockState state, IBakedModel model, BlockPos pos, int alpha) {
        Tessellator tessellator = Tessellator.func_178181_a();
        VertexBuffer buffer = tessellator.func_178180_c();
        buffer.func_181668_a(7, DefaultVertexFormats.field_176599_b);
        for (EnumFacing facing : EnumFacing.values()) {
            this.renderQuads(state, pos, buffer, model.func_188616_a(state, facing, 0L), alpha);
        }
        this.renderQuads(state, pos, buffer, model.func_188616_a(state, null, 0L), alpha);
        tessellator.func_78381_a();
    }

    private void renderQuads(IBlockState state, BlockPos pos, VertexBuffer buffer, List<BakedQuad> quads, int alpha) {
        int j = quads.size();
        for (int i = 0; i < j; ++i) {
            BakedQuad quad = quads.get(i);
            int color = quad.func_178211_c() == -1 ? alpha | 0xFFFFFF : this.getTint(state, pos, alpha, quad.func_178211_c());
            LightUtil.renderQuadColor((VertexBuffer)buffer, (BakedQuad)quad, (int)color);
        }
    }

    private int getTint(IBlockState state, BlockPos pos, int alpha, int tintIndex) {
        return alpha | this.mc.func_184125_al().func_186724_a(state, null, pos, tintIndex);
    }
}

