/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.enderutilities.event;

import fi.dy.masa.enderutilities.EnderUtilities;
import fi.dy.masa.enderutilities.event.InputEventHandler;
import fi.dy.masa.enderutilities.gui.client.GuiEnderUtilities;
import fi.dy.masa.enderutilities.item.ItemHandyBag;
import fi.dy.masa.enderutilities.network.PacketHandler;
import fi.dy.masa.enderutilities.network.message.MessageOpenGui;
import java.io.IOException;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.inventory.GuiInventory;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraftforge.client.event.GuiOpenEvent;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class GuiEventHandler {
    private static GuiEventHandler instance;
    private boolean handyBagShouldOpen;

    public GuiEventHandler() {
        instance = this;
    }

    public static GuiEventHandler instance() {
        return instance;
    }

    public void setHandyBagShouldOpen(boolean shouldOpen) {
        this.handyBagShouldOpen = shouldOpen;
    }

    @SubscribeEvent
    public void onGuiOpenEvent(GuiOpenEvent event) {
        InputEventHandler.resetModifiers();
        if (event.getGui() != null && event.getGui().getClass() == GuiInventory.class) {
            EntityPlayerSP player = FMLClientHandler.instance().getClientPlayerEntity();
            if (this.handyBagShouldOpen && ItemHandyBag.getOpenableBag((EntityPlayer)player) != null) {
                if (event.isCancelable()) {
                    event.setCanceled(true);
                }
                PacketHandler.INSTANCE.sendToServer((IMessage)new MessageOpenGui(player.field_71093_bK, 1001));
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public void mouseInputEvent(GuiScreenEvent.MouseInputEvent.Pre event) {
        if (event.getGui() instanceof GuiEnderUtilities) {
            try {
                event.getGui().func_146274_d();
                event.setCanceled(true);
            }
            catch (IOException e) {
                EnderUtilities.logger.warn("Exception while executing handleMouseInput() on {}", new Object[]{event.getGui().getClass().getName()});
            }
        }
    }

    @SubscribeEvent
    public void onPotionShiftEvent(GuiScreenEvent.PotionShiftEvent event) {
        if (event.getGui() instanceof GuiEnderUtilities) {
            event.setCanceled(true);
        }
    }
}

