/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.enderutilities.event;

import fi.dy.masa.enderutilities.block.BlockEnderUtilitiesPortal;
import fi.dy.masa.enderutilities.event.tasks.PlayerTaskScheduler;
import fi.dy.masa.enderutilities.item.ItemMobHarness;
import fi.dy.masa.enderutilities.item.base.IChunkLoadingItem;
import fi.dy.masa.enderutilities.item.base.IModular;
import fi.dy.masa.enderutilities.item.base.ItemModule;
import fi.dy.masa.enderutilities.setup.EnderUtilitiesBlocks;
import fi.dy.masa.enderutilities.setup.EnderUtilitiesItems;
import fi.dy.masa.enderutilities.util.ChunkLoading;
import fi.dy.masa.enderutilities.util.EntityUtils;
import fi.dy.masa.enderutilities.util.nbt.TargetData;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;

public class TickHandler {
    private Set<UUID> portalFlags = new HashSet<UUID>();
    private int serverTickCounter;
    private int playerTickCounter;

    public void Tickhandler() {
        this.serverTickCounter = 0;
        this.playerTickCounter = 0;
    }

    @SubscribeEvent
    public void onServerTick(TickEvent.ServerTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            return;
        }
        if (++this.serverTickCounter >= 20) {
            this.serverTickCounter = 0;
            ChunkLoading.getInstance().tickChunkTimeouts();
        }
        ++this.playerTickCounter;
    }

    @SubscribeEvent
    public void onPlayerTick(TickEvent.PlayerTickEvent event) {
        EntityPlayer player = event.player;
        if (event.side == Side.CLIENT || player.field_70170_p.field_72995_K) {
            return;
        }
        if (event.phase == TickEvent.Phase.START) {
            World world = player.field_70170_p;
            BlockPos pos = player.func_180425_c();
            IBlockState state = world.func_180495_p(pos);
            UUID uuid = player.func_110124_au();
            if (state.func_177230_c() == EnderUtilitiesBlocks.blockPortal) {
                if (!this.portalFlags.contains(uuid)) {
                    ((BlockEnderUtilitiesPortal)state.func_177230_c()).teleportEntity(world, pos, state, (Entity)player);
                    this.portalFlags.add(uuid);
                }
            } else if (this.portalFlags.contains(uuid)) {
                this.portalFlags.remove(uuid);
            }
            return;
        }
        if (this.playerTickCounter % 40 == 0) {
            TargetData target;
            NBTTagCompound nbt;
            ItemStack stack;
            if (player.func_184218_aH() && player.field_71071_by.func_70431_c(new ItemStack((Item)EnderUtilitiesItems.mobHarness))) {
                ItemMobHarness.addAITask(player.func_184187_bx(), false);
            }
            if ((stack = EntityUtils.getHeldItemOfType((EntityLivingBase)player, IChunkLoadingItem.class)) != null && (nbt = stack.func_77978_p()) != null && nbt.func_74767_n("ChunkLoadingRequired") && (target = stack.func_77973_b() instanceof IModular ? TargetData.getTargetFromSelectedModule(stack, ItemModule.ModuleType.TYPE_LINKCRYSTAL) : TargetData.getTargetFromItem(stack)) != null) {
                ChunkLoading.getInstance().refreshChunkTimeout(target.dimension, target.pos.func_177958_n() >> 4, target.pos.func_177952_p() >> 4);
            }
        }
        PlayerTaskScheduler.getInstance().runTasks(player.field_70170_p, player);
    }
}

