/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.enderutilities.event.tasks;

import fi.dy.masa.enderutilities.event.tasks.IPlayerTask;
import fi.dy.masa.enderutilities.item.ItemBuildersWand;
import fi.dy.masa.enderutilities.setup.EnderUtilitiesItems;
import fi.dy.masa.enderutilities.util.BlockPosBox;
import fi.dy.masa.enderutilities.util.EntityUtils;
import fi.dy.masa.enderutilities.util.PositionUtils;
import fi.dy.masa.enderutilities.util.nbt.NBTUtils;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class TaskMoveArea
implements IPlayerTask {
    protected final BlockPos posSrcStart;
    protected final BlockPos posDstStart;
    protected final Rotation rotation;
    protected final Mirror mirror;
    protected final UUID wandUUID;
    protected final int dimension;
    protected final int blocksPerTick;
    protected final BlockPosBox boxRelative;
    protected final BlockPosBox boxSource;
    protected final Set<BlockPos> handledPositions;
    protected int listIndex = 0;
    protected int placedCount = 0;
    protected int failCount = 0;
    protected BlockPos overlappingRelativePos = null;
    protected IBlockState overlappingState;
    protected NBTTagCompound overlappingNBT;
    protected boolean shouldExit = false;

    public TaskMoveArea(int dimension, BlockPos posSrcStart, BlockPos posSrcEnd, BlockPos posDstStart, Rotation rotationDst, Mirror mirrorDst, UUID wandUUID, int blocksPerTick) {
        this.posSrcStart = posSrcStart;
        this.posDstStart = posDstStart;
        this.rotation = rotationDst;
        this.mirror = mirrorDst;
        this.wandUUID = wandUUID;
        this.dimension = dimension;
        this.blocksPerTick = blocksPerTick;
        this.boxRelative = new BlockPosBox(BlockPos.field_177992_a, posSrcEnd.func_177973_b((Vec3i)posSrcStart));
        this.boxSource = new BlockPosBox(posSrcStart, posSrcEnd);
        this.handledPositions = new HashSet<BlockPos>();
    }

    @Override
    public void init() {
    }

    @Override
    public boolean canExecute(World world, EntityPlayer player) {
        return world.field_73011_w.getDimension() == this.dimension;
    }

    @Override
    public boolean execute(World world, EntityPlayer player) {
        ItemStack stack = EntityUtils.getHeldItemOfType((EntityLivingBase)player, EnderUtilitiesItems.buildersWand);
        if (stack != null && this.wandUUID.equals(NBTUtils.getUUIDFromItemStack(stack, "BuildersWand", false))) {
            this.moveBlock(world, player, stack);
        } else {
            ++this.failCount;
        }
        if (this.shouldExit || this.failCount > 200) {
            world.func_184133_a(null, player.func_180425_c(), SoundEvents.field_187676_dE, SoundCategory.BLOCKS, 0.6f, 1.0f);
            return true;
        }
        if (this.listIndex >= this.boxRelative.count) {
            world.func_184133_a(null, player.func_180425_c(), SoundEvents.field_189107_dL, SoundCategory.BLOCKS, 0.6f, 1.0f);
            return true;
        }
        return false;
    }

    private void moveBlock(World world, EntityPlayer player, ItemStack stack) {
        ItemBuildersWand wand = (ItemBuildersWand)stack.func_77973_b();
        int i = 0;
        while (i < this.blocksPerTick && this.listIndex < this.boxRelative.count) {
            TileEntity te;
            BlockPos posRelative;
            if (!ItemBuildersWand.hasEnoughCharge(stack, player)) {
                this.shouldExit = true;
                break;
            }
            IBlockState stateNew = null;
            NBTTagCompound nbt = null;
            if (this.overlappingRelativePos != null) {
                posRelative = this.overlappingRelativePos;
                stateNew = this.overlappingState;
                nbt = this.overlappingNBT;
                this.overlappingRelativePos = null;
                this.overlappingNBT = null;
            } else {
                posRelative = this.boxRelative.getPosAtIndex(this.listIndex);
                ++this.listIndex;
            }
            if (this.handledPositions.contains(posRelative)) continue;
            BlockPos posSrc = this.posSrcStart.func_177971_a((Vec3i)posRelative);
            BlockPos posDst = PositionUtils.getTransformedBlockPos(posRelative, this.mirror, this.rotation).func_177971_a((Vec3i)this.posDstStart);
            boolean replace = wand.getReplaceExisting(stack, ItemBuildersWand.Mode.MOVE_DST);
            boolean destinationOverlapsSource = this.boxSource.containsPosition(posDst);
            if (!replace && !destinationOverlapsSource && !world.func_175623_d(posDst) || !this.canMoveBlock(world, posSrc, posDst, player, stack)) {
                this.handledPositions.add(posRelative);
                continue;
            }
            if (stateNew == null) {
                stateNew = world.func_180495_p(posSrc).func_185899_b((IBlockAccess)world, posSrc);
                if (stateNew.func_177230_c().hasTileEntity(stateNew) && (te = world.func_175625_s(posSrc)) != null) {
                    nbt = new NBTTagCompound();
                    nbt = te.func_189515_b(nbt);
                }
                world.restoringBlockSnapshots = true;
                world.func_180501_a(posSrc, Blocks.field_150350_a.func_176223_P(), 2);
                world.restoringBlockSnapshots = false;
            }
            if (destinationOverlapsSource) {
                this.overlappingRelativePos = posDst.func_177973_b((Vec3i)this.posSrcStart);
                this.overlappingState = world.func_180495_p(posDst).func_185899_b((IBlockAccess)world, posDst);
                if (this.overlappingState.func_177230_c().hasTileEntity(this.overlappingState) && (te = world.func_175625_s(posDst)) != null) {
                    this.overlappingNBT = new NBTTagCompound();
                    this.overlappingNBT = te.func_189515_b(this.overlappingNBT);
                }
                world.restoringBlockSnapshots = true;
                world.func_180501_a(posDst, Blocks.field_150350_a.func_176223_P(), 2);
                world.restoringBlockSnapshots = false;
            }
            if (wand.placeBlockToPosition(stack, world, player, posDst, EnumFacing.UP, stateNew = stateNew.func_185902_a(this.mirror).func_185907_a(this.rotation), 2, false, true)) {
                if (nbt != null && (te = world.func_175625_s(posDst)) != null) {
                    NBTUtils.setPositionInTileEntityNBT(nbt, posDst);
                    te.func_145839_a(nbt);
                    te.func_70296_d();
                }
                ++this.placedCount;
                this.failCount = 0;
                ++i;
            }
            this.handledPositions.add(posRelative);
        }
    }

    public boolean canMoveBlock(World world, BlockPos posSrc, BlockPos posDst, EntityPlayer player, ItemStack stack) {
        return ItemBuildersWand.canManipulateBlock(world, posSrc, player, stack, true) && ItemBuildersWand.canManipulateBlock(world, posDst, player, stack, true);
    }

    @Override
    public void stop() {
        this.handledPositions.clear();
    }
}

